/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.flow.FlowDiscoveryCDIContext;
import com.sun.faces.flow.FlowDiscoveryCDIHelper;
import com.sun.faces.flow.FlowDiscoveryInfo;
import com.sun.faces.util.FacesLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.faces.flow.FlowDefinition;
import javax.inject.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowDiscoveryCDIExtension
implements Extension {
    private static final Logger LOGGER = FacesLogger.FLOW.getLogger();
    private Map<Contextual<?>, FlowDiscoveryInfo> flowBuilders;

    public FlowDiscoveryCDIExtension() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ctor for Flow CDI Extensions called");
        }
        this.flowBuilders = new ConcurrentHashMap();
    }

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType<FlowDiscoveryCDIHelper> flowDiscoveryHelper = beanManager.createAnnotatedType(FlowDiscoveryCDIHelper.class);
        event.addAnnotatedType(flowDiscoveryHelper);
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        event.addContext(new FlowDiscoveryCDIContext(this.flowBuilders));
        this.flowBuilders.clear();
    }

    public void processBean(@Observes ProcessBean<?> event) {
        FlowDefinition flowDefinition = event.getAnnotated().getAnnotation(FlowDefinition.class);
        if (null != flowDefinition) {
            Class<?> definingClass = event.getBean().getBeanClass();
            Named named = event.getAnnotated().getAnnotation(Named.class);
            String id = named.value();
            FlowDiscoveryInfo info = new FlowDiscoveryInfo(definingClass, id, flowDefinition.definingDocumentId());
            this.flowBuilders.put(event.getBean(), info);
        }
    }
}

