/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.v3.services.impl.MapperUpdateListener;
import com.sun.enterprise.web.WebContainer;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.catalina.LifecycleException;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.web.config.serverbeans.ManagerProperties;
import org.glassfish.web.config.serverbeans.WebContainerAvailability;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

public class WebConfigListener
implements ConfigListener,
MapperUpdateListener {
    public static final String CHANGE_INVOKED = "AS-WEB-00299";
    public static final String EXCEPTION_WEB_CONFIG = "AS-WEB-00300";
    @Inject
    @Named(value="default-instance-name")
    public HttpService httpService;
    @Inject
    @Optional
    public ManagerProperties managerProperties;
    @Inject
    @Optional
    public List<Property> property;
    private WebContainer container;
    private Logger logger;
    private NetworkConfig networkConfig;

    public void setContainer(WebContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogger(Logger logger2) {
        WebConfigListener webConfigListener = this;
        synchronized (webConfigListener) {
            this.logger = logger2;
        }
    }

    public void setNetworkConfig(NetworkConfig config) {
        this.networkConfig = config;
    }

    @Override
    public synchronized UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> tClass, T t) {
                if (WebConfigListener.this.logger.isLoggable(Level.FINE)) {
                    WebConfigListener.this.logger.log(Level.FINE, WebConfigListener.CHANGE_INVOKED, new Object[]{type2, tClass, t});
                }
                try {
                    if (tClass == HttpService.class) {
                        WebConfigListener.this.container.updateHttpService((HttpService)t);
                    } else if (tClass == NetworkListener.class) {
                        if (type2 == Changed.TYPE.ADD) {
                            WebConfigListener.this.container.addConnector((NetworkListener)t, WebConfigListener.this.httpService, true);
                        } else if (type2 == Changed.TYPE.REMOVE) {
                            WebConfigListener.this.container.deleteConnector((NetworkListener)t);
                        } else if (type2 == Changed.TYPE.CHANGE) {
                            WebConfigListener.this.container.updateConnector((NetworkListener)t, WebConfigListener.this.httpService);
                        }
                    } else if (tClass == VirtualServer.class) {
                        if (type2 == Changed.TYPE.ADD) {
                            WebConfigListener.this.container.createHost((VirtualServer)t, WebConfigListener.this.httpService, null);
                            WebConfigListener.this.container.loadDefaultWebModule((VirtualServer)t);
                        } else if (type2 == Changed.TYPE.REMOVE) {
                            WebConfigListener.this.container.deleteHost(WebConfigListener.this.httpService);
                        } else if (type2 == Changed.TYPE.CHANGE) {
                            WebConfigListener.this.container.updateHost((VirtualServer)t);
                        }
                    } else if (tClass == AccessLog.class) {
                        WebConfigListener.this.container.updateAccessLog(WebConfigListener.this.httpService);
                    } else {
                        if (tClass == ManagerProperties.class) {
                            return new NotProcessed("ManagerProperties requires restart");
                        }
                        if (tClass == WebContainerAvailability.class || tClass == AvailabilityService.class) {
                            WebConfigListener.this.container.updateHttpService(WebConfigListener.this.httpService);
                        } else if (tClass != NetworkListeners.class) {
                            if (tClass == Property.class) {
                                ConfigBeanProxy config = ((Property)t).getParent();
                                if (config instanceof HttpService) {
                                    WebConfigListener.this.container.updateHttpService((HttpService)config);
                                } else if (config instanceof VirtualServer) {
                                    WebConfigListener.this.container.updateHost((VirtualServer)config);
                                } else if (config instanceof NetworkListener) {
                                    WebConfigListener.this.container.updateConnector((NetworkListener)config, WebConfigListener.this.httpService);
                                } else {
                                    WebConfigListener.this.container.updateHttpService(WebConfigListener.this.httpService);
                                }
                            } else if (tClass == SystemProperty.class) {
                                if (((SystemProperty)t).getName().endsWith("LISTENER_PORT")) {
                                    for (NetworkListener listener : WebConfigListener.this.networkConfig.getNetworkListeners().getNetworkListener()) {
                                        if (!listener.getPort().equals(((SystemProperty)t).getValue())) continue;
                                        WebConfigListener.this.container.updateConnector(listener, WebConfigListener.this.httpService);
                                    }
                                }
                            } else if (tClass == JavaConfig.class) {
                                JavaConfig jc = (JavaConfig)t;
                                ArrayList<String> jvmOptions = new ArrayList<String>(jc.getJvmOptions());
                                for (String jvmOption : jvmOptions) {
                                    if (!jvmOption.startsWith("-DjvmRoute=")) continue;
                                    WebConfigListener.this.container.updateJvmRoute(WebConfigListener.this.httpService, jvmOption);
                                }
                            }
                        }
                    }
                }
                catch (LifecycleException le) {
                    WebConfigListener.this.logger.log(Level.SEVERE, WebConfigListener.EXCEPTION_WEB_CONFIG, le);
                }
                return null;
            }
        }, this.logger);
    }

    @Override
    public void update(HttpService httpService, NetworkListener httpListener, Mapper mapper) {
        this.container.updateMapper(httpService, httpListener, mapper);
    }
}

