/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import com.sun.enterprise.v3.services.impl.monitor.stats.ConnectionQueueStatsProvider;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="connection-queue-mon", group="monitoring")
@ManagedObject
@Description(value="Connection Queue Statistics")
public class ConnectionQueueStatsProviderGlobal
extends ConnectionQueueStatsProvider {
    public ConnectionQueueStatsProviderGlobal(String name) {
        super(name);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:connection-queue:connectionAcceptedEvent")
    public void connectionAcceptedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="connection") int connectionId, @ProbeParam(value="address") String address) {
        this.countTotalConnections.increment();
        this.openConnectionsCount.put(connectionId, System.currentTimeMillis());
    }

    @Override
    @ProbeListener(value="glassfish:kernel:connection-queue:connectionClosedEvent")
    public void connectionClosedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="connection") int connectionId) {
        this.openConnectionsCount.remove(connectionId);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:connection-queue:setMaxTaskQueueSizeEvent")
    public void setMaxTaskQueueSizeEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="size") int size) {
        this.maxQueued.setCount(size);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:connection-queue:onTaskQueuedEvent")
    public void onTaskQueuedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="task") String taskId) {
        int peakQueue;
        int queued = this.countQueuedAtomic.incrementAndGet();
        this.countQueued.setCount(queued);
        while (queued > (peakQueue = this.peakQueuedAtomic.get())) {
            if (!this.peakQueuedAtomic.compareAndSet(peakQueue, queued)) continue;
            this.peakQueued.setCount(queued);
            break;
        }
        this.countTotalQueued.increment();
        this.incAverageMinute();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:connection-queue:onTaskDequeuedEvent")
    public void onTaskDequeuedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="task") String taskId) {
        this.countQueued.setCount(this.countQueuedAtomic.decrementAndGet());
    }

    @Override
    @ProbeListener(value="glassfish:kernel:connection-queue:onTaskQueueOverflowEvent")
    public void onTaskQueueOverflowEvent(@ProbeParam(value="listenerName") String listenerName) {
        this.countOverflows.increment();
    }
}

