/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.stats.FileCacheStatsProvider;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.server.filecache.FileCacheEntry;
import org.glassfish.grizzly.http.server.filecache.FileCacheProbe;

public class FileCacheMonitor
implements FileCacheProbe {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String monitoringId;

    public FileCacheMonitor(GrizzlyMonitoring grizzlyMonitoring, String monitoringId, FileCache config) {
        FileCacheStatsProvider statsProvider;
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
        if (grizzlyMonitoring != null && (statsProvider = grizzlyMonitoring.getFileCacheStatsProvider(monitoringId)) != null) {
            statsProvider.setStatsObject(config);
        }
    }

    @Override
    public void onEntryAddedEvent(FileCache fileCache, FileCacheEntry entry) {
        this.grizzlyMonitoring.getFileCacheProbeProvider().incOpenCacheEntriesEvent(this.monitoringId);
        switch (entry.type) {
            case HEAP: {
                this.grizzlyMonitoring.getFileCacheProbeProvider().addHeapSizeEvent(this.monitoringId, entry.contentLength);
                break;
            }
            case MAPPED: {
                this.grizzlyMonitoring.getFileCacheProbeProvider().addMappedMemorySizeEvent(this.monitoringId, entry.contentLength);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + (Object)((Object)entry.type));
            }
        }
    }

    @Override
    public void onEntryRemovedEvent(FileCache fileCache, FileCacheEntry entry) {
        this.grizzlyMonitoring.getFileCacheProbeProvider().decOpenCacheEntriesEvent(this.monitoringId);
        switch (entry.type) {
            case HEAP: {
                this.grizzlyMonitoring.getFileCacheProbeProvider().subHeapSizeEvent(this.monitoringId, entry.contentLength);
                break;
            }
            case MAPPED: {
                this.grizzlyMonitoring.getFileCacheProbeProvider().subMappedMemorySizeEvent(this.monitoringId, entry.contentLength);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + (Object)((Object)entry.type));
            }
        }
    }

    @Override
    public void onEntryHitEvent(FileCache fileCache, FileCacheEntry entry) {
        this.grizzlyMonitoring.getFileCacheProbeProvider().countHitEvent(this.monitoringId);
        switch (entry.type) {
            case HEAP: {
                this.grizzlyMonitoring.getFileCacheProbeProvider().countInfoHitEvent(this.monitoringId);
                break;
            }
            case MAPPED: {
                this.grizzlyMonitoring.getFileCacheProbeProvider().countContentHitEvent(this.monitoringId);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + (Object)((Object)entry.type));
            }
        }
    }

    @Override
    public void onEntryMissedEvent(FileCache fileCache, String host, String requestURI) {
        this.grizzlyMonitoring.getFileCacheProbeProvider().countMissEvent(this.monitoringId);
    }

    @Override
    public void onErrorEvent(FileCache fileCache, Throwable error) {
    }
}

