/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.services.impl.DynamicConfigListener;
import com.sun.enterprise.v3.services.impl.Endpoint;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.MapperUpdateListener;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.impl.UnsafeFutureImpl;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.Transactions;

@Service
@RunLevel(value=10)
public class GrizzlyService
implements RequestDispatcher,
PostConstruct,
PreDestroy,
FutureProvider<Result<Thread>> {
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    private ServiceLocator habitat;
    @Inject
    Transactions transactions;
    final Logger logger = KernelLoggerInfo.getLogger();
    private final Collection<NetworkProxy> proxies = new LinkedBlockingQueue<NetworkProxy>();
    volatile List<Future<Result<Thread>>> futures;
    Collection<String> hosts = new ArrayList<String>();
    private final GrizzlyMonitoring monitoring;
    private static final String NETWORK_CONFIG_PREFIX = "";
    private final ConcurrentLinkedQueue<MapperUpdateListener> mapperUpdateListeners = new ConcurrentLinkedQueue();
    private DynamicConfigListener configListener;

    public GrizzlyService() {
        this.futures = new ArrayList<Future<Result<Thread>>>();
        this.monitoring = new GrizzlyMonitoring();
    }

    public void addNetworkProxy(NetworkProxy proxy) {
        this.proxies.add(proxy);
    }

    public boolean removeNetworkProxy(NetworkListener listener) {
        return this.removeNetworkProxy(this.lookupNetworkProxy(listener));
    }

    public boolean removeNetworkProxy(String id) {
        NetworkProxy proxy = null;
        for (NetworkProxy p : this.proxies) {
            if (!(p instanceof GrizzlyProxy)) continue;
            GrizzlyProxy grizzlyProxy = (GrizzlyProxy)p;
            if (grizzlyProxy.networkListener == null || grizzlyProxy.networkListener.getName() == null || !grizzlyProxy.networkListener.getName().equals(id)) continue;
            proxy = p;
            break;
        }
        return this.removeNetworkProxy(proxy);
    }

    public boolean removeNetworkProxy(NetworkProxy proxy) {
        if (proxy != null) {
            try {
                proxy.stop();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "NCLS-CORE-0055", e);
            }
            proxy.destroy();
            this.proxies.remove(proxy);
            return true;
        }
        return false;
    }

    public NetworkProxy lookupNetworkProxy(NetworkListener listener) {
        int listenerPort = -1;
        InetAddress address = null;
        try {
            listenerPort = Integer.parseInt(listener.getPort());
        }
        catch (NumberFormatException e) {
            this.logger.log(Level.FINE, e.toString());
        }
        try {
            address = InetAddress.getByName(listener.getAddress());
        }
        catch (UnknownHostException uhe) {
            this.logger.log(Level.FINE, uhe.toString());
        }
        if (listenerPort != -1) {
            for (NetworkProxy p : this.proxies) {
                if (p.getPort() != listenerPort || !p.getAddress().equals(address)) continue;
                return p;
            }
        }
        String listenerId = listener.getName();
        for (NetworkProxy p : this.proxies) {
            if (!(p instanceof GrizzlyProxy)) continue;
            GrizzlyProxy grizzlyProxy = (GrizzlyProxy)p;
            if (grizzlyProxy.networkListener == null || grizzlyProxy.networkListener.getName() == null || !grizzlyProxy.networkListener.getName().equals(listenerId)) continue;
            return p;
        }
        return null;
    }

    public void restartNetworkListener(String networkListenerName, long timeout, TimeUnit timeUnit) throws IOException, TimeoutException {
        this.restartNetworkListener(this.config.getNetworkConfig().getNetworkListener(networkListenerName), timeout, timeUnit);
    }

    public void restartNetworkListener(NetworkListener networkListener, long timeout, TimeUnit timeUnit) throws IOException, TimeoutException {
        Future<Result<Thread>> future;
        if (!this.removeNetworkProxy(networkListener)) {
            this.removeNetworkProxy(networkListener.getName());
        }
        if ((future = this.createNetworkProxy(networkListener)) == null) {
            this.logger.log(Level.FINE, "Skipping proxy registration for the listener {0}", networkListener.getName());
            return;
        }
        try {
            if (timeout <= 0L) {
                future.get();
            } else {
                future.get(timeout, timeUnit);
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.registerContainerAdapters();
    }

    public boolean hasMapperUpdateListener() {
        return !this.mapperUpdateListeners.isEmpty();
    }

    public boolean addMapperUpdateListener(MapperUpdateListener listener) {
        return this.mapperUpdateListeners.add(listener);
    }

    public boolean removeMapperUpdateListener(MapperUpdateListener listener) {
        return this.mapperUpdateListeners.remove(listener);
    }

    public void notifyMapperUpdateListeners(NetworkListener networkListener, Mapper mapper) {
        HttpService httpService = this.config.getHttpService();
        for (MapperUpdateListener listener : this.mapperUpdateListeners) {
            listener.update(httpService, networkListener, mapper);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ServiceLocator getHabitat() {
        return this.habitat;
    }

    public GrizzlyMonitoring getMonitoring() {
        return this.monitoring;
    }

    @Override
    public void postConstruct() {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        this.configListener = new DynamicConfigListener(this.config, this.logger);
        ObservableBean bean = (ObservableBean)((Object)ConfigSupport.getImpl(networkConfig.getNetworkListeners()));
        bean.addListener(this.configListener);
        bean = (ObservableBean)((Object)ConfigSupport.getImpl(this.config.getHttpService()));
        bean.addListener(this.configListener);
        this.transactions.addListenerForType(SystemProperty.class, this.configListener);
        this.configListener.setGrizzlyService(this);
        try {
            boolean isAtLeastOneProxyStarted = false;
            this.futures = new ArrayList<Future<Result<Thread>>>();
            for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
                isAtLeastOneProxyStarted |= this.createNetworkProxy(listener) != null;
            }
            if (isAtLeastOneProxyStarted) {
                this.registerContainerAdapters();
            }
        }
        catch (RuntimeException e) {
            this.logger.log(Level.SEVERE, "NCLS-CORE-0056", e);
            for (NetworkProxy proxy : this.proxies) {
                try {
                    proxy.stop();
                }
                catch (Exception proxyStopException) {
                    this.logger.log(Level.SEVERE, "NCLS-CORE-0057", new Object[]{proxy.getPort(), proxyStopException});
                }
            }
            throw e;
        }
        this.registerMonitoringStatsProviders();
    }

    @Override
    public List<Future<Result<Thread>>> getFutures() {
        return this.futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Future<Result<Thread>> createNetworkProxy(NetworkListener listener) {
        if (!Boolean.valueOf(listener.getEnabled()).booleanValue()) {
            this.addChangeListener(listener);
            this.logger.log(Level.INFO, "NCLS-CORE-0058", new Object[]{listener.getName(), listener.getPort()});
            return null;
        }
        GrizzlyProxy proxy = new GrizzlyProxy(this, listener);
        Future<Result<Thread>> future = null;
        try {
            proxy.initialize();
            if (!"light-weight-listener".equals(listener.getProtocol())) {
                NetworkConfig networkConfig = listener.getParent(NetworkListeners.class).getParent(NetworkConfig.class);
                for (VirtualServer vs : networkConfig.getParent(Config.class).getHttpService().getVirtualServer()) {
                    List<String> vsListeners = StringUtils.parseStringList(vs.getNetworkListeners(), " ,");
                    if (vsListeners != null && !vsListeners.isEmpty() && !vsListeners.contains(listener.getName()) || this.hosts.contains(vs.getId())) continue;
                    this.hosts.add(vs.getId());
                }
                this.addChangeListener(listener);
                this.addChangeListener(listener.findThreadPool());
                this.addChangeListener(listener.findTransport());
                Protocol protocol = listener.findHttpProtocol();
                if (protocol != null) {
                    this.addChangeListener(protocol);
                    this.addChangeListener(protocol.getHttp());
                    this.addChangeListener(protocol.getHttp().getFileCache());
                    this.addChangeListener(protocol.getSsl());
                }
            }
            future = proxy.start();
            this.proxies.add(proxy);
        }
        catch (Throwable e) {
            Future errorFuture = Futures.createReadyFuture(new Result(e));
            future = errorFuture;
        }
        finally {
            if (future == null) {
                UnsafeFutureImpl<Result<Thread>> errorFuture = UnsafeFutureImpl.create();
                errorFuture.result(new Result(new IllegalStateException("Unexpected error")));
                future = errorFuture;
            }
            this.futures.add(future);
        }
        return future;
    }

    private void addChangeListener(ConfigBeanProxy bean) {
        if (bean != null) {
            ((ObservableBean)((Object)ConfigSupport.getImpl(bean))).addListener(this.configListener);
        }
    }

    void registerContainerAdapters() {
        for (Adapter subAdapter : this.habitat.getAllServices(Adapter.class, new Annotation[0])) {
            try {
                if (subAdapter.isRegistered()) continue;
                this.registerAdapter(subAdapter);
                subAdapter.setRegistered(true);
            }
            catch (EndpointRegistrationException e) {
                this.logger.log(Level.WARNING, "NCLS-CORE-0059", e);
            }
        }
    }

    @Override
    public void preDestroy() {
        for (NetworkProxy proxy : this.proxies) {
            try {
                proxy.stop();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "NCLS-CORE-0055", e);
            }
        }
        this.unregisterMonitoringStatsProviders();
    }

    @Override
    public void registerEndpoint(String contextRoot, HttpHandler endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        this.registerEndpoint(contextRoot, endpointAdapter, container, null);
    }

    @Override
    public void registerEndpoint(String contextRoot, HttpHandler endpointAdapter, ApplicationContainer container, String virtualServers) throws EndpointRegistrationException {
        List<String> virtualServerList = virtualServers == null ? this.config.getHttpService().getNonAdminVirtualServerList() : StringUtils.parseStringList(virtualServers, ",");
        this.registerEndpoint(contextRoot, virtualServerList, endpointAdapter, container);
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, HttpHandler endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        List<AddressInfo> addressInfos = this.getAddressInfoFromVirtualServers(vsServers);
        for (AddressInfo info : addressInfos) {
            this.registerEndpoint(contextRoot, info.address, info.port, vsServers, endpointAdapter, container);
        }
    }

    @Override
    public void registerEndpoint(String contextRoot, InetAddress address, int port, Collection<String> vsServers, HttpHandler endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            if (proxy.getPort() != port || !proxy.getAddress().equals(address)) continue;
            proxy.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
        }
    }

    public void registerEndpoint(Endpoint endpoint) throws EndpointRegistrationException {
        InetAddress address = endpoint.getAddress();
        int port = endpoint.getPort();
        for (NetworkProxy proxy : this.proxies) {
            if (proxy.getPort() != port || !proxy.getAddress().equals(address)) continue;
            proxy.registerEndpoint(endpoint);
        }
    }

    @Override
    public void unregisterEndpoint(String contextRoot) throws EndpointRegistrationException {
        this.unregisterEndpoint(contextRoot, null);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            proxy.unregisterEndpoint(contextRoot, app);
        }
    }

    protected void registerMonitoringStatsProviders() {
        this.monitoring.registerThreadPoolStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.registerKeepAliveStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.registerFileCacheStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.registerConnectionQueueStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
    }

    protected void unregisterMonitoringStatsProviders() {
        this.monitoring.unregisterThreadPoolStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.unregisterKeepAliveStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.unregisterFileCacheStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.unregisterConnectionQueueStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
    }

    private void registerAdapter(Adapter a) throws EndpointRegistrationException {
        Endpoint endpoint = Endpoint.createEndpoint(a);
        this.registerEndpoint(endpoint);
    }

    private List<AddressInfo> getAddressInfoFromVirtualServers(Collection<String> virtualServers) {
        ArrayList<AddressInfo> addressInfos = new ArrayList<AddressInfo>();
        List<NetworkListener> networkListenerList = this.config.getNetworkConfig().getNetworkListeners().getNetworkListener();
        for (String vs : virtualServers) {
            VirtualServer virtualServer = this.config.getHttpService().getVirtualServerByName(vs);
            if (virtualServer == null) {
                this.logger.log(Level.WARNING, "NCLS-CORE-0060", vs);
                continue;
            }
            String vsNetworkListeners = virtualServer.getNetworkListeners();
            List<String> vsNetworkListenerList = StringUtils.parseStringList(vsNetworkListeners, ",");
            if (vsNetworkListenerList == null || vsNetworkListenerList.isEmpty()) continue;
            block1: for (String vsNetworkListener : vsNetworkListenerList) {
                for (NetworkListener networkListener : networkListenerList) {
                    if (!networkListener.getName().equals(vsNetworkListener) || !Boolean.valueOf(networkListener.getEnabled()).booleanValue()) continue;
                    addressInfos.add(new AddressInfo(networkListener.getAddress(), networkListener.getPort()));
                    continue block1;
                }
            }
        }
        return addressInfos;
    }

    private static final class AddressInfo {
        private InetAddress address;
        private final int port;

        private AddressInfo(String address, String port) {
            this.port = Integer.parseInt(port);
            try {
                this.address = InetAddress.getByName(address);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public static class NoopInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            return null;
        }
    }
}

