/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.v3.services.impl.ContainerMapper;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.HttpAdapter;
import com.sun.enterprise.v3.services.impl.monitor.ConnectionMonitor;
import com.sun.enterprise.v3.services.impl.monitor.FileCacheMonitor;
import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.KeepAliveMonitor;
import com.sun.enterprise.v3.services.impl.monitor.ThreadPoolMonitor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.config.GenericGrizzlyListener;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.internal.grizzly.V3Mapper;
import org.jvnet.hk2.config.types.Property;

public class GlassfishNetworkListener
extends GenericGrizzlyListener {
    private final GrizzlyService grizzlyService;
    private final Logger logger;
    private volatile HttpAdapter httpAdapter;

    public GlassfishNetworkListener(GrizzlyService grizzlyService, Logger logger2) {
        this.grizzlyService = grizzlyService;
        this.logger = logger2;
    }

    @Override
    public void start() throws IOException {
        this.registerMonitoringStatsProviders();
        super.start();
    }

    @Override
    public void stop() throws IOException {
        ServiceLocator locator = this.grizzlyService.getHabitat();
        IndexedFilter removeFilter = BuilderHelper.createNameAndContractFilter(Mapper.class.getName(), this.address.toString() + this.port);
        DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter(removeFilter);
        config.commit();
        this.unregisterMonitoringStatsProviders();
        super.stop();
    }

    @Override
    public <T> T getAdapter(Class<T> adapterClass) {
        if (HttpAdapter.class.equals(adapterClass)) {
            return (T)this.httpAdapter;
        }
        return super.getAdapter(adapterClass);
    }

    @Override
    protected void configureTransport(NetworkListener networkListener, Transport transportConfig, FilterChainBuilder filterChainBuilder) {
        super.configureTransport(networkListener, transportConfig, filterChainBuilder);
        this.transport.getConnectionMonitoringConfig().addProbes((ConnectionProbe[])new ConnectionProbe[]{new ConnectionMonitor(this.grizzlyService.getMonitoring(), this.name, this.transport)});
    }

    @Override
    protected void configureHttpProtocol(ServiceLocator habitat, NetworkListener networkListener, Http http, FilterChainBuilder filterChainBuilder) {
        if (this.httpAdapter == null) {
            this.registerMonitoringStatsProviders();
            V3Mapper mapper = new V3Mapper(this.logger);
            mapper.setPort(this.port);
            mapper.setId(this.name);
            ContainerMapper containerMapper = new ContainerMapper(this.grizzlyService, this);
            containerMapper.setMapper(mapper);
            containerMapper.setDefaultHost(http.getDefaultVirtualServer());
            containerMapper.configureMapper();
            VirtualServer vs = null;
            String webAppRootPath = null;
            List<VirtualServer> list = this.grizzlyService.getHabitat().getAllServices(VirtualServer.class, new Annotation[0]);
            String vsName = http.getDefaultVirtualServer();
            for (VirtualServer virtualServer : list) {
                if (!virtualServer.getId().equals(vsName)) continue;
                vs = virtualServer;
                webAppRootPath = vs.getDocroot();
                if (this.grizzlyService.hasMapperUpdateListener() || vs.getProperty() == null || vs.getProperty().isEmpty()) break;
                for (Property p : vs.getProperty()) {
                    String propertyName = p.getName();
                    if (!propertyName.startsWith("alternatedocroot")) continue;
                    String value = p.getValue();
                    String[] mapping = value.split(" ");
                    if (mapping.length != 2) {
                        this.logger.log(Level.WARNING, "Invalid alternate_docroot {0}", value);
                        continue;
                    }
                    String docBase = mapping[1].substring("dir=".length());
                    String urlPattern = mapping[0].substring("from=".length());
                    StaticHttpHandler staticResourceService = new StaticHttpHandler(new String[]{docBase});
                    List<String> al = GlassfishNetworkListener.toArray(vs.getHosts(), ";");
                    al.add(http.getDefaultVirtualServer());
                    containerMapper.register(urlPattern, al, staticResourceService, null);
                }
            }
            this.httpAdapter = new HttpAdapterImpl(vs, containerMapper, webAppRootPath);
            containerMapper.addDocRoot(webAppRootPath);
            AbstractActiveDescriptor<V3Mapper> aad = BuilderHelper.createConstantDescriptor(mapper);
            aad.addContractType((Type)((Object)Mapper.class));
            aad.setName(this.address.toString() + this.port);
            ServiceLocatorUtilities.addOneDescriptor(this.grizzlyService.getHabitat(), aad);
            super.configureHttpProtocol(habitat, networkListener, http, filterChainBuilder);
            Protocol protocol = http.getParent();
            for (NetworkListener listener : protocol.findNetworkListeners()) {
                this.grizzlyService.notifyMapperUpdateListeners(listener, mapper);
            }
        } else {
            super.configureHttpProtocol(habitat, networkListener, http, filterChainBuilder);
        }
    }

    @Override
    protected HttpHandler getHttpHandler() {
        return this.httpAdapter.getMapper();
    }

    @Override
    protected KeepAlive configureKeepAlive(Http http) {
        KeepAlive keepAlive = super.configureKeepAlive(http);
        keepAlive.getMonitoringConfig().addProbes(new KeepAliveMonitor(this.grizzlyService.getMonitoring(), this.name, keepAlive));
        return keepAlive;
    }

    @Override
    protected org.glassfish.grizzly.http.server.filecache.FileCache configureHttpFileCache(FileCache cache) {
        org.glassfish.grizzly.http.server.filecache.FileCache fileCache = super.configureHttpFileCache(cache);
        fileCache.getMonitoringConfig().addProbes(new FileCacheMonitor(this.grizzlyService.getMonitoring(), this.name, fileCache));
        return fileCache;
    }

    @Override
    protected ThreadPoolConfig configureThreadPoolConfig(NetworkListener networkListener, ThreadPool threadPool) {
        ThreadPoolConfig config = super.configureThreadPoolConfig(networkListener, threadPool);
        config.getInitialMonitoringConfig().addProbes((ThreadPoolProbe[])new ThreadPoolProbe[]{new ThreadPoolMonitor(this.grizzlyService.getMonitoring(), this.name, config)});
        return config;
    }

    protected void registerMonitoringStatsProviders() {
        String nameLocal = this.name;
        GrizzlyMonitoring monitoring = this.grizzlyService.getMonitoring();
        monitoring.registerThreadPoolStatsProvider(nameLocal);
        monitoring.registerKeepAliveStatsProvider(nameLocal);
        monitoring.registerFileCacheStatsProvider(nameLocal);
        monitoring.registerConnectionQueueStatsProvider(nameLocal);
    }

    protected void unregisterMonitoringStatsProviders() {
        String localName = this.name;
        GrizzlyMonitoring monitoring = this.grizzlyService.getMonitoring();
        monitoring.unregisterThreadPoolStatsProvider(localName);
        monitoring.unregisterKeepAliveStatsProvider(localName);
        monitoring.unregisterFileCacheStatsProvider(localName);
        monitoring.unregisterConnectionQueueStatsProvider(localName);
    }

    static List<String> toArray(String s, String token) {
        String str;
        ArrayList<String> list = new ArrayList<String>();
        int from = 0;
        while (true) {
            int idx;
            if ((idx = s.indexOf(token, from)) == -1) break;
            str = s.substring(from, idx).trim();
            list.add(str);
            from = idx + 1;
        }
        str = s.substring(from, s.length()).trim();
        list.add(str);
        return list;
    }

    protected static class HttpAdapterImpl
    implements HttpAdapter {
        private final VirtualServer virtualServer;
        private final ContainerMapper conainerMapper;
        private final String webAppRootPath;

        public HttpAdapterImpl(VirtualServer virtualServer, ContainerMapper conainerMapper, String webAppRootPath) {
            this.virtualServer = virtualServer;
            this.conainerMapper = conainerMapper;
            this.webAppRootPath = webAppRootPath;
        }

        @Override
        public ContainerMapper getMapper() {
            return this.conainerMapper;
        }

        @Override
        public VirtualServer getVirtualServer() {
            return this.virtualServer;
        }

        @Override
        public String getWebAppRootPath() {
            return this.webAppRootPath;
        }
    }
}

