/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.common.DoNothingActionReporter;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.SystemTasks;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.api.Async;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.Activator;
import org.glassfish.hk2.runlevel.RunLevelController;
import org.glassfish.hk2.runlevel.RunLevelListener;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.api.KernelIdentity;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@Rank(value=50)
public class AppServerStartup
implements ModuleStartup {
    StartupContext context;
    static final Logger logger = KernelLoggerInfo.getLogger();
    static final Level level = Level.FINE;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ServiceLocator locator;
    @Inject
    ModulesRegistry systemRegistry;
    @Inject
    ExecutorService executor;
    @Inject
    Events events;
    @Inject
    CommonClassLoaderServiceImpl commonCLS;
    @Inject
    SystemTasks pidWriter;
    @Inject
    RunLevelController runLevelController;
    @Inject
    Provider<CommandRunner> commandRunnerProvider;
    private long platformInitTime;
    private String platform = System.getProperty("GlassFish_Platform");
    private final Map<Class, Long> servicesTiming = new HashMap<Class, Long>();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);
    private Thread serverThread;
    private boolean shutdownSignal = false;

    @Override
    @Inject
    public void setStartupContext(StartupContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.commonCLS.getCommonClassLoader());
            this.doStart();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    private void doStart() {
        this.run();
        final CountDownLatch latch = new CountDownLatch(1);
        this.serverThread = new Thread("GlassFish Kernel Main Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.logp(level, "AppServerStartup", "run", "[{0}] started", new Object[]{this});
                latch.countDown();
                1 var1_1 = this;
                synchronized (var1_1) {
                    while (!AppServerStartup.this.shutdownSignal) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                logger.logp(level, "AppServerStartup", "run", "[{0}] exiting", new Object[]{this});
            }
        };
        this.serverThread.setDaemon(false);
        this.serverThread.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void run() {
        if (this.context == null) {
            System.err.println("Startup context not provided, cannot continue");
            return;
        }
        if (this.platform == null) {
            this.platform = "Embedded";
        }
        this.platformInitTime = System.currentTimeMillis();
        if (logger.isLoggable(level)) {
            logger.log(level, "Startup class : {0}", this.getClass().getName());
        }
        DynamicConfigurationService dcs = this.locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addActiveDescriptor(BuilderHelper.createConstantDescriptor(this));
        config.addActiveDescriptor(BuilderHelper.createConstantDescriptor(logger));
        config.addUnbindFilter(BuilderHelper.createContractFilter(ProcessEnvironment.class.getName()));
        config.addActiveDescriptor(BuilderHelper.createConstantDescriptor(this.env.isEmbedded() ? new ProcessEnvironment(ProcessEnvironment.ProcessType.Embedded) : new ProcessEnvironment(ProcessEnvironment.ProcessType.Server)));
        config.commit();
        if (this.proceedTo(1, new InitActivator()) && this.proceedTo(10, new StartupActivator())) {
            this.proceedTo(20, new PostStartupActivator());
        }
    }

    public static void printModuleStatus(ModulesRegistry registry, Level level) {
        if (!logger.isLoggable(level) || registry == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("Module Status Report Begins\n");
        for (Module m : registry.getModules()) {
            if (m.getState() != ModuleState.READY) continue;
            sb.append(m).append("\n");
        }
        sb.append("\n");
        for (Module m : registry.getModules()) {
            if (m.getState() != ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
        }
        sb.append("\n");
        for (Module m : registry.getModules()) {
            if (m.getState() == ModuleState.READY || m.getState() == ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
        }
        sb.append("Module Status Report Ends");
        logger.log(level, sb.toString());
    }

    private void shutdown() {
        CommandRunner runner = this.commandRunnerProvider.get();
        if (runner != null) {
            ParameterMap params = new ParameterMap();
            boolean noForcedShutdown = Boolean.parseBoolean(this.context.getArguments().getProperty("--noforcedshutdown", "true"));
            if (noForcedShutdown) {
                params.set("force", "false");
            }
            KernelIdentity kernelIdentity = this.locator.getService(KernelIdentity.class, new Annotation[0]);
            if (this.env.isDas()) {
                runner.getCommandInvocation("stop-domain", new DoNothingActionReporter(), kernelIdentity.getSubject()).parameters(params).execute();
            } else {
                runner.getCommandInvocation("_stop-instance", new DoNothingActionReporter(), kernelIdentity.getSubject()).parameters(params).execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.env.getStatus() != ServerEnvironment.Status.started) {
            logger.fine("Already stopped, so just returning");
            return;
        }
        this.env.setStatus(ServerEnvironment.Status.stopping);
        this.events.send(new EventListener.Event(EventTypes.PREPARE_SHUTDOWN), false);
        this.proceedTo(1, new AppServerActivator());
        this.env.setStatus(ServerEnvironment.Status.stopped);
        this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
        this.runLevelController.proceedTo(0);
        logger.info("NCLS-CORE-0013");
        if (this.serverThread != null) {
            Thread thread = this.serverThread;
            synchronized (thread) {
                this.shutdownSignal = true;
                this.serverThread.notify();
            }
            try {
                this.serverThread.join(0L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proceedTo(int runLevel, AppServerActivator activator) {
        DynamicConfigurationService dcs = this.locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        ActiveDescriptor<AppServerActivator> activatorDescriptor = config.addActiveDescriptor(BuilderHelper.createConstantDescriptor(activator));
        config.commit();
        try {
            this.runLevelController.proceedTo(runLevel);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "NCLS-CORE-0014", e);
            this.shutdown();
            boolean bl = false;
            return bl;
        }
        finally {
            config = dcs.createDynamicConfiguration();
            config.addUnbindFilter(BuilderHelper.createSpecificDescriptorFilter(activatorDescriptor));
            config.commit();
        }
        return !activator.isShutdown();
    }

    private class AppServerActivator
    implements Activator,
    RunLevelListener {
        protected boolean shutdown;

        private AppServerActivator() {
        }

        @Override
        public void activate(ActiveDescriptor<?> activeDescriptor) {
            ((Activator)((Object)AppServerStartup.this.runLevelController)).activate(activeDescriptor);
        }

        @Override
        public void deactivate(ActiveDescriptor<?> activeDescriptor) {
            if (activeDescriptor.isReified()) {
                try {
                    if (logger.isLoggable(level)) {
                        logger.log(level, "Releasing services {0}", activeDescriptor);
                    }
                    ((Activator)((Object)AppServerStartup.this.runLevelController)).deactivate(activeDescriptor);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void awaitCompletion() throws ExecutionException, InterruptedException, TimeoutException {
        }

        @Override
        public void awaitCompletion(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            this.awaitCompletion();
        }

        @Override
        public void onCancelled(RunLevelController controller, int previousProceedTo, boolean isInterrupt) {
            logger.log(Level.INFO, "NCLS-CORE-0015");
            this.forceShutdown();
        }

        @Override
        public void onError(RunLevelController controller, Throwable error, boolean willContinue) {
            logger.log(Level.INFO, "NCLS-CORE-0015", error);
            this.forceShutdown();
        }

        @Override
        public void onProgress(RunLevelController controller) {
            logger.log(level, "progress event: {0}", controller);
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        protected void forceShutdown() {
            this.shutdown = true;
            AppServerStartup.this.shutdown();
        }
    }

    private class InitActivator
    extends AppServerActivator {
        private InitActivator() {
        }

        @Override
        public void activate(ActiveDescriptor<?> activeDescriptor) {
            long start = System.currentTimeMillis();
            super.activate(activeDescriptor);
            if (logger.isLoggable(level)) {
                long finish = System.currentTimeMillis();
                logger.log(level, activeDescriptor + " Init done in " + (finish - AppServerStartup.this.context.getCreationTime()) + " ms");
                AppServerStartup.this.servicesTiming.put(activeDescriptor.getImplementationClass(), finish - start);
            }
        }
    }

    private class PostStartupActivator
    extends AppServerActivator {
        private PostStartupActivator() {
        }

        @Override
        public void awaitCompletion() throws ExecutionException, InterruptedException, TimeoutException {
            if (AppServerStartup.this.runLevelController.getCurrentRunLevel() < 19 || this.isShutdown()) {
                return;
            }
            AppServerStartup.printModuleStatus(AppServerStartup.this.systemRegistry, level);
        }
    }

    private class StartupActivator
    extends AppServerActivator {
        private ArrayList<Future<Result<Thread>>> futures = new ArrayList();

        private StartupActivator() {
        }

        @Override
        public void activate(ActiveDescriptor<?> activeDescriptor) {
            AppServerStartup.this.locator.reifyDescriptor(activeDescriptor);
            Class<?> type2 = activeDescriptor.getImplementationClass();
            if (type2.getAnnotation(Async.class) == null) {
                long start = System.currentTimeMillis();
                try {
                    if (logger.isLoggable(level)) {
                        logger.log(level, "Running Startup services " + type2);
                    }
                    Object startup = AppServerStartup.this.locator.getServiceHandle(activeDescriptor).getService();
                    if (logger.isLoggable(level)) {
                        logger.log(level, "Startup services finished" + startup);
                    }
                    if (startup instanceof FutureProvider) {
                        this.futures.addAll(((FutureProvider)startup).getFutures());
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "NCLS-CORE-0016", e);
                    AppServerStartup.this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
                    this.forceShutdown();
                    return;
                }
                if (logger.isLoggable(level)) {
                    AppServerStartup.this.servicesTiming.put(type2, System.currentTimeMillis() - start);
                }
            }
        }

        @Override
        public void awaitCompletion() throws ExecutionException, InterruptedException, TimeoutException {
            this.awaitCompletion(3L, TimeUnit.SECONDS);
        }

        @Override
        public void awaitCompletion(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            if (AppServerStartup.this.runLevelController.getCurrentRunLevel() < 9 || this.isShutdown()) {
                return;
            }
            AppServerStartup.this.env.setStatus(ServerEnvironment.Status.starting);
            AppServerStartup.this.events.send(new EventListener.Event(EventTypes.SERVER_STARTUP), false);
            logger.log(Level.INFO, "NCLS-CORE-0017", new Object[]{Version.getVersion(), Version.getBuildVersion(), AppServerStartup.this.platform, AppServerStartup.this.platformInitTime - AppServerStartup.this.context.getCreationTime(), System.currentTimeMillis() - AppServerStartup.this.platformInitTime, System.currentTimeMillis() - AppServerStartup.this.context.getCreationTime()});
            AppServerStartup.printModuleStatus(AppServerStartup.this.systemRegistry, level);
            try {
                long realstart = Long.parseLong(System.getProperty("WALL_CLOCK_START"));
                logger.log(Level.INFO, "NCLS-CORE-0018", System.currentTimeMillis() - realstart);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (logger.isLoggable(level)) {
                for (Map.Entry service : AppServerStartup.this.servicesTiming.entrySet()) {
                    logger.log(level, "Service : " + service.getKey() + " took " + service.getValue() + " ms");
                }
            }
            for (Future<Result<Thread>> future : this.futures) {
                try {
                    try {
                        if (!future.get(timeout, unit).isFailure()) continue;
                        Throwable t = future.get().exception();
                        logger.log(Level.SEVERE, "NCLS-CORE-0019", t);
                        AppServerStartup.this.events.send(new EventListener.Event(EventTypes.SERVER_SHUTDOWN), false);
                        this.forceShutdown();
                        return;
                    }
                    catch (TimeoutException e) {
                        logger.log(Level.WARNING, "NCLS-CORE-0020", e);
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "NCLS-CORE-0021", t);
                }
            }
            AppServerStartup.this.env.setStatus(ServerEnvironment.Status.started);
            AppServerStartup.this.events.send(new EventListener.Event(EventTypes.SERVER_READY), false);
            AppServerStartup.this.pidWriter.writePidFile();
        }
    }
}

