/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.i18n.StringManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobInfos;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.services.common.SubjectUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-jobs")
@PerLookup
@I18n(value="list-jobs")
public class ListJobsCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    private ActionReport report;
    @Inject
    private JobManager jobManagerService;
    protected final List<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
    private final String JOBS_FILE = "jobs.xml";
    @Param(optional=true, primary=true)
    String jobID;
    @Inject
    private ServerEnvironment serverEnvironment;
    private static final String TITLE_NAME = "NAME";
    private static final String TITLE_JOBID = "JOB ID";
    private static final String TITLE_TIME = "TIME";
    private static final String TITLE_STATE = "STATE";
    private static final String TITLE_USER = "USER";
    private static final String TITLE_NONE = "Nothing to list.";
    public static final String NAME = "jobName";
    public static final String ID = "jobId";
    public static final String DATE = "executionDate";
    public static final String CODE = "exitCode";
    public static final String USER = "user";
    public static final String MESSAGE = "message";
    private static final StringManager localStrings = StringManager.getManager(ListJobsCommand.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(AdminCommandContext context) {
        String message;
        List<String> userList;
        this.report = context.getActionReport();
        int longestName = TITLE_NAME.length();
        int longestJobId = TITLE_JOBID.length();
        int longestTime = TITLE_TIME.length();
        int longestState = TITLE_STATE.length();
        int longestUser = TITLE_USER.length();
        ArrayList<Object> jobInfoList = new ArrayList<Object>();
        if (this.jobID != null) {
            void var9_12;
            Job oneJob = this.jobManagerService.get(this.jobID);
            Object var9_9 = null;
            if (oneJob != null) {
                userList = SubjectUtil.getUsernamesFromSubject(oneJob.getSubject());
                message = oneJob.getActionReport() == null ? "" : oneJob.getActionReport().getMessage();
                JobInfo jobInfo = new JobInfo(oneJob.getId(), oneJob.getName(), oneJob.getCommandExecutionDate(), oneJob.getState().name(), "admin", message, oneJob.getJobsFile());
            } else if (this.jobManagerService.getCompletedJobs() != null) {
                JobInfo jobInfo = (JobInfo)this.jobManagerService.getCompletedJobForId(this.jobID);
            }
            if (var9_12 != null && !ListJobsCommand.skipJob(var9_12.jobName)) {
                jobInfoList.add(var9_12);
            }
        } else {
            Iterator<Job> iterator = this.jobManagerService.getJobs();
            while (iterator.hasNext()) {
                Job job = iterator.next();
                if (ListJobsCommand.skipJob(job.getName())) continue;
                userList = SubjectUtil.getUsernamesFromSubject(job.getSubject());
                message = job.getActionReport() == null ? "" : job.getActionReport().getMessage();
                jobInfoList.add(new JobInfo(job.getId(), job.getName(), job.getCommandExecutionDate(), job.getState().name(), userList.get(0), message, job.getJobsFile()));
            }
            JobInfos completedJobs = this.jobManagerService.getCompletedJobs();
            if (completedJobs != null) {
                for (JobInfo info : completedJobs.getJobInfoList()) {
                    if (ListJobsCommand.skipJob(info.jobName)) continue;
                    jobInfoList.add(info);
                }
            }
        }
        for (JobInfo jobInfo : jobInfoList) {
            int jobId = jobInfo.jobId.length();
            int time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jobInfo.commandExecutionDate).length();
            int name = jobInfo.jobName.length();
            int state = jobInfo.exitCode.length();
            int user = jobInfo.user.length();
            if (name > longestName) {
                longestName = name;
            }
            if (time > longestTime) {
                longestTime = time;
            }
            if (jobId > longestJobId) {
                longestJobId = jobId;
            }
            if (state <= longestState) continue;
            longestState = state;
        }
        if (jobInfoList.size() < 1) {
            this.report.setMessage(TITLE_NONE);
        }
        String formattedLine = "%-" + (longestName += 2) + "s %-" + (longestJobId += 2) + "s %-" + (longestTime += 2) + "s %-" + (longestState += 2) + "s %-" + (longestUser += 2) + "s";
        boolean bl = true;
        ActionReport.MessagePart topMsg = this.report.getTopMessagePart();
        Properties properties = this.report.getExtraProperties();
        if (properties == null) {
            properties = new Properties();
            this.report.setExtraProperties(properties);
        }
        ArrayList details = new ArrayList();
        properties.put("jobs", details);
        for (JobInfo info : jobInfoList) {
            boolean bl2;
            if (bl2) {
                topMsg.setMessage(String.format(formattedLine, TITLE_NAME, TITLE_JOBID, TITLE_TIME, TITLE_STATE, TITLE_USER));
                bl2 = false;
            }
            ActionReport.MessagePart msg = topMsg.addChild();
            msg.setMessage(String.format(formattedLine, info.jobName, info.jobId, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(info.commandExecutionDate), info.exitCode, info.user));
            HashMap<String, Object> detail = new HashMap<String, Object>();
            details.add(detail);
            detail.put(NAME, info.jobName);
            detail.put(ID, info.jobId);
            detail.put(DATE, new Date(info.commandExecutionDate));
            detail.put(CODE, info.exitCode);
            detail.put(MESSAGE, info.message);
            detail.put(USER, info.user);
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private static boolean skipJob(String name) {
        return name == null || "attach".equals(name) || name.startsWith("_");
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        this.accessChecks.add(new AccessRequired.AccessCheck("jobs/job/$jobID", "READ"));
        return this.accessChecks;
    }
}

