/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.ManagedJob;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.services.common.SubjectUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="attach")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="attach")
@ManagedJob
public class AttachCommand
implements AdminCommand,
AdminCommandEventBroker.AdminCommandListener,
AdminCommandSecurity.AccessCheckProvider {
    public static final String COMMAND_NAME = "attach";
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(AttachCommand.class);
    private AdminCommandEventBroker eventBroker;
    private Job attached;
    @Inject
    JobManager registry;
    @Param(primary=true, optional=false, multiple=false)
    String jobID;
    protected final List<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AdminCommandContext context) {
        this.eventBroker = context.getEventBroker();
        ActionReport ar = context.getActionReport();
        this.attached = this.registry.get(this.jobID);
        JobInfo jobInfo = null;
        String jobName = null;
        String attachedUser = SubjectUtil.getUsernamesFromSubject(context.getSubject()).get(0);
        if (this.attached == null) {
            if (this.registry.getCompletedJobs() != null) {
                jobInfo = (JobInfo)this.registry.getCompletedJobForId(this.jobID);
            }
            if (jobInfo != null) {
                jobName = jobInfo.jobName;
            }
        }
        if (this.attached == null && jobInfo == null || this.attached != null && this.attached.getName().startsWith("_") || this.attached != null && COMMAND_NAME.equals(this.attached.getName())) {
            ar.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ar.setMessage(strings.getLocalString("attach.wrong.commandinstance.id", "Job with id {0} does not exist.", this.jobID));
            return;
        }
        if (this.attached != null) {
            AdminCommandEventBroker attachedBroker = this.attached.getEventBroker();
            Object object = attachedBroker;
            synchronized (object) {
                this.onAdminCommandEvent("AdminCommandInstance/stateChanged", this.attached);
                if (this.attached.getCommandProgress() != null) {
                    this.onAdminCommandEvent("ProgressStatus/state", this.attached.getCommandProgress());
                }
                attachedBroker.registerListener(".*", this);
            }
            object = this.attached;
            synchronized (object) {
                while (this.attached.getState().equals((Object)AdminCommandState.State.PREPARED) || this.attached.getState().equals((Object)AdminCommandState.State.RUNNING)) {
                    try {
                        this.attached.wait(300000L);
                    }
                    catch (InterruptedException ex) {}
                }
                if (this.attached.getState().equals((Object)AdminCommandState.State.COMPLETED)) {
                    String commandUser = SubjectUtil.getUsernamesFromSubject(this.attached.getSubject()).get(0);
                    if (commandUser != null && commandUser.equals(attachedUser)) {
                        this.purgeJob(this.attached.getId());
                    }
                    ar.setActionExitCode(this.attached.getActionReport().getActionExitCode());
                    ar.appendMessage(strings.getLocalString("attach.finished", "Command {0} executed {1}", new Object[]{this.attached.getName(), this.attached.getActionReport().getActionExitCode()}));
                }
            }
        }
        if (jobInfo != null && jobInfo.exitCode.equals(AdminCommandState.State.COMPLETED.toString())) {
            if (attachedUser != null && attachedUser.equals(jobInfo.user)) {
                this.purgeJob(jobInfo.jobId);
            }
            ar.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            ar.appendMessage(strings.getLocalString("attach.finished", "Command {0} executed{1}", new Object[]{jobName, ActionReport.ExitCode.SUCCESS}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAdminCommandEvent(String name, Object event) {
        if (name == null || name.startsWith("client.")) {
            return;
        }
        if ("AdminCommandInstance/stateChanged".equals(name) && ((Job)event).getState().equals((Object)AdminCommandState.State.COMPLETED)) {
            Job job = this.attached;
            synchronized (job) {
                this.attached.notifyAll();
            }
        } else {
            this.eventBroker.fireEvent(name, event);
        }
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        this.accessChecks.add(new AccessRequired.AccessCheck("jobs/job/$jobID", "READ"));
        return this.accessChecks;
    }

    private void purgeJob(String jobid) {
        try {
            this.registry.purgeJob(jobid);
            this.registry.purgeCompletedJobForId(jobid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

