/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.cluster.SyncRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public final class ServerSynchronizer
implements PostConstruct {
    @Inject
    private ServerEnvironment env;
    @Inject
    private Domain domain;
    @Inject
    @Optional
    private Applications applications;
    private static boolean syncArchive = false;
    private URI domainRootUri;
    private Logger logger;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(ServerSynchronizer.class);

    @Override
    public void postConstruct() {
        this.domainRootUri = this.env.getDomainRoot().toURI();
    }

    public void synchronize(Server server, SyncRequest sr, Payload.Outbound payload, ActionReport report, Logger logger2) {
        this.logger = logger2;
        try {
            logger2.fine("ServerSynchronizer: synchronization request for server " + server.getName() + ", directory " + sr.dir);
            if (sr.dir.equals("config")) {
                this.synchronizeConfig(payload, server, sr);
            } else if (sr.dir.equals("applications")) {
                this.synchronizeApplications(payload, server, sr);
            } else if (sr.dir.equals("lib")) {
                this.synchronizeLib(payload, server, sr);
            } else if (sr.dir.equals("docroot")) {
                this.synchronizeDocroot(payload, server, sr);
            } else if (sr.dir.equals("config-specific")) {
                this.synchronizeConfigSpecificDir(payload, server, sr);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(strings.getLocalString("serversync.unknown.dir", "Unknown directory: {0}", sr.dir));
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (URISyntaxException ex) {
            logger2.fine("ServerSynchronizer: Exception processing request");
            logger2.fine(ex.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("serversync.exception.processing", "ServerSynchronizer: Exception processing request"));
            report.setFailureCause(ex);
        }
    }

    private void synchronizeConfig(Payload.Outbound payload, Server server, SyncRequest sr) throws URISyntaxException {
        File configDir;
        this.logger.finer("ServerSynchronizer: synchronize config");
        SyncRequest.ModTime domainXmlMT = null;
        for (SyncRequest.ModTime mt : sr.files) {
            if (!mt.name.equals("domain.xml")) continue;
            domainXmlMT = mt;
            break;
        }
        if (domainXmlMT == null) {
            domainXmlMT = new SyncRequest.ModTime("domain.xml", 0L);
        }
        if (!this.syncFile(this.domainRootUri, configDir = this.env.getConfigDirPath(), domainXmlMT, payload)) {
            this.logger.fine("ServerSynchronizer: domain.xml HAS NOT CHANGED, thus no files will be synchronized");
            return;
        }
        Set<String> configFileSet = this.getConfigFileNames();
        configFileSet.remove("domain.xml");
        this.getRealmFileNames(server, configFileSet);
        for (SyncRequest.ModTime mt : sr.files) {
            if (mt.name.equals("domain.xml")) continue;
            if (configFileSet.contains(mt.name)) {
                configFileSet.remove(mt.name);
                this.syncFile(this.domainRootUri, configDir, mt, payload);
                continue;
            }
            this.removeFile(this.domainRootUri, configDir, mt, payload);
        }
        for (String name : configFileSet) {
            this.syncFile(this.domainRootUri, configDir, new SyncRequest.ModTime(name, 0L), payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getConfigFileNames() {
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        BufferedReader in = null;
        try {
            File configDir = this.env.getConfigDirPath();
            File f = new File(configDir, "config-files");
            if (f.exists()) {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            } else {
                InputStream res = this.getClass().getResourceAsStream("/META-INF/config-files");
                if (res != null) {
                    in = new BufferedReader(new InputStreamReader(res));
                } else {
                    this.logger.severe("ServerSynchronizer: can't find list of config files to synchronize!");
                }
            }
            if (in != null) {
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
                    files.add(line);
                }
            }
        }
        catch (IOException ex) {
            this.logger.fine("ServerSynchronizer: IOException in getConfigFileNames");
            this.logger.fine(ex.toString());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return files;
    }

    private void getRealmFileNames(Server server, Set<String> files) {
        File configDir = this.env.getConfigDirPath();
        URI configURI = configDir.toURI();
        Config config = this.domain.getConfigNamed(server.getConfigRef());
        for (String file : FileRealm.getRealmFileNames(config)) {
            URI f;
            File rfile = new File(file);
            if (!rfile.exists() || (f = configURI.relativize(rfile.toURI())).isAbsolute()) continue;
            files.add(f.toString());
        }
    }

    private boolean syncFile(URI root, File base, SyncRequest.ModTime mt, Payload.Outbound payload) throws URISyntaxException {
        File f = this.fileOf(base, mt.name);
        if (!f.exists()) {
            return false;
        }
        if (mt.time != 0L && f.lastModified() == mt.time) {
            return false;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("ServerSynchronizer: file " + mt.name + " out of date, time " + f.lastModified());
        }
        try {
            if (mt.time == 0L) {
                this.logger.fine("ServerSynchronizer: sending file " + f + " because it doesn't exist on the instance");
            } else {
                this.logger.fine("ServerSynchronizer: sending file " + f + " because it was out of date");
            }
            payload.requestFileReplacement("application/octet-stream", root.relativize(f.toURI()), "configChange", null, f, true);
        }
        catch (IOException ioex) {
            this.logger.fine("ServerSynchronizer: IOException attaching file: " + f);
            this.logger.fine(ioex.toString());
        }
        return true;
    }

    private void removeFile(URI root, File base, SyncRequest.ModTime mt, Payload.Outbound payload) throws URISyntaxException {
        File f = this.fileOf(base, mt.name);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("ServerSynchronizer: file " + mt.name + " removed from client");
        }
        try {
            this.logger.fine("ServerSynchronizer: removing file " + f + " because it does not exist on the DAS");
            payload.requestFileRemoval(root.relativize(f.toURI()), "configChange", null);
        }
        catch (IOException ioex) {
            this.logger.fine("ServerSynchronizer: IOException removing file: " + f);
            this.logger.fine(ioex.toString());
        }
    }

    private void synchronizeApplications(Payload.Outbound payload, Server server, SyncRequest sr) throws URISyntaxException {
        this.logger.finer("ServerSynchronizer: synchronize application instance " + sr.instance);
        Map<String, Application> apps = this.getApps(server);
        File appsDir = this.env.getApplicationRepositoryPath();
        for (SyncRequest.ModTime modTime : sr.files) {
            if (apps.containsKey(modTime.name)) {
                this.syncApp(apps.get(modTime.name), appsDir, modTime, payload);
                apps.remove(modTime.name);
                continue;
            }
            this.removeApp(apps.get(modTime.name), appsDir, modTime, payload);
        }
        for (Map.Entry entry : apps.entrySet()) {
            this.syncApp((Application)entry.getValue(), appsDir, new SyncRequest.ModTime((String)entry.getKey(), 0L), payload);
        }
    }

    private Map<String, Application> getApps(Server server) {
        HashMap<String, Application> apps = new HashMap<String, Application>();
        if (this.applications == null) {
            return apps;
        }
        for (ApplicationRef ref : server.getApplicationRef()) {
            Application app = this.applications.getApplication(ref.getRef());
            if (app == null) continue;
            this.logger.finest("ServerSynchronizer: got app " + app.getName());
            if (Boolean.parseBoolean(app.getDirectoryDeployed())) {
                this.logger.finest("ServerSynchronizer: skipping directory deployed app: " + app.getName());
                continue;
            }
            apps.put(VersioningUtils.getRepositoryName(app.getName()), app);
        }
        return apps;
    }

    private boolean syncApp(Application app, File base, SyncRequest.ModTime mt, Payload.Outbound payload) throws URISyntaxException {
        this.logger.finer("ServerSynchronizer: sync app " + mt.name);
        try {
            File appDir = this.fileOf(base, mt.name);
            if (syncArchive) {
                File archive = app.application();
                this.logger.finest("ServerSynchronizer: check archive " + archive);
                if (mt.time != 0L && archive.lastModified() == mt.time) {
                    return false;
                }
                this.attachAppArchive(archive, payload);
            } else {
                this.logger.finest("ServerSynchronizer: check app dir " + appDir);
                if (mt.time != 0L && appDir.lastModified() == mt.time) {
                    return false;
                }
                if (mt.time == 0L) {
                    this.logger.fine("ServerSynchronizer: sending files for application " + mt.name + " because it doesn't exist on the instance");
                } else {
                    this.logger.fine("ServerSynchronizer: sending files for application " + mt.name + " because it was out of date");
                }
                this.attachAppDir(appDir, payload);
            }
            File gdir = this.env.getApplicationCompileJspPath();
            this.attachAppDir(this.fileOf(gdir, mt.name), payload);
            gdir = this.env.getApplicationGeneratedXMLPath();
            this.attachAppDir(this.fileOf(gdir, mt.name), payload);
            gdir = this.env.getApplicationEJBStubPath();
            this.attachAppDir(this.fileOf(gdir, mt.name), payload);
            gdir = new File(this.env.getApplicationStubPath(), "policy");
            this.attachAppDir(this.fileOf(gdir, mt.name), payload);
            gdir = this.env.getApplicationAltDDPath();
            this.attachAppDir(this.fileOf(gdir, mt.name), payload);
        }
        catch (IOException ioex) {
            this.logger.fine("ServerSynchronizer: IOException syncing app " + mt.name);
            this.logger.fine(ioex.toString());
        }
        return true;
    }

    private void synchronizeLib(Payload.Outbound payload, Server server, SyncRequest sr) throws URISyntaxException {
        ArrayList<String> skip = new ArrayList<String>();
        skip.add("databases");
        this.synchronizeDirectory(payload, server, sr, this.env.getLibPath(), skip, SyncLevel.RECURSIVE);
    }

    private void synchronizeDocroot(Payload.Outbound payload, Server server, SyncRequest sr) throws URISyntaxException {
        this.synchronizeDirectory(payload, server, sr, new File(this.env.getDomainRoot(), "docroot"), null, SyncLevel.DIRECTORY);
    }

    private void synchronizeDirectory(Payload.Outbound payload, Server server, SyncRequest sr, File dir2, List<String> skip, SyncLevel level) throws URISyntaxException {
        this.logger.finest("ServerSynchronizer: directory is " + dir2);
        List<String> fileSet = this.getFileNames(dir2, skip, level);
        this.synchronizeDirectory(payload, server, sr, dir2, fileSet);
    }

    private void synchronizeDirectory(Payload.Outbound payload, Server server, SyncRequest sr, File dir2, List<String> fileSet) throws URISyntaxException {
        for (SyncRequest.ModTime mt : sr.files) {
            if (fileSet.contains(mt.name)) {
                fileSet.remove(mt.name);
                this.syncFile(this.domainRootUri, dir2, mt, payload);
                continue;
            }
            this.removeFile(this.domainRootUri, dir2, mt, payload);
        }
        for (String name : fileSet) {
            this.syncFile(this.domainRootUri, dir2, new SyncRequest.ModTime(name, 0L), payload);
        }
    }

    private void synchronizeConfigSpecificDir(Payload.Outbound payload, Server server, SyncRequest sr) throws URISyntaxException {
        String configDirName = server.getConfigRef();
        File configDir = this.env.getConfigDirPath();
        File configSpecificDir = new File(configDir, configDirName);
        this.logger.finest("ServerSynchronizer: config-specific directory is " + configSpecificDir);
        if (!configSpecificDir.exists()) {
            this.logger.fine("ServerSynchronizer: no config-specific directory  to synchronize: " + configSpecificDir);
            return;
        }
        ArrayList<String> fileSet = new ArrayList<String>();
        this.getFileNames(configSpecificDir, configDir, null, fileSet, SyncLevel.DIRECTORY);
        this.synchronizeDirectory(payload, server, sr, configDir, fileSet);
    }

    private List<String> getFileNames(File dir2, List<String> skip, SyncLevel level) {
        ArrayList<String> names = new ArrayList<String>();
        if (dir2.exists()) {
            this.getFileNames(dir2, dir2, skip, names, level);
        } else {
            this.logger.finest("ServerSynchronizer: directory doesn't exist: " + dir2);
        }
        return names;
    }

    private int getFileNames(File dir2, File baseDir, List<String> skip, List<String> names, SyncLevel level) {
        if (level == SyncLevel.TOP) {
            String name = baseDir.toURI().relativize(dir2.toURI()).getPath();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            names.add(name);
            return 1;
        }
        int cnt = 0;
        for (String file : dir2.list()) {
            File f = new File(dir2, file);
            String name = baseDir.toURI().relativize(f.toURI()).getPath();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if (skip != null && skip.contains(name)) continue;
            if (f.isDirectory() && level == SyncLevel.RECURSIVE) {
                int subFileCnt = this.getFileNames(f, baseDir, skip, names, level);
                if (subFileCnt == 0) {
                    names.add(name);
                    ++cnt;
                    continue;
                }
                cnt += subFileCnt;
                continue;
            }
            names.add(name);
            ++cnt;
        }
        return cnt;
    }

    private void attachAppArchive(File file, Payload.Outbound payload) throws IOException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("ServerSynchronizer: domainRootUri " + this.domainRootUri);
            this.logger.finer("ServerSynchronizer: file.toURI() " + file.toURI());
            this.logger.finer("ServerSynchronizer: attach file " + this.domainRootUri.relativize(file.toURI()));
        }
        payload.attachFile("application/octet-stream", this.domainRootUri.relativize(file.toURI()), "configChange", file, true);
    }

    private void attachAppDir(File dir2, Payload.Outbound payload) throws IOException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("ServerSynchronizer: attach directory " + this.domainRootUri.relativize(dir2.toURI()));
        }
        if (!dir2.exists()) {
            this.logger.finer("ServerSynchronizer: nothing to attach");
            return;
        }
        payload.requestFileReplacement("application/octet-stream", this.domainRootUri.relativize(dir2.toURI()), "configChange", null, dir2, true);
    }

    private void removeApp(Application app, File base, SyncRequest.ModTime mt, Payload.Outbound payload) throws URISyntaxException {
        this.logger.fine("ServerSynchronizer: removing files for application " + mt.name + " because it is no longer deployed to this instance");
        try {
            File dir2 = this.fileOf(base, mt.name);
            this.removeDir(dir2, payload);
            dir2 = this.env.getApplicationCompileJspPath();
            this.removeDir(this.fileOf(dir2, mt.name), payload);
            dir2 = this.env.getApplicationGeneratedXMLPath();
            this.removeDir(this.fileOf(dir2, mt.name), payload);
            dir2 = this.env.getApplicationEJBStubPath();
            this.removeDir(this.fileOf(dir2, mt.name), payload);
            dir2 = new File(this.env.getApplicationStubPath(), "policy");
            this.removeDir(this.fileOf(dir2, mt.name), payload);
        }
        catch (IOException ioex) {
            this.logger.fine("ServerSynchronizer: IOException removing app " + mt.name);
            this.logger.fine(ioex.toString());
        }
    }

    private void removeDir(File file, Payload.Outbound payload) throws IOException {
        payload.requestFileRemoval(this.domainRootUri.relativize(file.toURI()), "configChange", null, true);
    }

    private File fileOf(File base, String uri) throws URISyntaxException {
        return new File(new URI(base.toURI().toString() + "/" + uri));
    }

    private static enum SyncLevel {
        TOP,
        DIRECTORY,
        RECURSIVE;

    }
}

