/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.InstanceInfo;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-instances")
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.instances.command")
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.GET, path="list-instances", description="List Cluster Instances", params={@RestParam(name="id", value="$parent")}), @RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-instances", description="List Instances")})
public class ListInstancesCommand
implements AdminCommand {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Servers allServers;
    @Inject
    InstanceStateService stateService;
    @Param(optional=true, defaultValue="false", name="long", shortName="l")
    private boolean long_opt;
    @Param(optional=true, defaultValue="60000")
    private String timeoutmsec;
    @Param(optional=true, defaultValue="false")
    private boolean standaloneonly;
    @Param(optional=true, defaultValue="false")
    private boolean nostatus;
    @Param(optional=true, primary=true, defaultValue="domain")
    String whichTarget;
    private List<InstanceInfo> infos = new LinkedList<InstanceInfo>();
    private List<Server> serverList;
    private ActionReport report;
    private ActionReport.MessagePart top = null;
    private static final String EOL = "\n";

    @Override
    public void execute(AdminCommandContext context) {
        int timeoutInMsec;
        try {
            timeoutInMsec = Integer.parseInt(this.timeoutmsec);
        }
        catch (Exception e) {
            timeoutInMsec = 60000;
        }
        this.report = context.getActionReport();
        this.top = this.report.getTopMessagePart();
        Logger logger2 = context.getLogger();
        if (!this.validateParams()) {
            return;
        }
        this.serverList = this.createServerList();
        if (this.serverList == null) {
            this.fail(Strings.get("list.instances.badTarget", this.whichTarget));
            return;
        }
        if (!this.env.isDas()) {
            String msg = Strings.get("list.instances.onlyRunsOnDas");
            logger2.warning(msg);
            this.fail(msg);
            return;
        }
        if (this.nostatus) {
            this.noStatus(this.serverList);
        } else {
            this.yesStatus(this.serverList, timeoutInMsec, logger2);
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void noStatus(List<Server> serverList) {
        if (serverList.size() < 1) {
            this.report.setMessage("Nothing to list.");
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean firstServer = true;
        Properties extraProps = new Properties();
        ArrayList instanceList = new ArrayList();
        for (Server server : serverList) {
            String name;
            boolean clustered;
            boolean bl = clustered = server.getCluster() != null;
            if (this.standaloneonly && clustered || !this.notDas(name = server.getName())) continue;
            if (firstServer) {
                firstServer = false;
            } else {
                sb.append(EOL);
            }
            sb.append(name);
            this.top.addProperty(name, "");
            HashMap<String, String> insDetails = new HashMap<String, String>();
            insDetails.put("name", name);
            instanceList.add(insDetails);
        }
        extraProps.put("instanceList", instanceList);
        this.report.setMessage(sb.toString());
        this.report.setExtraProperties(extraProps);
    }

    private boolean notDas(String name) {
        return !"server".equals(name);
    }

    private void yesStatus(List<Server> serverList, int timeoutInMsec, Logger logger2) {
        RemoteInstanceCommandHelper helper = new RemoteInstanceCommandHelper(this.habitat);
        for (Server server : serverList) {
            String clusterName;
            String name;
            boolean clustered = server.getCluster() != null;
            int port = helper.getAdminPort(server);
            String host = server.getAdminHost();
            if (this.standaloneonly && clustered || (name = server.getName()) == null) continue;
            Cluster cluster = this.domain.getClusterForInstance(name);
            String string = clusterName = cluster != null ? cluster.getName() : null;
            if (!this.notDas(name)) continue;
            ActionReport tReport = this.habitat.getService(ActionReport.class, "html", new Annotation[0]);
            InstanceInfo ii = new InstanceInfo(this.habitat, server, port, host, clusterName, logger2, timeoutInMsec, tReport, this.stateService);
            this.infos.add(ii);
        }
        if (this.infos.size() < 1) {
            this.report.setMessage("Nothing to list.");
            return;
        }
        Properties extraProps = new Properties();
        ArrayList instanceList = new ArrayList();
        for (InstanceInfo ii : this.infos) {
            String name = ii.getName();
            String value = ii.isRunning() ? InstanceState.StateType.RUNNING.getDescription() : InstanceState.StateType.NOT_RUNNING.getDescription();
            InstanceState.StateType state = ii.isRunning() ? this.stateService.setState(name, InstanceState.StateType.RUNNING, false) : this.stateService.setState(name, InstanceState.StateType.NOT_RUNNING, false);
            List<String> failedCmds = this.stateService.getFailedCommands(name);
            if (state == InstanceState.StateType.RESTART_REQUIRED && ii.isRunning()) {
                value = InstanceState.StateType.RESTART_REQUIRED.getDescription();
            }
            HashMap<String, Object> insDetails = new HashMap<String, Object>();
            insDetails.put("name", name);
            insDetails.put("status", value);
            if (state == InstanceState.StateType.RESTART_REQUIRED) {
                insDetails.put("restartReasons", failedCmds);
            }
            if (ii.isRunning()) {
                insDetails.put("uptime", ii.getUptime());
            }
            instanceList.add(insDetails);
        }
        extraProps.put("instanceList", instanceList);
        this.report.setExtraProperties(extraProps);
        if (this.long_opt) {
            this.report.setMessage(InstanceInfo.format(this.infos));
        } else {
            this.report.setMessage(InstanceInfo.formatBrief(this.infos));
        }
    }

    private List<Server> createServerList() {
        if (!StringUtils.ok(this.whichTarget)) {
            return this.allServers.getServer();
        }
        ReferenceContainer rc = this.domain.getReferenceContainerNamed(this.whichTarget);
        if (rc == null) {
            return this.getServersForNodeOrConfig();
        }
        if (rc.isServer()) {
            LinkedList<Server> l = new LinkedList<Server>();
            l.add((Server)rc);
            return l;
        }
        if (rc.isCluster()) {
            Cluster cluster = (Cluster)rc;
            return cluster.getInstances();
        }
        return null;
    }

    private List<Server> getServersForNodeOrConfig() {
        if (this.whichTarget == null) {
            throw new NullPointerException("impossible!");
        }
        List<Server> list = this.getServersForNode();
        if (list == null) {
            list = this.getServersForConfig();
        }
        return list;
    }

    private List<Server> getServersForNode() {
        List<Node> nodeList;
        boolean foundNode = false;
        Nodes nodes = this.domain.getNodes();
        if (nodes != null && (nodeList = nodes.getNode()) != null) {
            for (Node node : nodeList) {
                if (!this.whichTarget.equals(node.getName())) continue;
                foundNode = true;
                break;
            }
        }
        if (!foundNode) {
            return null;
        }
        return this.domain.getInstancesOnNode(this.whichTarget);
    }

    private List<Server> getServersForConfig() {
        Config config = this.domain.getConfigNamed(this.whichTarget);
        if (config == null) {
            return null;
        }
        List<ReferenceContainer> rcs = this.domain.getReferenceContainersOf(config);
        LinkedList<Server> servers = new LinkedList<Server>();
        for (ReferenceContainer rc : rcs) {
            if (!rc.isServer()) continue;
            servers.add((Server)rc);
        }
        return servers;
    }

    private boolean validateParams() {
        if ("domain".equals(this.whichTarget)) {
            this.whichTarget = null;
        }
        if (this.standaloneonly && StringUtils.ok(this.whichTarget)) {
            this.fail(Strings.get("list.instances.targetWithStandaloneOnly"));
            return false;
        }
        if (this.long_opt && this.nostatus) {
            this.fail(Strings.get("list.instances.longAndNoStatus"));
            return false;
        }
        if (!this.notDas(this.whichTarget)) {
            this.fail(Strings.get("list.instances.serverTarget"));
            return false;
        }
        return true;
    }

    private void fail(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(s);
    }
}

