/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceLocator;

public abstract class DeleteNodeRemoteCommand
implements AdminCommand {
    private static final int DEFAULT_TIMEOUT_MSEC = 300000;
    @Inject
    protected ServiceLocator habitat;
    @Inject
    IterableProvider<Node> nodeList;
    @Inject
    Nodes nodes;
    @Inject
    private CommandRunner cr;
    @Param(name="name", primary=true)
    String name;
    @Param(optional=true, defaultValue="false")
    boolean uninstall;
    @Param(optional=true, defaultValue="false")
    boolean force;
    protected String remotepassword = null;
    protected String sshkeypassphrase = null;
    private static final String NL = System.getProperty("line.separator");
    protected Logger logger = null;

    protected abstract List<String> getPasswords();

    protected abstract String getUninstallCommandName();

    protected abstract void setTypeSpecificOperands(List<String> var1, ParameterMap var2);

    protected final void executeInternal(AdminCommandContext context) {
        boolean s;
        ActionReport report = context.getActionReport();
        this.logger = context.getLogger();
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            String msg = Strings.get("noSuchNode", this.name);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        String type2 = node.getType();
        if (type2 == null || type2.equals("CONFIG")) {
            String msg = Strings.get("notRemoteNodeType", this.name);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        ParameterMap info = new ParameterMap();
        if (this.uninstall) {
            SshConnector sshC = node.getSshConnector();
            SshAuth sshAuth = sshC.getSshAuth();
            if (sshAuth.getPassword() != null) {
                info.add("sshpassword", sshAuth.getPassword());
            }
            if (sshAuth.getKeyPassphrase() != null) {
                info.add("sshkeypassphrase", sshAuth.getKeyPassphrase());
            }
            if (sshAuth.getKeyfile() != null) {
                info.add("sshkeyfile", sshAuth.getKeyfile());
            }
            info.add("installdir", node.getInstallDir());
            info.add("sshport", sshC.getSshPort());
            info.add("sshuser", sshAuth.getUserName());
            info.add("nodehost", node.getNodeHost());
            info.add("windowsdomain", node.getWindowsDomain());
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_delete-node", report, context.getSubject());
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", this.name);
        ci.parameters(map);
        ci.execute();
        if (this.uninstall && !(s = this.uninstallNode(context, info, node)) && !this.force) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    private boolean uninstallNode(AdminCommandContext ctx, ParameterMap map, Node node) {
        boolean res = false;
        this.remotepassword = (String)map.getOne("sshpassword");
        this.sshkeypassphrase = (String)map.getOne("sshkeypassphrase");
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getUninstallCommandName());
        String type2 = node.getType();
        command.add("--installdir");
        command.add((String)map.getOne("installdir"));
        if (this.force) {
            command.add("--force");
        }
        this.setTypeSpecificOperands(command, map);
        String host = (String)map.getOne("nodehost");
        command.add(host);
        String firstErrorMessage = Strings.get("delete.node.ssh.uninstall.failed", node.getName(), host);
        StringBuilder out = new StringBuilder();
        int exitCode = this.execCommand(command, out);
        this.logger.info(out.toString().trim());
        ActionReport report = ctx.getActionReport();
        if (exitCode == 0) {
            String msg = Strings.get("delete.node.ssh.uninstall.success", host);
            report.setMessage(msg);
            res = true;
        } else {
            report.setMessage(firstErrorMessage);
        }
        return res;
    }

    private int execCommand(List<String> cmdLine, StringBuilder output) {
        int exit = -1;
        ArrayList<String> fullcommand = new ArrayList<String>();
        String installDir = this.nodes.getDefaultLocalNode().getInstallDirUnixStyle() + "/glassfish";
        if (!StringUtils.ok(installDir)) {
            throw new IllegalArgumentException(Strings.get("create.node.ssh.no.installdir"));
        }
        File asadmin = new File(SystemPropertyConstants.getAsAdminScriptLocation(installDir));
        fullcommand.add(asadmin.getAbsolutePath());
        List<Object> pass = new ArrayList();
        if (this.remotepassword != null) {
            fullcommand.add("--passwordfile");
            fullcommand.add("-");
            pass = this.getPasswords();
        }
        fullcommand.add("--interactive=false");
        fullcommand.addAll(cmdLine);
        ProcessManager pm = new ProcessManager(fullcommand);
        if (!pass.isEmpty()) {
            pm.setStdinLines(pass);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Running command on DAS: " + this.commandListToString(fullcommand));
        }
        pm.setTimeoutMsec(300000);
        if (this.logger.isLoggable(Level.FINER)) {
            pm.setEcho(true);
        } else {
            pm.setEcho(false);
        }
        try {
            exit = pm.execute();
        }
        catch (ProcessManagerException ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Error while executing command: " + ex.getMessage());
            }
            exit = 1;
        }
        String stdout = pm.getStdout();
        String stderr = pm.getStderr();
        if (output != null) {
            if (StringUtils.ok(stdout)) {
                output.append(stdout);
            }
            if (StringUtils.ok(stderr)) {
                if (output.length() > 0) {
                    output.append(NL);
                }
                output.append(stderr);
            }
        }
        return exit;
    }

    private String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

