/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="delete-instance")
@I18n(value="delete.instance")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.DELETE, path="delete-instance", description="Delete Instance", params={@RestParam(name="id", value="$parent")})})
public class DeleteInstanceCommand
implements AdminCommand {
    private static final String NL = System.getProperty("line.separator");
    @Inject
    private CommandRunner cr;
    @Inject
    ServiceLocator habitat;
    @Inject
    private Servers servers;
    @Inject
    private Nodes nodes;
    @Param(name="instance_name", primary=true)
    private String instanceName;
    @Param(defaultValue="false", optional=true)
    private boolean terse;
    private Server instance;
    private String noderef;
    private String nodedir;
    private Logger logger;
    private String instanceHost;
    private Node theNode = null;

    @Override
    public void execute(AdminCommandContext ctx) {
        ActionReport report = ctx.getActionReport();
        this.logger = ctx.getLogger();
        String msg = "";
        boolean fsfailure = false;
        boolean configfailure = false;
        this.instance = this.servers.getServer(this.instanceName);
        if (this.instance == null) {
            msg = Strings.get("start.instance.noSuchInstance", this.instanceName);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.instanceHost = this.instance.getAdminHost();
        if (this.instance.isRunning()) {
            msg = Strings.get("instance.shutdown", this.instanceName);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.noderef = this.instance.getNodeRef();
        if (!StringUtils.ok(this.noderef)) {
            msg = Strings.get("missingNodeRef", this.instanceName);
            fsfailure = true;
        } else {
            this.theNode = this.nodes.getNode(this.noderef);
            if (this.theNode == null) {
                msg = Strings.get("noSuchNode", this.noderef);
                fsfailure = true;
            }
        }
        if (!fsfailure) {
            this.nodedir = this.theNode.getNodeDirAbsolute();
            this.deleteInstanceFilesystem(ctx);
            report = ctx.getActionReport();
            if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                fsfailure = true;
            }
            msg = report.getMessage();
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_unregister-instance", report, ctx.getSubject());
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", this.instanceName);
        ci.parameters(map);
        ci.execute();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS && report.getActionExitCode() != ActionReport.ExitCode.WARNING) {
            configfailure = true;
            msg = fsfailure ? msg + NL + report.getMessage() : report.getMessage();
        }
        if (configfailure && fsfailure) {
            msg = msg + NL + NL + Strings.get("delete.instance.failed", this.instanceName, this.instanceHost);
        } else if (configfailure && !fsfailure) {
            msg = msg + NL + NL + Strings.get("delete.instance.config.failed", this.instanceName, this.instanceHost);
        } else if (!configfailure && fsfailure) {
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
        if (configfailure) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
        }
    }

    private void deleteInstanceFilesystem(AdminCommandContext ctx) {
        NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
        ArrayList<String> command = new ArrayList<String>();
        String humanCommand = null;
        command.add("_delete-instance-filesystem");
        if (this.nodedir != null) {
            command.add("--nodedir");
            command.add(this.nodedir);
        }
        command.add("--node");
        command.add(this.noderef);
        command.add(this.instanceName);
        humanCommand = this.makeCommandHuman(command);
        String firstErrorMessage = Strings.get("delete.instance.filesystem.failed", this.instanceName, this.noderef, this.theNode.getNodeHost());
        StringBuilder output = new StringBuilder();
        nodeUtils.runAdminCommandOnNode(this.theNode, command, ctx, firstErrorMessage, humanCommand, output);
        ActionReport report = ctx.getActionReport();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            return;
        }
        String msg = Strings.get("delete.instance.success", this.instanceName, this.theNode.getNodeHost());
        if (!this.terse) {
            msg = StringUtils.cat(NL, output.toString().trim(), msg);
        }
        report.setMessage(msg);
    }

    private String makeCommandHuman(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        fullCommand.append("lib");
        fullCommand.append(System.getProperty("file.separator"));
        fullCommand.append("nadmin ");
        for (String s : command) {
            if (s.equals("_delete-instance-filesystem")) {
                fullCommand.append(" ");
                fullCommand.append("delete-local-instance");
                continue;
            }
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

