/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ManagedJobConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.AdminCommandInstanceImpl;
import com.sun.enterprise.v3.server.ExecutorServiceFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobInfos;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class JobManagerService
implements JobManager,
PostConstruct {
    @Inject
    private Domain domain;
    private ManagedJobConfig managedJobConfig;
    private static final int MAX_SIZE = 65535;
    private ConcurrentHashMap<String, Job> jobRegistry = new ConcurrentHashMap();
    private AtomicInteger lastId = new AtomicInteger(0);
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(JobManagerService.class);
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private ExecutorService pool;
    @Inject
    private ExecutorServiceFactory executorFactory;
    @Inject
    private ServerEnvironment serverEnvironment;
    private final String JOBS_FILE = "jobs.xml";
    private JAXBContext jaxbContext;
    protected File jobsFile;

    @Override
    public synchronized String getNewId() {
        String nextIdToUse;
        int nextId = this.lastId.incrementAndGet();
        if (nextId > 65535) {
            this.reset();
        }
        return !this.idInUse(nextIdToUse = String.valueOf(nextId)) ? String.valueOf(nextId) : this.getNewId();
    }

    @Override
    public JobInfo getCompletedJobForId(String id) {
        for (JobInfo jobInfo : this.getCompletedJobs().getJobInfoList()) {
            if (!jobInfo.jobId.equals(id)) continue;
            return jobInfo;
        }
        return null;
    }

    private void reset() {
        this.lastId.set(0);
    }

    private boolean idInUse(String id) {
        if (this.jobRegistry.containsKey(id)) {
            return true;
        }
        if (this.getCompletedJobs() != null) {
            for (JobInfo job : this.getCompletedJobs().getJobInfoList()) {
                if (!job.jobId.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void registerJob(Job instance) throws IllegalArgumentException {
        if (instance == null) {
            throw new IllegalArgumentException(adminStrings.getLocalString("job.cannot.be.null", "Job cannot be null"));
        }
        if (this.jobRegistry.containsKey(instance.getId())) {
            throw new IllegalArgumentException(adminStrings.getLocalString("job.id.in.use", "Job id is already in use."));
        }
        this.jobRegistry.put(instance.getId(), instance);
        if (instance instanceof AdminCommandInstanceImpl) {
            ((AdminCommandInstanceImpl)instance).setState(AdminCommandState.State.RUNNING);
        }
    }

    @Override
    public Iterator<Job> getJobs() {
        return this.jobRegistry.values().iterator();
    }

    @Override
    public Job get(String id) {
        return this.jobRegistry.get(id);
    }

    public synchronized ArrayList<JobInfo> getExpiredJobs() {
        ArrayList<JobInfo> expiredJobs = new ArrayList<JobInfo>();
        JobInfos jobInfos = this.getCompletedJobs();
        for (JobInfo job : jobInfos.getJobInfoList()) {
            long executedTime = job.commandExecutionDate;
            long currentTime = System.currentTimeMillis();
            long jobsRetentionPeriod = 86400000L;
            this.managedJobConfig = this.domain.getExtensionByType(ManagedJobConfig.class);
            jobsRetentionPeriod = this.convert(this.managedJobConfig.getJobRetentionPeriod());
            if (currentTime - executedTime <= jobsRetentionPeriod || !job.exitCode.equals(AdminCommandState.State.COMPLETED.name())) continue;
            expiredJobs.add(job);
        }
        return expiredJobs;
    }

    public long convert(String input) {
        String period = input.substring(0, input.length() - 1);
        Long timeInterval = new Long(period);
        String s = input.toLowerCase();
        long milliseconds = 86400000L;
        if (s.indexOf("s") > 0) {
            milliseconds = timeInterval * 1000L;
        } else if (s.indexOf("h") > 0) {
            milliseconds = timeInterval * 3600L * 1000L;
        } else if (s.indexOf("m") > 0) {
            milliseconds = timeInterval * 60L * 1000L;
        }
        return milliseconds;
    }

    @Override
    public synchronized void purgeJob(String id) {
        Job obj = this.jobRegistry.remove(id);
        logger.fine(adminStrings.getLocalString("removed.expired.job", "Removed expired job ", obj));
    }

    public ExecutorService getThreadPool() {
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobInfos getCompletedJobs() {
        File file = this.jobsFile;
        synchronized (file) {
            try {
                if (this.jaxbContext == null) {
                    this.jaxbContext = JAXBContext.newInstance(JobInfos.class);
                }
                Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                if (this.jobsFile != null && this.jobsFile.exists()) {
                    JobInfos jobInfos = (JobInfos)unmarshaller.unmarshal(this.jobsFile);
                    return jobInfos;
                }
            }
            catch (JAXBException e) {
                throw new RuntimeException(adminStrings.getLocalString("error.reading.completed.jobs", "Error reading completed jobs ", e.getLocalizedMessage()), e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobInfos purgeCompletedJobForId(String jobId) {
        File file = this.jobsFile;
        synchronized (file) {
            CopyOnWriteArrayList<JobInfo> jobList = new CopyOnWriteArrayList<JobInfo>();
            if (this.getCompletedJobs() != null) {
                jobList.addAll(this.getCompletedJobs().getJobInfoList());
            }
            for (JobInfo jobInfo : jobList) {
                if (!jobInfo.jobId.equals(jobId)) continue;
                jobList.remove(jobInfo);
            }
            JobInfos jobInfos = new JobInfos();
            try {
                if (this.jaxbContext == null) {
                    this.jaxbContext = JAXBContext.newInstance(JobInfos.class);
                }
                jobInfos.setJobInfoList(jobList);
                Marshaller jaxbMarshaller = this.jaxbContext.createMarshaller();
                jaxbMarshaller.marshal((Object)jobInfos, this.jobsFile);
            }
            catch (JAXBException e) {
                throw new RuntimeException(adminStrings.getLocalString("error.purging.completed.job", "Error purging completed job ", jobId, e.getLocalizedMessage()), e);
            }
            return jobInfos;
        }
    }

    @Override
    public void postConstruct() {
        this.jobsFile = new File(this.serverEnvironment.getConfigDirPath(), "jobs.xml");
        this.pool = this.executorFactory.provide();
    }

    @Override
    public File getJobsFile() {
        return this.jobsFile;
    }
}

