/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.progress.CommandProgressImpl;
import com.sun.enterprise.admin.progress.ProgressStatusClient;
import java.util.UUID;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandContextForInstance;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.Progress;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.SupplementalCommandExecutor;
import org.glassfish.api.admin.progress.ProgressStatusBase;
import org.glassfish.api.admin.progress.ProgressStatusEvent;
import org.glassfish.api.admin.progress.ProgressStatusMirroringImpl;
import org.glassfish.config.support.GenericCrudCommand;

class CommandRunnerProgressHelper {
    private Progress progressAnnotation;
    private CommandProgressImpl commandProgress;
    private int replicationCount = 0;
    private ProgressStatus progressForMainCommand = null;
    private ProgressStatusMirroringImpl progressMirroring = null;

    public CommandRunnerProgressHelper(AdminCommand command, String name, Job commandInstance, ProgressStatus clientProgressStatus) {
        if (command instanceof GenericCrudCommand) {
            GenericCrudCommand gcc = (GenericCrudCommand)((Object)command);
            Class decorator = gcc.getDecoratorClass();
            if (decorator != null) {
                this.progressAnnotation = decorator.getAnnotation(Progress.class);
            }
        } else {
            this.progressAnnotation = command.getClass().getAnnotation(Progress.class);
        }
        if (this.progressAnnotation != null) {
            this.commandProgress = this.progressAnnotation.name() == null || this.progressAnnotation.name().isEmpty() ? new CommandProgressImpl(name, this.createIdForCommandProgress(commandInstance)) : new CommandProgressImpl(this.progressAnnotation.name(), this.createIdForCommandProgress(commandInstance));
            this.connectWithClientProgressStatus(commandInstance, clientProgressStatus);
            commandInstance.setCommandProgress(this.commandProgress);
        }
    }

    private void connectWithClientProgressStatus(Job commandInstance, ProgressStatus clientProgressStatus) {
        if (clientProgressStatus == null) {
            return;
        }
        final ProgressStatusClient psc = new ProgressStatusClient(clientProgressStatus);
        commandInstance.getEventBroker().registerListener("ProgressStatus/state", new AdminCommandEventBroker.AdminCommandListener<ProgressStatusBase>(){

            @Override
            public void onAdminCommandEvent(String name, ProgressStatusBase event) {
                psc.mirror(event);
            }
        });
        commandInstance.getEventBroker().registerListener("ProgressStatus/change", new AdminCommandEventBroker.AdminCommandListener<ProgressStatusEvent>(){

            @Override
            public void onAdminCommandEvent(String name, ProgressStatusEvent event) {
                psc.mirror(event);
            }
        });
    }

    private String createIdForCommandProgress(Job commandInstance) {
        String cid;
        String string = cid = commandInstance == null ? null : commandInstance.getId();
        if (cid == null || cid.isEmpty()) {
            cid = UUID.randomUUID().toString();
        }
        return cid;
    }

    public int getReplicationCount() {
        return this.replicationCount;
    }

    public void setReplicationCount(int replicationCount) {
        this.replicationCount = replicationCount;
    }

    public void addProgressStatusToSupplementalCommand(SupplementalCommandExecutor.SupplementalCommand supplemental) {
        if (this.commandProgress == null || supplemental == null) {
            return;
        }
        if (this.progressForMainCommand != null && this.progressMirroring == null) {
            throw new IllegalStateException("Suplmenetal commands must be filled with ProgressStatus before main command!");
        }
        if (this.replicationCount < 0) {
            throw new IllegalStateException("Replication count must be provided first");
        }
        if (supplemental.getProgressAnnotation() != null) {
            if (this.progressMirroring == null) {
                this.commandProgress.setTotalStepCount(this.replicationCount + 1);
                this.progressMirroring = this.commandProgress.createMirroringChild(1);
                this.progressForMainCommand = this.progressMirroring.createChild(null, 0, this.progressAnnotation.totalStepCount());
            }
            supplemental.setProgressStatus(this.progressMirroring.createChild(supplemental.getProgressAnnotation().name(), 0, supplemental.getProgressAnnotation().totalStepCount()));
        }
    }

    public AdminCommandContext wrapContext4MainCommand(AdminCommandContext context) {
        if (this.progressForMainCommand != null) {
            return new AdminCommandContextForInstance(context, this.progressForMainCommand);
        }
        if (this.commandProgress != null) {
            if (this.replicationCount > 0) {
                this.commandProgress.setTotalStepCount(this.replicationCount + 1);
                this.progressForMainCommand = this.commandProgress.createChild(null, 1, this.progressAnnotation.totalStepCount());
            } else {
                this.commandProgress.setTotalStepCount(this.progressAnnotation.totalStepCount());
                this.progressForMainCommand = this.commandProgress;
            }
            return new AdminCommandContextForInstance(context, this.progressForMainCommand);
        }
        return context;
    }
}

