/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.admin.util.CommandSecurityChecker;
import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.util.AnnotationUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CommandNotFoundException;
import com.sun.enterprise.v3.admin.CommandRunnerProgressHelper;
import com.sun.enterprise.v3.admin.JobCreatorService;
import com.sun.enterprise.v3.common.XMLContentActionReporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.security.auth.Subject;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandLock;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandSupport;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobCreator;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.ManagedJob;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.SupplementalCommandExecutor;
import org.glassfish.api.admin.WrappedAdminCommand;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.common.util.admin.ManPageFinder;
import org.glassfish.common.util.admin.MapInjectionResolver;
import org.glassfish.common.util.admin.UnacceptableValueException;
import org.glassfish.config.support.GenericCrudCommand;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.InjectionManager;
import org.jvnet.hk2.config.InjectionResolver;
import org.jvnet.hk2.config.MessageInterpolatorImpl;
import org.jvnet.hk2.config.UnsatisfiedDependencyException;

@Service
public class CommandRunnerImpl
implements CommandRunner {
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private static final String OLD_PASSWORD_PARAM_PREFIX = "AS_ADMIN_";
    private final InjectionManager injectionMgr = new InjectionManager();
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ServerContext sc;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private InstanceStateService state;
    @Inject
    private AdminCommandLock adminLock;
    @Inject
    @Named(value="SupplementalCommandExecutorImpl")
    SupplementalCommandExecutor supplementalExecutor;
    @Inject
    JobManager jobRegistry;
    private final Map<NameCommandClassPair, String> commandModelEtagMap = new IdentityHashMap<NameCommandClassPair, String>();
    @Inject
    private CommandSecurityChecker commandSecurityChecker;
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(CommandRunnerImpl.class);
    private static volatile Validator beanValidator = null;

    @Override
    public ActionReport getActionReport(String name) {
        return this.habitat.getService(ActionReport.class, name, new Annotation[0]);
    }

    @Override
    public CommandModel getModel(String commandName, Logger logger2) {
        return this.getModel(null, commandName, logger2);
    }

    @Override
    public CommandModel getModel(String scope, String commandName, Logger logger2) {
        AdminCommand command;
        try {
            String commandServiceName = scope != null ? scope + commandName : commandName;
            command = this.habitat.getService(AdminCommand.class, commandServiceName, new Annotation[0]);
        }
        catch (MultiException e) {
            logger2.log(Level.SEVERE, "NCLS-CORE-0002", new Object[]{commandName, e});
            return null;
        }
        return command == null ? null : CommandRunnerImpl.getModel(command);
    }

    @Override
    public boolean validateCommandModelETag(AdminCommand command, String eTag) {
        if (command == null) {
            return true;
        }
        if (eTag == null || eTag.isEmpty()) {
            return false;
        }
        CommandModel model = CommandRunnerImpl.getModel(command);
        return this.validateCommandModelETag(model, eTag);
    }

    @Override
    public boolean validateCommandModelETag(CommandModel model, String eTag) {
        if (model == null) {
            return true;
        }
        if (eTag == null || eTag.isEmpty()) {
            return false;
        }
        String actualETag = CachedCommandModel.computeETag(model);
        return eTag.equals(actualETag);
    }

    @Override
    public AdminCommand getCommand(String commandName, ActionReport report, Logger logger2) {
        return this.getCommand(null, commandName, report, logger2);
    }

    private static Class<? extends Annotation> getScope(Class<?> onMe) {
        for (Annotation anno : onMe.getAnnotations()) {
            if (!anno.annotationType().isAnnotationPresent(Scope.class)) continue;
            return anno.annotationType();
        }
        return null;
    }

    @Override
    public AdminCommand getCommand(String scope, String commandName, ActionReport report, Logger logger2) {
        CommandModel model;
        AdminCommand command = null;
        String commandServiceName = scope != null ? scope + commandName : commandName;
        try {
            command = this.habitat.getService(AdminCommand.class, commandServiceName, new Annotation[0]);
        }
        catch (MultiException e) {
            report.setFailureCause(e);
        }
        if (command == null) {
            String msg = !CommandRunnerImpl.ok(commandName) ? adminStrings.getLocalString("adapter.command.nocommand", "No command was specified.") : (this.habitat.getServiceHandle(AdminCommand.class, commandServiceName, new Annotation[0]) == null ? adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", commandName) : adminStrings.getLocalString("adapter.command.notcreated", "Implementation for the command {0} exists in the system, but it has some errors, check server.log for details", commandName));
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            KernelLoggerInfo.getLogger().fine(msg);
            return null;
        }
        Class<? extends Annotation> myScope = CommandRunnerImpl.getScope(command.getClass());
        if (myScope == null) {
            String msg = adminStrings.getLocalString("adapter.command.noscope", "Implementation for the command {0} exists in the system,\nbut it has no @Scoped annotation", commandName);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            KernelLoggerInfo.getLogger().fine(msg);
            command = null;
        } else if (Singleton.class.equals(myScope) && (model = CommandRunnerImpl.getModel(command)).getParameters().size() > 0) {
            String msg = adminStrings.getLocalString("adapter.command.hasparams", "Implementation for the command {0} exists in the system,\nbut it's a singleton that also has parameters", commandName);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            KernelLoggerInfo.getLogger().fine(msg);
            command = null;
        }
        return command;
    }

    @Override
    public CommandRunner.CommandInvocation getCommandInvocation(String name, ActionReport report, Subject subject) {
        return this.getCommandInvocation(null, name, report, subject);
    }

    @Override
    public CommandRunner.CommandInvocation getCommandInvocation(String scope, String name, ActionReport report, Subject subject) {
        return new ExecutionContext(scope, name, report, subject);
    }

    private ActionReport.ExitCode injectParameters(CommandModel model, AdminCommand command, InjectionResolver<Param> injector, AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionDescription(model.getCommandName() + " command");
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (command instanceof GenericCrudCommand) {
            GenericCrudCommand c = (GenericCrudCommand)GenericCrudCommand.class.cast(command);
            c.setInjectionResolver(injector);
        }
        try {
            this.injectionMgr.inject((Object)command, injector);
        }
        catch (UnsatisfiedDependencyException e) {
            String errorMsg;
            Param param = e.getAnnotation(Param.class);
            CommandModel.ParamModel paramModel = null;
            for (CommandModel.ParamModel pModel : model.getParameters()) {
                if (!pModel.getParam().equals(param)) continue;
                paramModel = pModel;
                break;
            }
            String usage = CommandRunnerImpl.getUsageText(command, model);
            if (paramModel != null) {
                String paramName = paramModel.getName();
                String paramDesc = paramModel.getLocalizedDescription();
                errorMsg = param.primary() ? adminStrings.getLocalString("commandrunner.operand.required", "Operand required.") : (param.password() ? adminStrings.getLocalString("adapter.param.missing.passwordfile", "{0} command requires the passwordfile parameter containing {1} entry.", model.getCommandName(), paramName) : (paramDesc != null ? adminStrings.getLocalString("admin.param.missing", "{0} command requires the {1} parameter ({2})", model.getCommandName(), paramName, paramDesc) : adminStrings.getLocalString("admin.param.missing.nodesc", "{0} command requires the {1} parameter", model.getCommandName(), paramName)));
            } else {
                errorMsg = adminStrings.getLocalString("admin.param.missing.nofound", "Cannot find {1} in {0} command model, file a bug", model.getCommandName(), e.getUnsatisfiedName());
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(errorMsg);
            report.setFailureCause(e);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(usage);
            return report.getActionExitCode();
        }
        catch (MultiException e) {
            Exception exception = null;
            Iterator<Throwable> i$ = e.getErrors().iterator();
            block4: while (i$.hasNext()) {
                Throwable th;
                for (Throwable cause = th = i$.next(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof UnacceptableValueException) && !(cause instanceof IllegalArgumentException)) continue;
                    exception = (Exception)th;
                    continue block4;
                }
            }
            if (exception == null) {
                exception = e;
            }
            logger.log(Level.SEVERE, "NCLS-CORE-0003", exception);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(((Throwable)exception).getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(CommandRunnerImpl.getUsageText(command, model));
            return report.getActionExitCode();
        }
        this.checkAgainstBeanConstraints(command, model.getCommandName());
        return report.getActionExitCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initBeanValidator() {
        if (beanValidator != null) {
            return;
        }
        ClassLoader cl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            Thread.currentThread().setContextClassLoader(null);
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            ValidatorContext validatorContext = validatorFactory.usingContext();
            validatorContext.messageInterpolator(new MessageInterpolatorImpl());
            beanValidator = validatorContext.getValidator();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void checkAgainstBeanConstraints(AdminCommand component, String cname) {
        CommandRunnerImpl.initBeanValidator();
        Set<ConstraintViolation<AdminCommand>> constraintViolations = beanValidator.validate(component, new Class[0]);
        if (constraintViolations == null || constraintViolations.isEmpty()) {
            return;
        }
        StringBuilder msg = new StringBuilder(adminStrings.getLocalString("commandrunner.unacceptableBV", "Parameters for command {0} violate the following constraints: ", cname));
        boolean addc = false;
        String violationMsg = adminStrings.getLocalString("commandrunner.unacceptableBV.reason", "on parameter [ {1} ] violation reason [ {0} ]");
        for (ConstraintViolation<AdminCommand> cv : constraintViolations) {
            if (addc) {
                msg.append(", ");
            }
            msg.append(MessageFormat.format(violationMsg, cv.getMessage(), cv.getPropertyPath()));
            addc = true;
        }
        throw new UnacceptableValueException(msg.toString());
    }

    private ActionReport doCommand(CommandModel model, final AdminCommand command, AdminCommandContext context, CommandRunnerProgressHelper progressHelper) {
        ActionReport report = context.getActionReport();
        report.setActionDescription(model.getCommandName() + " AdminCommand");
        AdminCommand wrappedCommand = new WrappedAdminCommand(command){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(final AdminCommandContext context) {
                ClassLoader ccl;
                Thread thread = Thread.currentThread();
                ClassLoader origCL = thread.getContextClassLoader();
                if (origCL != (ccl = CommandRunnerImpl.this.sc.getCommonClassLoader())) {
                    try {
                        thread.setContextClassLoader(ccl);
                        Subject.doAs(context.getSubject(), new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                command.execute(context);
                                return null;
                            }
                        });
                    }
                    finally {
                        thread.setContextClassLoader(origCL);
                    }
                } else {
                    command.execute(context);
                }
            }
        };
        wrappedCommand = CommandSupport.createWrappers(this.habitat, model, wrappedCommand, report);
        try {
            wrappedCommand.execute(progressHelper.wrapContext4MainCommand(context));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "NCLS-CORE-0003", e);
            report.setMessage(e.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
        return context.getActionReport();
    }

    static String getUsageText(AdminCommand command, CommandModel model) {
        StringBuffer usageText = new StringBuffer();
        String usage = model.getUsageText();
        if (CommandRunnerImpl.ok(usage)) {
            usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
            usageText.append(usage);
            return usageText.toString();
        }
        return CommandRunnerImpl.generateUsageText(model);
    }

    private static String generateUsageText(CommandModel model) {
        StringBuffer usageText = new StringBuffer();
        usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
        usageText.append(model.getCommandName());
        usageText.append(" ");
        StringBuffer operand = new StringBuffer();
        for (CommandModel.ParamModel pModel : model.getParameters()) {
            Param param = pModel.getParam();
            String paramName = pModel.getName().toLowerCase(Locale.ENGLISH);
            if (paramName.startsWith("_") || param.password() || param.obsolete()) continue;
            boolean optional = param.optional();
            Class ftype = pModel.getType();
            String fvalue = null;
            String fvalueString = null;
            try {
                fvalue = param.defaultValue();
                if (fvalue != null) {
                    fvalueString = fvalue.toString();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (param.primary()) {
                if (optional) {
                    operand.append("[").append(paramName).append("] ");
                    continue;
                }
                operand.append(paramName).append(" ");
                continue;
            }
            if (optional) {
                usageText.append("[");
            }
            usageText.append("--").append(paramName);
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                usageText.append("=").append(param.defaultValue());
            } else if (ftype.isAssignableFrom(String.class)) {
                if (CommandRunnerImpl.ok(fvalueString)) {
                    usageText.append("=").append(fvalueString);
                } else {
                    usageText.append("=").append(paramName);
                }
            } else if (ftype.isAssignableFrom(Boolean.class)) {
                usageText.append("=").append("true|false");
            } else {
                usageText.append("=").append(paramName);
            }
            if (optional) {
                usageText.append("] ");
                continue;
            }
            usageText.append(" ");
        }
        usageText.append(operand);
        return usageText.toString();
    }

    @Override
    public BufferedReader getHelp(CommandModel model) throws CommandNotFoundException {
        BufferedReader manPage = CommandRunnerImpl.getManPage(model.getCommandName(), model);
        if (manPage != null) {
            return manPage;
        }
        StringBuilder hlp = new StringBuilder(256);
        StringBuilder part = new StringBuilder(64);
        hlp.append("NAME").append(ManifestUtils.EOL);
        part.append(model.getCommandName());
        String description = model.getLocalizedDescription();
        if (CommandRunnerImpl.ok(description)) {
            part.append(" - ").append(model.getLocalizedDescription());
        }
        hlp.append(this.formatGeneratedManPagePart(part.toString(), 5, 65)).append(ManifestUtils.EOL);
        hlp.append(ManifestUtils.EOL).append("SYNOPSIS").append(ManifestUtils.EOL);
        hlp.append(this.formatGeneratedManPagePart(CommandRunnerImpl.getUsageText(null, model), 5, 65));
        hlp.append(ManifestUtils.EOL).append(ManifestUtils.EOL);
        hlp.append("OPTIONS").append(ManifestUtils.EOL);
        CommandModel.ParamModel operand = null;
        for (CommandModel.ParamModel paramModel : model.getParameters()) {
            String descr;
            Param param = paramModel.getParam();
            if (param == null || paramModel.getName().startsWith("_") || param.password() || param.obsolete()) continue;
            if (param.primary()) {
                operand = paramModel;
                continue;
            }
            hlp.append("     --").append(paramModel.getName().toLowerCase(Locale.ENGLISH));
            hlp.append(ManifestUtils.EOL);
            if (CommandRunnerImpl.ok(param.shortName())) {
                hlp.append("      -").append(param.shortName().toLowerCase(Locale.ENGLISH));
                hlp.append(ManifestUtils.EOL);
            }
            if (CommandRunnerImpl.ok(descr = paramModel.getLocalizedDescription())) {
                hlp.append(this.formatGeneratedManPagePart(descr, 9, 65));
            }
            hlp.append(ManifestUtils.EOL);
        }
        if (operand != null) {
            hlp.append("OPERANDS").append(ManifestUtils.EOL);
            hlp.append("     ").append(operand.getName().toLowerCase(Locale.ENGLISH));
            hlp.append(ManifestUtils.EOL);
            String descr = operand.getLocalizedDescription();
            if (CommandRunnerImpl.ok(descr)) {
                hlp.append(this.formatGeneratedManPagePart(descr, 9, 65));
            }
        }
        return new BufferedReader(new StringReader(hlp.toString()));
    }

    private String formatGeneratedManPagePart(String part, int prefix, int lineLength) {
        if (part == null) {
            return null;
        }
        if (prefix < 0) {
            prefix = 0;
        }
        StringBuilder sb = new StringBuilder(prefix);
        for (int i = 0; i < prefix; ++i) {
            sb.append(' ');
        }
        String prfx = sb.toString();
        StringBuilder result = new StringBuilder(part.length() + prefix + 16);
        boolean newLine = true;
        boolean lastWasCR = false;
        int counter = 0;
        for (int i = 0; i < part.length(); ++i) {
            boolean addPrefix = newLine;
            char ch = part.charAt(i);
            switch (ch) {
                case '\n': {
                    if (!lastWasCR) {
                        newLine = true;
                    } else {
                        lastWasCR = false;
                    }
                    counter = 0;
                    break;
                }
                case '\r': {
                    newLine = true;
                    lastWasCR = true;
                    counter = 0;
                    break;
                }
                default: {
                    newLine = false;
                    lastWasCR = false;
                    ++counter;
                }
            }
            if (addPrefix && !newLine) {
                result.append(prfx);
                counter += prefix;
            }
            result.append(ch);
            if (lineLength <= 0 || counter < lineLength || newLine) continue;
            newLine = true;
            result.append(ManifestUtils.EOL);
            counter = 0;
        }
        return result.toString();
    }

    public void getHelp(AdminCommand command, ActionReport report) {
        CommandModel model = CommandRunnerImpl.getModel(command);
        report.setActionDescription(model.getCommandName() + " help");
        if (report instanceof XMLContentActionReporter) {
            this.getMetadata(command, model, report);
        } else {
            report.setMessage(model.getCommandName() + " - " + model.getLocalizedDescription());
            report.getTopMessagePart().addProperty("SYNOPSIS", CommandRunnerImpl.encodeManPage(new BufferedReader(new StringReader(CommandRunnerImpl.getUsageText(command, model)))));
            for (CommandModel.ParamModel param : model.getParameters()) {
                this.addParamUsage(report, param);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void getMetadata(AdminCommand command, CommandModel model, ActionReport report) {
        String usage;
        ActionReport.MessagePart top = report.getTopMessagePart();
        ActionReport.MessagePart cmd = top.addChild();
        cmd.setChildrenType("command");
        cmd.addProperty("name", model.getCommandName());
        if (model.unknownOptionsAreOperands()) {
            cmd.addProperty("unknown-options-are-operands", "true");
        }
        if (CommandRunnerImpl.ok(usage = model.getUsageText())) {
            cmd.addProperty("usage", usage);
        }
        CommandModel.ParamModel primary = null;
        for (CommandModel.ParamModel p : model.getParameters()) {
            String paramDesc;
            Param param = p.getParam();
            if (param.primary()) {
                primary = p;
                continue;
            }
            ActionReport.MessagePart ppart = cmd.addChild();
            ppart.setChildrenType("option");
            ppart.addProperty("name", p.getName());
            ppart.addProperty("type", CommandRunnerImpl.typeOf(p));
            ppart.addProperty("optional", Boolean.toString(param.optional()));
            if (param.obsolete()) {
                ppart.addProperty("obsolete", "true");
            }
            if (CommandRunnerImpl.ok(paramDesc = p.getLocalizedDescription())) {
                ppart.addProperty("description", paramDesc);
            }
            if (CommandRunnerImpl.ok(param.shortName())) {
                ppart.addProperty("short", param.shortName());
            }
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                ppart.addProperty("default", param.defaultValue());
            }
            if (CommandRunnerImpl.ok(param.acceptableValues())) {
                ppart.addProperty("acceptable-values", param.acceptableValues());
            }
            if (!CommandRunnerImpl.ok(param.alias())) continue;
            ppart.addProperty("alias", param.alias());
        }
        if (primary != null) {
            ActionReport.MessagePart primpart = cmd.addChild();
            primpart.setChildrenType("operand");
            primpart.addProperty("name", primary.getName());
            primpart.addProperty("type", CommandRunnerImpl.typeOf(primary));
            primpart.addProperty("min", primary.getParam().optional() ? "0" : "1");
            primpart.addProperty("max", primary.getParam().multiple() ? "unlimited" : "1");
            String desc = primary.getLocalizedDescription();
            if (CommandRunnerImpl.ok(desc)) {
                primpart.addProperty("description", desc);
            }
        }
    }

    private static String typeOf(CommandModel.ParamModel p) {
        Class t = p.getType();
        if (t == Boolean.class || t == Boolean.TYPE) {
            return "BOOLEAN";
        }
        if (t == File.class || t == File[].class) {
            return "FILE";
        }
        if (t == Properties.class) {
            return "PROPERTIES";
        }
        if (p.getParam().password()) {
            return "PASSWORD";
        }
        return "STRING";
    }

    public static BufferedReader getManPage(String commandName, CommandModel model) {
        Class<?> clazz = model.getCommandClass();
        if (clazz == null) {
            return null;
        }
        return ManPageFinder.getCommandManPage(commandName, clazz.getName(), Locale.getDefault(), clazz.getClassLoader(), logger);
    }

    private void addParamUsage(ActionReport report, CommandModel.ParamModel model) {
        Param param = model.getParam();
        if (param != null) {
            String paramName = model.getName().toLowerCase(Locale.ENGLISH);
            if (paramName.startsWith("_")) {
                return;
            }
            if (param.password()) {
                return;
            }
            if (param.obsolete()) {
                return;
            }
            if (param.primary()) {
                report.getTopMessagePart().addProperty(paramName + "_operand", model.getLocalizedDescription());
            } else {
                report.getTopMessagePart().addProperty(paramName, model.getLocalizedDescription());
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static void validateParameters(CommandModel model, ParameterMap parameters) throws MultiException {
        ParameterMap adds = null;
        for (Map.Entry entry : parameters.entrySet()) {
            CommandModel.ParamModel pModel;
            String key = (String)entry.getKey();
            if (key.equals("DEFAULT") || key.equals("help") || key.equals("Xhelp")) continue;
            if (key.startsWith(OLD_PASSWORD_PARAM_PREFIX)) {
                key = key.substring(OLD_PASSWORD_PARAM_PREFIX.length()).toLowerCase(Locale.ENGLISH);
                if (adds == null) {
                    adds = new ParameterMap();
                }
                adds.add(key, entry.getValue().get(0));
            }
            boolean validOption = false;
            Iterator<CommandModel.ParamModel> i$ = model.getParameters().iterator();
            while (i$.hasNext() && !(validOption = (pModel = i$.next()).isParamId(key))) {
            }
            if (validOption) continue;
            throw new MultiException(new IllegalArgumentException(" Invalid option: " + key));
        }
        parameters.mergeAll(adds);
    }

    static boolean skipValidation(AdminCommand command) {
        try {
            final Field f = command.getClass().getDeclaredField("skipParamValidation");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    f.setAccessible(true);
                    return null;
                }
            });
            if (f.getType().isAssignableFrom(Boolean.TYPE)) {
                return f.getBoolean(command);
            }
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encodeManPage(BufferedReader br) {
        if (br == null) {
            return null;
        }
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("%%%EOL%%%");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static CommandModel getModel(AdminCommand command) {
        if (command instanceof CommandModelProvider) {
            return ((CommandModelProvider)((Object)command)).getModel();
        }
        return new CommandModelImpl(command.getClass());
    }

    /*
     * Exception decompiling
     */
    private void doCommand(ExecutionContext inv, AdminCommand command, Subject subject, Job commandInstance) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 31[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Object> buildEnvMap(ParameterMap params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : params.entrySet()) {
            List values = entry.getValue();
            if (values == null || values.size() <= 0) continue;
            result.put((String)entry.getKey(), values.get(0));
        }
        return result;
    }

    private static boolean isSet(ParameterMap params, String name) {
        String val = (String)params.getOne(name);
        if (val == null) {
            return false;
        }
        return val.length() == 0 || Boolean.valueOf(val) != false;
    }

    private String formatSuspendDate(Date lockTime) {
        if (lockTime != null) {
            String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            return sdf.format(lockTime);
        }
        return adminStrings.getLocalString("lock.timeoutunavailable", "<<Date is unavailable>>");
    }

    private static class DelegatedInjectionResolver
    extends InjectionResolver<Param> {
        private final CommandModel model;
        private final CommandParameters parameters;
        private final MultiMap<String, File> optionNameToUploadedFileMap;

        public DelegatedInjectionResolver(CommandModel model, CommandParameters parameters, MultiMap<String, File> optionNameToUploadedFileMap) {
            super(Param.class);
            this.model = model;
            this.parameters = parameters;
            this.optionNameToUploadedFileMap = optionNameToUploadedFileMap;
        }

        @Override
        public boolean isOptional(AnnotatedElement element, Param annotation) {
            String name = CommandModel.getParamName(annotation, element);
            CommandModel.ParamModel param = this.model.getModelFor(name);
            return param.getParam().optional();
        }

        @Override
        public <V> V getValue(Object component, AnnotatedElement target, Type genericType, Class<V> type2) {
            if (target instanceof Field) {
                final Field targetField = (Field)target;
                try {
                    Field sourceField = this.parameters.getClass().getField(targetField.getName());
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            targetField.setAccessible(true);
                            return null;
                        }
                    });
                    Object paramValue = sourceField.get(this.parameters);
                    List<String> paramFileValues = MapInjectionResolver.getUploadedFileParamValues(targetField.getName(), targetField.getType(), this.optionNameToUploadedFileMap);
                    if (!paramFileValues.isEmpty()) {
                        Object fileValue = MapInjectionResolver.convertListToObject(target, type2, paramFileValues);
                        return (V)fileValue;
                    }
                    if (paramValue != null) {
                        DelegatedInjectionResolver.checkAgainstAcceptableValues(target, paramValue.toString());
                    }
                    return type2.cast(paramValue);
                }
                catch (IllegalAccessException e) {
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            return null;
        }

        private static void checkAgainstAcceptableValues(AnnotatedElement target, String paramValueStr) {
            Param param = target.getAnnotation(Param.class);
            String acceptable = param.acceptableValues();
            String paramName = CommandModel.getParamName(param, target);
            if (CommandRunnerImpl.ok(acceptable) && CommandRunnerImpl.ok(paramValueStr)) {
                String[] ss;
                for (String s : ss = acceptable.split(",")) {
                    if (!paramValueStr.equals(s.trim())) continue;
                    return;
                }
                throw new UnacceptableValueException(adminStrings.getLocalString("adapter.command.unacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", paramName, paramValueStr, acceptable));
            }
        }
    }

    class ExecutionContext
    implements CommandRunner.CommandInvocation {
        protected final String scope;
        protected final String name;
        protected ActionReport report;
        protected ParameterMap params;
        protected CommandParameters paramObject;
        protected Payload.Inbound inbound;
        protected Payload.Outbound outbound;
        protected Subject subject;
        protected ProgressStatus progressStatusChild;
        protected boolean isManagedJob;
        private List<NameListerPair> nameListerPairs = new ArrayList<NameListerPair>();

        private ExecutionContext(String scope, String name, ActionReport report, Subject subject) {
            this.scope = scope;
            this.name = name;
            this.report = report;
            this.subject = subject;
        }

        @Override
        public CommandRunner.CommandInvocation parameters(CommandParameters paramObject) {
            this.paramObject = paramObject;
            return this;
        }

        @Override
        public CommandRunner.CommandInvocation parameters(ParameterMap params) {
            this.params = params;
            return this;
        }

        @Override
        public CommandRunner.CommandInvocation inbound(Payload.Inbound inbound) {
            this.inbound = inbound;
            return this;
        }

        @Override
        public CommandRunner.CommandInvocation outbound(Payload.Outbound outbound) {
            this.outbound = outbound;
            return this;
        }

        @Override
        public CommandRunner.CommandInvocation listener(String nameRegexp, AdminCommandEventBroker.AdminCommandListener listener) {
            this.nameListerPairs.add(new NameListerPair(nameRegexp, listener));
            return this;
        }

        @Override
        public CommandRunner.CommandInvocation progressStatusChild(ProgressStatus ps) {
            this.progressStatusChild = ps;
            return this;
        }

        @Override
        public CommandRunner.CommandInvocation managedJob() {
            this.isManagedJob = true;
            return this;
        }

        @Override
        public void execute() {
            this.execute(null);
        }

        private ParameterMap parameters() {
            return this.params;
        }

        private CommandParameters typedParams() {
            return this.paramObject;
        }

        private String name() {
            return this.name;
        }

        private String scope() {
            return this.scope;
        }

        @Override
        public ActionReport report() {
            return this.report;
        }

        private void setReport(ActionReport ar) {
            this.report = ar;
        }

        private Payload.Inbound inboundPayload() {
            return this.inbound;
        }

        private Payload.Outbound outboundPayload() {
            return this.outbound;
        }

        @Override
        public void execute(AdminCommand command) {
            if (command == null && (command = CommandRunnerImpl.this.getCommand(this.scope(), this.name(), this.report(), logger)) == null) {
                return;
            }
            if (this.subject == null) {
                this.subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                    @Override
                    public Subject run() {
                        return Subject.getSubject(AccessController.getContext());
                    }
                });
            }
            if (!this.isManagedJob) {
                this.isManagedJob = AnnotationUtil.presentTransitive(ManagedJob.class, command.getClass());
            }
            JobCreator jobCreator = null;
            jobCreator = this.scope() != null ? CommandRunnerImpl.this.habitat.getService(JobCreator.class, this.scope + "job-creator", new Annotation[0]) : (JobCreator)CommandRunnerImpl.this.habitat.getService(JobCreatorService.class, new Annotation[0]);
            Job commandInstance = null;
            commandInstance = this.isManagedJob ? jobCreator.createJob(CommandRunnerImpl.this.jobRegistry.getNewId(), this.scope(), this.name(), this.subject, this.isManagedJob) : jobCreator.createJob(null, this.scope(), this.name(), this.subject, this.isManagedJob);
            for (NameListerPair nameListerPair : this.nameListerPairs) {
                commandInstance.getEventBroker().registerListener(nameListerPair.nameRegexp, nameListerPair.listener);
            }
            if (this.isManagedJob) {
                CommandRunnerImpl.this.jobRegistry.registerJob(commandInstance);
            }
            CommandRunnerImpl.this.doCommand(this, command, this.subject, commandInstance);
            commandInstance.complete(this.report(), this.outboundPayload());
            if (this.progressStatusChild != null) {
                this.progressStatusChild.complete();
            }
            CommandSupport.done(CommandRunnerImpl.this.habitat, command, commandInstance);
        }

        static /* synthetic */ Payload.Inbound access$200(ExecutionContext x0) {
            return x0.inboundPayload();
        }

        static /* synthetic */ Payload.Outbound access$300(ExecutionContext x0) {
            return x0.outboundPayload();
        }

        static /* synthetic */ CommandParameters access$500(ExecutionContext x0) {
            return x0.typedParams();
        }

        static /* synthetic */ void access$700(ExecutionContext x0, ActionReport x1) {
            x0.setReport(x1);
        }

        static /* synthetic */ ParameterMap access$800(ExecutionContext x0) {
            return x0.parameters();
        }

        static /* synthetic */ String access$900(ExecutionContext x0) {
            return x0.name();
        }

        private class NameListerPair {
            private String nameRegexp;
            private AdminCommandEventBroker.AdminCommandListener listener;

            public NameListerPair(String nameRegexp, AdminCommandEventBroker.AdminCommandListener listener) {
                this.nameRegexp = nameRegexp;
                this.listener = listener;
            }
        }
    }

    private static class NameCommandClassPair {
        private String name;
        private Class<? extends AdminCommand> clazz;
        private int hash;

        public NameCommandClassPair(String name, Class<? extends AdminCommand> clazz) {
            this.name = name;
            this.clazz = clazz;
            this.hash = 3;
            this.hash = 67 * this.hash + (this.name != null ? this.name.hashCode() : 0);
            this.hash = 67 * this.hash + (this.clazz != null ? this.clazz.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameCommandClassPair other = (NameCommandClassPair)obj;
            if (this.clazz != other.clazz) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class UploadedFilesManager {
        private final ActionReport report;
        private final Logger logger;
        private MultiMap<String, File> optionNameToFileMap;
        private PayloadFilesManager.Temp payloadFilesMgr = null;

        private UploadedFilesManager(ActionReport report, Logger logger2, Payload.Inbound inboundPayload) throws IOException, Exception {
            this.logger = logger2;
            this.report = report;
            this.extractFiles(inboundPayload);
        }

        private MultiMap<String, File> optionNameToFileMap() {
            return this.optionNameToFileMap;
        }

        private void close() {
            if (this.payloadFilesMgr != null) {
                this.payloadFilesMgr.cleanup();
            }
        }

        private void extractFiles(Payload.Inbound inboundPayload) throws Exception {
            if (inboundPayload == null) {
                return;
            }
            File uniqueSubdirUnderApplications = this.chooseTempDirParent();
            this.payloadFilesMgr = new PayloadFilesManager.Temp(uniqueSubdirUnderApplications, this.report, this.logger);
            Map<File, Properties> payloadFiles = this.payloadFilesMgr.processPartsExtended(inboundPayload);
            this.optionNameToFileMap = new MultiMap();
            for (Map.Entry<File, Properties> e : payloadFiles.entrySet()) {
                String optionName = e.getValue().getProperty("data-request-name");
                if (optionName == null) continue;
                this.logger.finer("UploadedFilesManager: map " + optionName + " to " + e.getKey());
                this.optionNameToFileMap.add(optionName, e.getKey());
            }
        }

        private File chooseTempDirParent() throws IOException {
            File appRoot = new File(CommandRunnerImpl.this.domain.getApplicationRoot());
            if (!(appRoot.isDirectory() || appRoot.exists() || appRoot.mkdirs())) {
                throw new IOException(adminStrings.getLocalString("commandrunner.errCreDir", "Could not create the directory {0}; no further information is available.", appRoot.getAbsolutePath()));
            }
            return appRoot;
        }

        static /* synthetic */ MultiMap access$600(UploadedFilesManager x0) {
            return x0.optionNameToFileMap();
        }

        static /* synthetic */ void access$1000(UploadedFilesManager x0) {
            x0.close();
        }
    }
}

