/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.server.logging.LogFacade;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public class LogFile
implements Serializable {
    private static SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final String RECORD_BEGIN_MARKER = "[#|";
    public static final String RECORD_END_MARKER = "|#]";
    public static final String FIELD_SEPARATOR = "|";
    private static final String FIELD_SEPARATOR_REGEX = "\\|";
    private long _indexSize = 10L;
    private String _logFileName = null;
    private List _recordIdx = new ArrayList();

    public LogFile(String name) {
        this._recordIdx.add(0L);
        this.setLogFileName(name);
    }

    public List getLogEntries(long startingRecord) {
        return this.getLogEntries(startingRecord, this.getIndexSize());
    }

    public List getLogEntries(long startingRecord, long maxRecords) {
        ArrayList<LogEntry> results;
        block17: {
            if (startingRecord < 0L) {
                return null;
            }
            BufferedReader reader = this.getFilePosition(startingRecord);
            results = new ArrayList<LogEntry>();
            block11: while (true) {
                try {
                    while ((long)results.size() < maxRecords) {
                        StringBuffer buffer = new StringBuffer();
                        String line = reader.readLine();
                        if (line == null) {
                            break block17;
                        }
                        if (!line.startsWith(RECORD_BEGIN_MARKER)) continue;
                        buffer.append(line);
                        while (line != null && !line.endsWith(RECORD_END_MARKER)) {
                            buffer.append("\n");
                            line = reader.readLine();
                            buffer.append(line);
                        }
                        try {
                            results.add(new LogEntry(buffer.toString(), startingRecord + (long)results.size()));
                            continue block11;
                        }
                        catch (IllegalArgumentException ex) {
                            LogFacade.LOGGING_LOGGER.log(Level.FINE, "Could not read the log entry", ex);
                        }
                    }
                    break block17;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void buildLogFileIndex() {
        long recordCount = -1L;
        char[] recordBeginMarker = RECORD_BEGIN_MARKER.toCharArray();
        int recordBeginMarkerLen = recordBeginMarker.length;
        long charPos = (Long)this._recordIdx.get(this._recordIdx.size() - 1);
        BufferedReader reader = this.getLogFileReader(charPos);
        long localIndexSize = this.getIndexSize();
        try {
            try {
                int cnt;
                while ((cnt = reader.read()) != -1) {
                    int idx;
                    ++charPos;
                    for (idx = 0; idx < recordBeginMarkerLen && cnt == recordBeginMarker[idx]; ++idx) {
                        cnt = reader.read();
                        ++charPos;
                    }
                    if (idx != recordBeginMarkerLen || ++recordCount != localIndexSize) continue;
                    recordCount = 0L;
                    this._recordIdx.add(charPos - (long)(recordBeginMarkerLen + 1));
                }
            }
            catch (EOFException ex) {
            }
            catch (Exception ex) {
                LogFacade.LOGGING_LOGGER.log(Level.FINE, "Error trying to position where we left off", ex);
            }
        }
        catch (Exception ex) {
            LogFacade.LOGGING_LOGGER.log(Level.FINE, "Error trying to position where we left off", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected BufferedReader getFilePosition(long recordNumber) {
        int index = (int)(recordNumber / this.getIndexSize());
        if (this._recordIdx.size() <= index) {
            this.buildLogFileIndex();
            if (this._recordIdx.size() <= index) {
                throw new IllegalArgumentException("Attempting to access Log entries that don't exist! ");
            }
        }
        return this.getRecordPosition(index, (int)(recordNumber % this.getIndexSize()));
    }

    private BufferedReader getRecordPosition(int index, int recordsToAdvance) {
        long filePosition = (Long)this._recordIdx.get(index);
        BufferedReader reader = this.getLogFileReader(filePosition);
        char[] recordBeginMarker = RECORD_BEGIN_MARKER.toCharArray();
        int recordBeginMarkerLen = recordBeginMarker.length;
        while (recordsToAdvance > 0) {
            try {
                int idx;
                int ch = reader.read();
                ++filePosition;
                for (idx = 0; idx < recordBeginMarkerLen && ch == recordBeginMarker[idx]; ++idx) {
                    ch = reader.read();
                    ++filePosition;
                }
                if (idx != recordBeginMarkerLen) continue;
                --recordsToAdvance;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return reader;
    }

    protected BufferedReader getLogFileReader(long fromFilePosition) {
        FileInputStream file = null;
        try {
            file = new FileInputStream(this.getLogFileName());
            long bytesSkipped = file.skip(fromFilePosition);
            if (bytesSkipped != fromFilePosition && LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) {
                LogFacade.LOGGING_LOGGER.log(Level.FINE, "Did not skip exact bytes while positioning reader in " + this.getLogFileName());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(file));
            return reader;
        }
        catch (Exception ex) {
            block7: {
                if (LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) {
                    LogFacade.LOGGING_LOGGER.log(Level.FINE, "Error reading from file: " + this.getLogFileName(), ex);
                }
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception ex2) {
                        if (!LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) break block7;
                        LogFacade.LOGGING_LOGGER.log(Level.FINE, "Error closing file: " + this.getLogFileName(), ex2);
                    }
                }
            }
            return null;
        }
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    public void setLogFileName(String filename) {
        if (filename.equals(this.getLogFileName())) {
            return;
        }
        this._logFileName = filename;
        this._recordIdx = new ArrayList();
        this._recordIdx.add(0L);
    }

    public long getLastIndexNumber() {
        this.buildLogFileIndex();
        return this._recordIdx.size() - 1;
    }

    public long getIndexSize() {
        return this._indexSize;
    }

    public void setIndexSize(long indexSize) {
        this._indexSize = indexSize;
    }

    public static class LogEntry
    implements Serializable {
        private static final long serialVersionUID = -8597022493595023899L;
        private long recordNumber = -1L;
        private Date loggedDateTime = null;
        private String loggedLevel = null;
        private String loggedProduct = null;
        private String loggedLoggerName = null;
        private String loggedNameValuePairs = null;
        private String loggedMessage = null;
        private String messageId = "";

        public LogEntry(String line, long recordNumber) {
            if (!line.startsWith(LogFile.RECORD_BEGIN_MARKER)) {
                throw new IllegalArgumentException("Log Entries must start with: '[#|': '" + line + "'.");
            }
            String[] tokens = (line = line.substring(LogFile.RECORD_BEGIN_MARKER.length())).split(LogFile.FIELD_SEPARATOR_REGEX);
            if (tokens.length <= 5) {
                throw new IllegalArgumentException("Log Entry does not contain all required fields: '" + line + "'.");
            }
            try {
                this.setLoggedDateTime(SIMPLE_DATE_FORMAT.parse(tokens[0]));
                this.setLoggedLevel(tokens[1]);
                this.setLoggedProduct(tokens[2]);
                this.setLoggedLoggerName(tokens[3]);
                this.setLoggedNameValuePairs(tokens[4]);
                String message = tokens[5];
                if (message != null) {
                    this.setLoggedMessage(message);
                }
                this.setRecordNumber(recordNumber);
            }
            catch (Exception e) {
                RuntimeException t = new RuntimeException("Error in building Log Entry ");
                t.initCause(e);
                throw t;
            }
        }

        public Date getLoggedDateTime() {
            return this.loggedDateTime;
        }

        public void setLoggedDateTime(Date loggedDateTime) {
            this.loggedDateTime = loggedDateTime;
        }

        public String getLoggedLevel() {
            return this.loggedLevel;
        }

        public void setLoggedLevel(String loggedLevel) {
            this.loggedLevel = loggedLevel;
        }

        public String getLoggedProduct() {
            return this.loggedProduct;
        }

        public void setLoggedProduct(String loggedProduct) {
            this.loggedProduct = loggedProduct;
        }

        public String getLoggedLoggerName() {
            return this.loggedLoggerName;
        }

        public void setLoggedLoggerName(String loggedLoggerName) {
            this.loggedLoggerName = loggedLoggerName;
        }

        public String getLoggedNameValuePairs() {
            return this.loggedNameValuePairs;
        }

        public void setLoggedNameValuePairs(String loggedNameValuePairs) {
            this.loggedNameValuePairs = loggedNameValuePairs;
        }

        public void setLoggedMessage(String message) {
            this.loggedMessage = message;
        }

        public void appendLoggedMessage(String message) {
            this.loggedMessage = this.loggedMessage + message;
        }

        public String getLoggedMessage() {
            return this.loggedMessage;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public long getRecordNumber() {
            return this.recordNumber;
        }

        public void setRecordNumber(long recordNumber) {
            this.recordNumber = recordNumber;
        }

        public String toString() {
            return "" + this.getRecordNumber();
        }
    }
}

