/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@Service(name="set-log-levels")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="set.log.levels")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-log-levels", description="set-log-levels")})
public class SetLogLevel
implements AdminCommand {
    @Param(name="name_value", primary=true, separator=58)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    Domain domain;
    String[] validLevels = new String[]{"ALL", "OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SetLogLevel.class);

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean isCluster = false;
        boolean isDas = false;
        boolean isInstance = false;
        StringBuffer successMsg = new StringBuffer();
        boolean success = false;
        boolean invalidLogLevels = false;
        boolean isConfig = false;
        String targetConfigName = "";
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            for (Object key : this.properties.keySet()) {
                String logger_name = (String)key;
                String level = (String)this.properties.get(logger_name);
                boolean vlvl = false;
                for (String s : this.validLevels) {
                    if (!s.equals(level)) continue;
                    m.put(logger_name + ".level", level);
                    vlvl = true;
                    successMsg.append(localStrings.getLocalString("set.log.level.properties", "{0} package set with log level {1}.\n", logger_name, level));
                }
                if (vlvl) continue;
                report.setMessage(localStrings.getLocalString("set.log.level.invalid", "Invalid logger level found {0}.  Valid levels are: SEVERE, WARNING, INFO, FINE, FINER, FINEST", level));
                invalidLogLevels = true;
                break;
            }
            if (invalidLogLevels) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                Server targetServer;
                Config config = this.domain.getConfigNamed(this.target);
                if (config != null) {
                    targetConfigName = this.target;
                    isConfig = true;
                    targetServer = this.domain.getServerNamed("server");
                    if (targetServer != null && targetServer.getConfigRef().equals(this.target)) {
                        isDas = true;
                    }
                    targetServer = null;
                } else {
                    Cluster clusterForInstance;
                    targetServer = this.domain.getServerNamed(this.target);
                    if (targetServer != null && targetServer.isDas()) {
                        isDas = true;
                    } else {
                        Cluster cluster = this.domain.getClusterNamed(this.target);
                        if (cluster != null) {
                            isCluster = true;
                            targetConfigName = cluster.getConfigRef();
                        } else if (targetServer != null) {
                            isInstance = true;
                            targetConfigName = targetServer.getConfigRef();
                        }
                    }
                    if (isInstance && (clusterForInstance = targetServer.getCluster()) != null) {
                        targetConfigName = clusterForInstance.getConfigRef();
                    }
                }
                if (isCluster || isInstance) {
                    this.loggingConfig.updateLoggingProperties(m, targetConfigName);
                    success = true;
                } else if (isDas) {
                    this.loggingConfig.updateLoggingProperties(m);
                    success = true;
                } else if (isConfig) {
                    this.loggingConfig.updateLoggingProperties(m, targetConfigName);
                    success = true;
                } else {
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", this.target);
                    report.setMessage(msg);
                    return;
                }
                if (success) {
                    successMsg.append(localStrings.getLocalString("set.log.level.success", "These logging levels are set for {0}.", this.target));
                    report.setMessage(successMsg.toString());
                    report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                }
            }
        }
        catch (IOException e) {
            report.setMessage(localStrings.getLocalString("set.log.level.failed", "Could not set logger levels for {0}.", this.target));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

