/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="_load-default-log-levels")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="load.default.log.levels")
public class LoadDefaultLogLevels
implements AdminCommand {
    @Inject
    LoggingConfigImpl loggingConfig;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LoadDefaultLogLevels.class);

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String target = "default template";
        try {
            HashMap props = null;
            props = (HashMap)this.loggingConfig.getDefaultLoggingProperties();
            ArrayList keys = new ArrayList();
            keys.addAll(props.keySet());
            Collections.sort(keys);
            Iterator it2 = keys.iterator();
            HashMap logLevelMap = new HashMap();
            ArrayList<String> loggerList = new ArrayList<String>();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                if (!name.endsWith(".level") || name.equals(".level")) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                String n = name.substring(0, name.lastIndexOf(".level"));
                part.setMessage(n + "\t" + "<" + (String)props.get(name) + ">");
                logLevelMap.put(n, props.get(name));
                loggerList.add(n);
            }
            Properties restData = new Properties();
            restData.put("logLevels", logLevelMap);
            restData.put("loggers", loggerList);
            report.setExtraProperties(restData);
        }
        catch (IOException ex) {
            report.setMessage(localStrings.getLocalString("get.log.level.failed", "Could not get logging levels for {0}.", "default template"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

