/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-log-levels")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.log.levels")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-log-levels", description="list-log-levels")})
public class ListLoggerLevels
implements AdminCommand {
    @Inject
    LoggingConfigImpl loggingConfig;
    @Param(primary=true, optional=true, defaultValue="server")
    String target;
    @Inject
    Domain domain;
    @Inject
    Servers servers;
    @Inject
    Clusters clusters;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListLoggerLevels.class);

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean isCluster = false;
        boolean isDas = false;
        boolean isInstance = false;
        boolean isConfig = false;
        String targetConfigName = "";
        try {
            Server targetServer;
            HashMap props = null;
            Config config = this.domain.getConfigNamed(this.target);
            if (config != null) {
                targetConfigName = this.target;
                isConfig = true;
                targetServer = this.domain.getServerNamed("server");
                if (targetServer.getConfigRef().equals(this.target)) {
                    isDas = true;
                }
            } else {
                Cluster clusterForInstance;
                targetServer = this.domain.getServerNamed(this.target);
                if (targetServer != null && targetServer.isDas()) {
                    isDas = true;
                } else {
                    Cluster cluster = this.domain.getClusterNamed(this.target);
                    if (cluster != null) {
                        isCluster = true;
                        targetConfigName = cluster.getConfigRef();
                    } else if (targetServer != null) {
                        isInstance = true;
                        targetConfigName = targetServer.getConfigRef();
                    }
                }
                if (isInstance && (clusterForInstance = targetServer.getCluster()) != null) {
                    targetConfigName = clusterForInstance.getConfigRef();
                }
            }
            if (isCluster || isInstance) {
                props = (HashMap)this.loggingConfig.getLoggingProperties(targetConfigName);
            } else if (isDas) {
                props = (HashMap)this.loggingConfig.getLoggingProperties();
            } else if (isConfig) {
                props = (HashMap)this.loggingConfig.getLoggingProperties(targetConfigName);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", this.target);
                report.setMessage(msg);
                return;
            }
            ArrayList keys = new ArrayList();
            keys.addAll(props.keySet());
            Collections.sort(keys);
            Iterator it2 = keys.iterator();
            HashMap logLevelMap = new HashMap();
            ArrayList<String> loggerList = new ArrayList<String>();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                if (!name.endsWith(".level") || name.equals(".level")) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                String n = name.substring(0, name.lastIndexOf(".level"));
                part.setMessage(n + "\t" + "<" + (String)props.get(name) + ">");
                logLevelMap.put(n, props.get(name));
                loggerList.add(n);
            }
            Properties restData = new Properties();
            restData.put("logLevels", logLevelMap);
            restData.put("loggers", loggerList);
            report.setExtraProperties(restData);
        }
        catch (IOException ex) {
            report.setMessage(localStrings.getLocalString("get.log.level.failed", "Could not get logging levels for {0}.", this.target));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

