/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.common.util.logging.LoggingOutputStream;
import com.sun.common.util.logging.LoggingXMLNames;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.ODLLogFormatter;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.EarlyLogger;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=1)
public class LogManagerService
implements PostConstruct,
PreDestroy,
org.glassfish.internal.api.LogManager {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ServiceLocator habitat;
    @Inject
    @Optional
    Agent agent = null;
    @Inject
    FileMonitoring fileMonitoring;
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    UnprocessedConfigListener ucl;
    @Inject
    Domain domain;
    final Map<String, Handler> gfHandlers = new HashMap<String, Handler>();
    private static final Logger LOGGER = LogFacade.LOGGING_LOGGER;
    PrintStream oStdOutBackup = System.out;
    PrintStream oStdErrBackup = System.err;
    String serverLogFileDetail = "";
    String handlerDetail = "";
    String consoleHandlerFormatterDetail = "";
    String gffileHandlerFormatterDetail = "";
    String rotationOnTimeLimitInMinutesDetail = "";
    String flushFrequencyDetail = "";
    String filterHandlerDetails = "";
    String logToConsoleDetail = "";
    String rotationInTimeLimitInBytesDetail = "";
    String useSystemLoggingDetail = "";
    String fileHandlerCountDetail = "";
    String retainErrorsStaticticsDetail = "";
    String log4jVersionDetail = "";
    String maxHistoryFilesDetail = "";
    String rotationOnDateChangeDetail = "";
    String fileHandlerPatternDetail = "";
    String fileHandlerFormatterDetail = "";
    String logFormatDateFormatDetail = "";
    private final String SERVER_LOG_FILE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.file";
    private final String HANDLER_PROPERTY = "handlers";
    private final String CONSOLEHANDLER_FORMATTER_PROPERTY = "java.util.logging.ConsoleHandler.formatter";
    private final String GFFILEHANDLER_FORMATTER_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.formatter";
    private final String ROTATIONTIMELIMITINMINUTES_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes";
    private final String FLUSHFREQUENCY_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.flushFrequency";
    private final String FILEHANDLER_LIMIT_PROPERTY = "java.util.logging.FileHandler.limit";
    private final String LOGTOCONSOLE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.logtoConsole";
    private final String ROTATIONLIMITINBYTES_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes";
    private final String USESYSTEMLOGGING_PROPERTY = "com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging";
    private final String FILEHANDLER_COUNT_PROPERTY = "java.util.logging.FileHandler.count";
    private final String RETAINERRORSSTATICTICS_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.retainErrorsStasticsForHours";
    private final String LOG4J_VERSION_PROPERTY = "log4j.logger.org.hibernate.validator.util.Version";
    private final String MAXHISTORY_FILES_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.maxHistoryFiles";
    private final String ROTATIONONDATECHANGE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.rotationOnDateChange";
    private final String FILEHANDLER_PATTERN_PROPERTY = "java.util.logging.FileHandler.pattern";
    private final String FILEHANDLER_FORMATTER_PROPERTY = "java.util.logging.FileHandler.formatter";
    private final String LOGFORMAT_DATEFORMAT_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.logFormatDateFormat";
    static final String EXCLUDE_FIELDS_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.excludeFields";
    static final String MULTI_LINE_MODE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.multiLineMode";
    private String RECORD_BEGIN_MARKER = "[#|";
    private String RECORD_END_MARKER = "|#]";
    private String RECORD_FIELD_SEPARATOR = "|";
    private String RECORD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    String recordBeginMarker;
    String recordEndMarker;
    String recordFieldSeparator;
    String recordDateFormat;
    Vector<Logger> loggerReference = new Vector();
    private String excludeFields;
    private boolean multiLineMode = false;

    @Override
    public Map<String, String> getLoggingProperties() throws IOException {
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        Map<String, String> props = null;
        props = targetServer != null ? (targetServer.isDas() ? this.loggingConfig.getLoggingProperties() : (targetServer.getCluster() != null ? this.loggingConfig.getLoggingProperties(targetServer.getCluster().getConfigRef()) : (targetServer.isInstance() ? this.loggingConfig.getLoggingProperties(targetServer.getConfigRef()) : this.loggingConfig.getLoggingProperties()))) : this.loggingConfig.getLoggingProperties();
        return props;
    }

    @Override
    public File getLoggingFile() throws IOException {
        File file = null;
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        if (targetServer != null) {
            if (targetServer.isDas()) {
                file = new File(this.env.getConfigDirPath(), "logging.properties");
            } else if (targetServer.getCluster() != null) {
                String pathForLogging = this.env.getConfigDirPath() + File.separator + targetServer.getCluster().getConfigRef();
                File dirForLogging = new File(pathForLogging);
                file = new File(dirForLogging, "logging.properties");
                if (!file.exists()) {
                    this.loggingConfig.copyLoggingPropertiesFile(dirForLogging);
                    file = new File(dirForLogging, "logging.properties");
                }
            } else if (targetServer.isInstance()) {
                String pathForLogging = this.env.getConfigDirPath() + File.separator + targetServer.getConfigRef();
                File dirForLogging = new File(pathForLogging);
                file = new File(dirForLogging, "logging.properties");
                if (!file.exists()) {
                    this.loggingConfig.copyLoggingPropertiesFile(dirForLogging);
                    file = new File(dirForLogging, "logging.properties");
                }
            } else {
                file = new File(this.env.getConfigDirPath(), "logging.properties");
            }
        } else {
            file = new File(this.env.getConfigDirPath(), "logging.properties");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void postConstruct() {
        List<EarlyLogger.LevelAndMessage> catchUp;
        LoggingOutputStream los;
        File logging;
        block34: {
            Object formatter;
            Class<Object> formatterClass;
            if (System.getProperty("java.util.logging.config.file") != null) {
                System.out.println("\n\n\n#!## LogManagerService.postConstruct : java.util.logging.config.file=" + System.getProperty("java.util.logging.config.file"));
                return;
            }
            LogManager logMgr = LogManager.getLogManager();
            logging = null;
            try {
                logging = this.getLoggingFile();
                System.setProperty("java.util.logging.config.file", logging.getAbsolutePath());
                String rootFolder = this.env.getProps().get("com.sun.aas.installRoot");
                String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
                File src = new File(templateDir, "logging.properties");
                File dest = new File(this.env.getConfigDirPath(), "logging.properties");
                System.out.println("\n\n\n#!## LogManagerService.postConstruct : rootFolder=" + rootFolder);
                System.out.println("#!## LogManagerService.postConstruct : templateDir=" + templateDir);
                System.out.println("#!## LogManagerService.postConstruct : src=" + src);
                System.out.println("#!## LogManagerService.postConstruct : dest=" + dest);
                if (!logging.exists()) {
                    LOGGER.log(Level.FINE, logging.getAbsolutePath() + " not found, creating new file from template.");
                    FileUtils.copy(src, dest);
                    logging = new File(this.env.getConfigDirPath(), "logging.properties");
                }
                logMgr.readConfiguration();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00001", e);
            }
            AgentFormatterDelegate agentDelegate = null;
            if (this.agent != null) {
                agentDelegate = new AgentFormatterDelegate(this.agent);
            }
            String formatterClassname = null;
            try {
                Map<String, String> props = this.getLoggingProperties();
                this.consoleHandlerFormatterDetail = formatterClassname = props.get("java.util.logging.ConsoleHandler.formatter");
                formatterClass = LogManagerService.class.getClassLoader().loadClass(formatterClassname);
                this.excludeFields = props.get(EXCLUDE_FIELDS_PROPERTY);
                this.multiLineMode = Boolean.parseBoolean(props.get(MULTI_LINE_MODE_PROPERTY));
                if (formatterClass.getName().equals("com.sun.enterprise.server.logging.UniformLogFormatter")) {
                    formatter = (UniformLogFormatter)formatterClass.newInstance();
                    String cname = "com.sun.enterprise.server.logging.GFFileHandler";
                    this.recordBeginMarker = props.get(cname + ".logFormatBeginMarker");
                    if (this.recordBeginMarker == null || "".equals(this.recordBeginMarker)) {
                        LOGGER.log(Level.FINE, "Record begin marker is not a proper value so using default.");
                        this.recordBeginMarker = this.RECORD_BEGIN_MARKER;
                    }
                    this.recordEndMarker = props.get(cname + ".logFormatEndMarker");
                    if (this.recordEndMarker == null || "".equals(this.recordEndMarker)) {
                        LOGGER.log(Level.FINE, "Record end marker is not a proper value so using default.");
                        this.recordEndMarker = this.RECORD_END_MARKER;
                    }
                    this.recordFieldSeparator = props.get(cname + ".logFormatFieldSeparator");
                    if (this.recordFieldSeparator == null || "".equals(this.recordFieldSeparator) || this.recordFieldSeparator.length() > 1) {
                        LOGGER.log(Level.FINE, "Log Format field separator is not a proper value so using default.");
                        this.recordFieldSeparator = this.RECORD_FIELD_SEPARATOR;
                    }
                    this.recordDateFormat = props.get(cname + ".logFormatDateFormat");
                    if (this.recordDateFormat != null && !"".equals(this.recordDateFormat)) {
                        SimpleDateFormat sdf = new SimpleDateFormat(this.recordDateFormat);
                        try {
                            sdf.format(new Date());
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINE, "Date Format specified is wrong so using default.");
                            this.recordDateFormat = this.RECORD_DATE_FORMAT;
                        }
                    } else {
                        LOGGER.log(Level.FINE, "Date Format specified is wrong so using default.");
                        this.recordDateFormat = this.RECORD_DATE_FORMAT;
                    }
                    ((UniformLogFormatter)formatter).setRecordBeginMarker(this.recordBeginMarker);
                    ((UniformLogFormatter)formatter).setRecordEndMarker(this.recordEndMarker);
                    ((UniformLogFormatter)formatter).setRecordDateFormat(this.recordDateFormat);
                    ((UniformLogFormatter)formatter).setRecordFieldSeparator(this.recordFieldSeparator);
                    ((UniformLogFormatter)formatter).setExcludeFields(this.excludeFields);
                    ((UniformLogFormatter)formatter).setMultiLineMode(this.multiLineMode);
                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                        handler.setFormatter((Formatter)formatter);
                    }
                } else if (formatterClass.getName().equals("com.sun.enterprise.server.logging.ODLLogFormatter")) {
                    formatter = (ODLLogFormatter)formatterClass.newInstance();
                    ((ODLLogFormatter)formatter).setExcludeFields(this.excludeFields);
                    ((ODLLogFormatter)formatter).setMultiLineMode(this.multiLineMode);
                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                        handler.setFormatter((Formatter)formatter);
                    }
                }
                this.serverLogFileDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.file");
                this.handlerDetail = props.get("handlers");
                this.consoleHandlerFormatterDetail = props.get("java.util.logging.ConsoleHandler.formatter");
                this.gffileHandlerFormatterDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.formatter");
                this.rotationOnTimeLimitInMinutesDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes");
                this.flushFrequencyDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.flushFrequency");
                this.filterHandlerDetails = props.get("java.util.logging.FileHandler.limit");
                this.logToConsoleDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.logtoConsole");
                this.rotationInTimeLimitInBytesDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes");
                this.useSystemLoggingDetail = props.get("com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging");
                this.fileHandlerCountDetail = props.get("java.util.logging.FileHandler.count");
                this.retainErrorsStaticticsDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.retainErrorsStasticsForHours");
                this.log4jVersionDetail = props.get("log4j.logger.org.hibernate.validator.util.Version");
                this.maxHistoryFilesDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.maxHistoryFiles");
                this.rotationOnDateChangeDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.rotationOnDateChange");
                this.fileHandlerPatternDetail = props.get("java.util.logging.FileHandler.pattern");
                this.fileHandlerFormatterDetail = props.get("java.util.logging.FileHandler.formatter");
                this.logFormatDateFormatDetail = props.get("com.sun.enterprise.server.logging.GFFileHandler.logFormatDateFormat");
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00002", e);
            }
            List<Handler> handlers = this.habitat.getAllServices(Handler.class, new Annotation[0]);
            if (handlers != null && handlers.size() > 0) {
                formatterClass = Logger.class;
                // MONITORENTER : java.util.logging.Logger.class
                formatter = logMgr;
                // MONITORENTER : formatter
                Enumeration<String> loggerNames = logMgr.getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    String loggerName = loggerNames.nextElement();
                    logMgr.getLogger(loggerName);
                    for (Handler handler : LOGGER.getHandlers()) {
                        if (!(handler.getFormatter() instanceof UniformLogFormatter)) continue;
                        ((UniformLogFormatter)handler.getFormatter()).setDelegate(agentDelegate);
                    }
                }
                for (Handler handler : handlers) {
                    this.addHandler(handler);
                }
                // MONITOREXIT : formatter
                // MONITOREXIT : formatterClass
            }
            try {
                Map<String, String> map = this.getLoggingProperties();
                String filterClassName = map.get(LoggingXMLNames.xmltoPropsMap.get("log-filter"));
                if (filterClassName == null) break block34;
                Filter filterClass = this.habitat.getService(Filter.class, filterClassName, new Annotation[0]);
                Logger rootLogger = Logger.global.getParent();
                if (rootLogger != null) {
                    rootLogger.setFilter(filterClass);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        Logger _ologger = LogFacade.STDOUT_LOGGER;
        LoggingOutputStream loggingOutputStream = los = new LoggingOutputStream(_ologger, Level.INFO);
        loggingOutputStream.getClass();
        LoggingOutputStream.LoggingPrintStream pout = loggingOutputStream.new LoggingOutputStream.LoggingPrintStream(los);
        System.setOut(pout);
        Logger _elogger = LogFacade.STDERR_LOGGER;
        LoggingOutputStream loggingOutputStream2 = los = new LoggingOutputStream(_elogger, Level.SEVERE);
        loggingOutputStream2.getClass();
        LoggingOutputStream.LoggingPrintStream perr = loggingOutputStream2.new LoggingOutputStream.LoggingPrintStream(los);
        System.setErr(perr);
        if (logging != null) {
            this.fileMonitoring.monitors(logging, new FileMonitoring.FileChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void changed(File changedFile) {
                    Map<String, Handler> map = LogManagerService.this.gfHandlers;
                    synchronized (map) {
                        try {
                            Map<String, String> props = LogManagerService.this.getLoggingProperties();
                            LogManagerService.this.loggerReference = new Vector();
                            if (props == null) {
                                return;
                            }
                            for (Map.Entry<String, String> entry : props.entrySet()) {
                                String oldVal;
                                String a = entry.getKey();
                                String val = entry.getValue();
                                if (a.endsWith(".level")) {
                                    String n = a.substring(0, a.lastIndexOf(".level"));
                                    Level l = Level.parse(val);
                                    if (LogManagerService.this.gfHandlers.containsKey(n)) {
                                        Handler h = LogManagerService.this.gfHandlers.get(n);
                                        h.setLevel(l);
                                        continue;
                                    }
                                    if (n.equals("java.util.logging.ConsoleHandler")) {
                                        Logger logger2 = Logger.global.getParent();
                                        Handler[] h = logger2.getHandlers();
                                        for (int i = 0; i < h.length; ++i) {
                                            String name = h[i].toString();
                                            if (!name.contains("java.util.logging.ConsoleHandler")) continue;
                                            h[i].setLevel(l);
                                        }
                                        continue;
                                    }
                                    Logger appLogger = Logger.getLogger(n);
                                    appLogger.setLevel(l);
                                    LogManagerService.this.loggerReference.add(appLogger);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.file")) {
                                    if (val.equals(LogManagerService.this.serverLogFileDetail)) continue;
                                    PropertyChangeEvent pce = new PropertyChangeEvent(this, a, LogManagerService.this.serverLogFileDetail, val);
                                    UnprocessedChangeEvents ucel = new UnprocessedChangeEvents(new UnprocessedChangeEvent(pce, "server log filename changed."));
                                    ArrayList<UnprocessedChangeEvents> b = new ArrayList<UnprocessedChangeEvents>();
                                    b.add(ucel);
                                    LogManagerService.this.ucl.unprocessedTransactedEvents(b);
                                    continue;
                                }
                                if (a.equals("handlers")) {
                                    if (val.equals(LogManagerService.this.handlerDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("handlers", LogManagerService.this.handlerDetail, props);
                                    continue;
                                }
                                if (a.equals("java.util.logging.ConsoleHandler.formatter")) {
                                    if (val.equals(LogManagerService.this.consoleHandlerFormatterDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("java.util.logging.ConsoleHandler.formatter", LogManagerService.this.consoleHandlerFormatterDetail, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.formatter")) {
                                    if (val.equals(LogManagerService.this.gffileHandlerFormatterDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.GFFileHandler.formatter", LogManagerService.this.gffileHandlerFormatterDetail, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes")) {
                                    if (val.equals(LogManagerService.this.rotationOnTimeLimitInMinutesDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes", LogManagerService.this.rotationOnTimeLimitInMinutesDetail, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.flushFrequency")) {
                                    if (val.equals(LogManagerService.this.flushFrequencyDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.GFFileHandler.flushFrequency", LogManagerService.this.flushFrequencyDetail, props);
                                    continue;
                                }
                                if (a.equals("java.util.logging.FileHandler.limit")) {
                                    if (val.equals(LogManagerService.this.filterHandlerDetails)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("java.util.logging.FileHandler.limit", LogManagerService.this.filterHandlerDetails, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.logtoConsole")) {
                                    if (val.equals(LogManagerService.this.logToConsoleDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.GFFileHandler.logtoConsole", LogManagerService.this.logToConsoleDetail, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes")) {
                                    if (val.equals(LogManagerService.this.rotationInTimeLimitInBytesDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes", LogManagerService.this.rotationInTimeLimitInBytesDetail, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging")) {
                                    if (val.equals(LogManagerService.this.useSystemLoggingDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging", LogManagerService.this.useSystemLoggingDetail, props);
                                    continue;
                                }
                                if (a.equals("java.util.logging.FileHandler.count")) {
                                    if (val.equals(LogManagerService.this.fileHandlerCountDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("java.util.logging.FileHandler.count", LogManagerService.this.fileHandlerCountDetail, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.retainErrorsStasticsForHours")) {
                                    if (val.equals(LogManagerService.this.retainErrorsStaticticsDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.GFFileHandler.retainErrorsStasticsForHours", LogManagerService.this.retainErrorsStaticticsDetail, props);
                                    continue;
                                }
                                if (a.equals("log4j.logger.org.hibernate.validator.util.Version")) {
                                    if (val.equals(LogManagerService.this.log4jVersionDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("log4j.logger.org.hibernate.validator.util.Version", LogManagerService.this.log4jVersionDetail, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.maxHistoryFiles")) {
                                    if (val.equals(LogManagerService.this.maxHistoryFilesDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.GFFileHandler.maxHistoryFiles", LogManagerService.this.maxHistoryFilesDetail, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.rotationOnDateChange")) {
                                    if (val.equals(LogManagerService.this.rotationOnDateChangeDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.GFFileHandler.rotationOnDateChange", LogManagerService.this.rotationOnDateChangeDetail, props);
                                    continue;
                                }
                                if (a.equals("java.util.logging.FileHandler.pattern")) {
                                    if (val.equals(LogManagerService.this.fileHandlerPatternDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("java.util.logging.FileHandler.pattern", LogManagerService.this.fileHandlerPatternDetail, props);
                                    continue;
                                }
                                if (a.equals("java.util.logging.FileHandler.formatter")) {
                                    if (val.equals(LogManagerService.this.fileHandlerFormatterDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("java.util.logging.FileHandler.formatter", LogManagerService.this.fileHandlerFormatterDetail, props);
                                    continue;
                                }
                                if (a.equals("com.sun.enterprise.server.logging.GFFileHandler.logFormatDateFormat")) {
                                    if (val.equals(LogManagerService.this.logFormatDateFormatDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent("com.sun.enterprise.server.logging.GFFileHandler.logFormatDateFormat", LogManagerService.this.logFormatDateFormatDetail, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.EXCLUDE_FIELDS_PROPERTY)) {
                                    val = val == null ? "" : val;
                                    LogManagerService.this.excludeFields = LogManagerService.this.excludeFields == null ? "" : LogManagerService.this.excludeFields;
                                    if (val.equals(LogManagerService.this.excludeFields)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.EXCLUDE_FIELDS_PROPERTY, LogManagerService.this.excludeFields, props);
                                    continue;
                                }
                                if (!a.equals(LogManagerService.MULTI_LINE_MODE_PROPERTY) || val.equalsIgnoreCase(oldVal = Boolean.toString(LogManagerService.this.multiLineMode))) continue;
                                LogManagerService.this.generateAttributeChangeEvent(LogManagerService.MULTI_LINE_MODE_PROPERTY, oldVal, props);
                            }
                            LOGGER.log(Level.INFO, "NCLS-LOGGING-00003");
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00002", e);
                        }
                    }
                }

                @Override
                public void deleted(File deletedFile) {
                    LOGGER.log(Level.WARNING, "NCLS-LOGGING-00004", deletedFile.getAbsolutePath());
                }
            });
        }
        if (!(catchUp = EarlyLogger.getEarlyMessages()).isEmpty()) {
            for (EarlyLogger.LevelAndMessage levelAndMessage : catchUp) {
                LOGGER.log(levelAndMessage.getLevel(), levelAndMessage.getMessage());
            }
            catchUp.clear();
        }
        ArrayBlockingQueue<LogRecord> catchEarlyMessage = EarlyLogHandler.earlyMessages;
        while (!catchEarlyMessage.isEmpty()) {
            LogRecord logRecord = catchEarlyMessage.poll();
            if (logRecord == null) continue;
            LOGGER.log(logRecord);
        }
    }

    public void generateAttributeChangeEvent(String property, String propertyDetail, Map props) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, property, propertyDetail, props.get(property));
        UnprocessedChangeEvents ucel = new UnprocessedChangeEvents(new UnprocessedChangeEvent(pce, "server log file attribute " + property + " changed."));
        ArrayList<UnprocessedChangeEvents> b = new ArrayList<UnprocessedChangeEvents>();
        b.add(ucel);
        this.ucl.unprocessedTransactedEvents(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(Handler handler) {
        Logger rootLogger = Logger.global.getParent();
        if (rootLogger != null) {
            Map<String, Handler> map = this.gfHandlers;
            synchronized (map) {
                rootLogger.addHandler(handler);
                String handlerName = handler.toString();
                this.gfHandlers.put(handlerName.substring(0, handlerName.indexOf("@")), handler);
            }
        }
    }

    @Override
    public void preDestroy() {
        try {
            for (ServiceHandle<?> i : this.habitat.getAllServiceHandles(BuilderHelper.createContractFilter(Handler.class.getName()))) {
                i.destroy();
            }
            System.setOut(this.oStdOutBackup);
            System.setErr(this.oStdErrBackup);
            System.out.println("Completed shutdown of Log manager service");
        }
        catch (MultiException e) {
            e.printStackTrace();
        }
    }
}

