/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web;

import com.sun.enterprise.security.web.SingleSignOnMBean;
import com.sun.enterprise.web.WebContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;

public class GlassFishSingleSignOn
extends SingleSignOn
implements Runnable,
SingleSignOnMBean {
    private static final Logger logger = WebContainer.logger;
    private static final String SESSION_DESTROYED = "AS-WEB-00219";
    private static final String REQUEST_PROCESSED = "AS-WEB-00220";
    private static final String PRINCIPAL_ALREADY_AUTHENTICATED = "AS-WEB-00221";
    private static final String CHECKING_SSO_COOKIE = "AS-WEB-00222";
    private static final String SSO_COOKIE_NOT_PRESENT = "AS-WEB-00223";
    private static final String NO_REALM_CONFIGURED = "AS-WEB-00224";
    private static final String APP_REALM = "AS-WEB-00225";
    private static final String CHECKING_CACHED_PRINCIPAL = "AS-WEB-00226";
    private static final String FOUND_CACHED_PRINCIPAL = "AS-WEB-00227";
    private static final String IGNORING_SSO = "AS-WEB-00228";
    private static final String NO_CACHED_PRINCIPAL_FOUND = "AS-WEB-00229";
    private static final String DEREGISTER_SSO = "AS-WEB-00230";
    private static final String SSO_EXPIRATION_STARTED = "AS-WEB-00231";
    private static final String SSO_CACHE_EXPIRE = "AS-WEB-00232";
    private static final String SSO_EXPRIRATION_REMOVING_ENTRY = "AS-WEB-00233";
    private static final String EXCEPTION_DURING_SSO_EXPIRATION = "AS-WEB-00234";
    private static final String REMOVE_SESSION_FROM_SSO = "AS-WEB-00235";
    private Thread thread = null;
    private boolean threadDone = false;
    private int ssoReapInterval = 60;
    private int ssoMaxInactive = 300;
    private AtomicInteger hitCount = new AtomicInteger(0);
    private AtomicInteger missCount = new AtomicInteger(0);

    public int getReapInterval() {
        return this.ssoReapInterval;
    }

    public void setReapInterval(int t) {
        this.ssoReapInterval = t;
    }

    public int getMaxInactive() {
        return this.ssoMaxInactive;
    }

    public void setMaxInactive(int t) {
        this.ssoMaxInactive = t;
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        this.threadStart();
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.threadStop();
        super.stop();
    }

    @Override
    public void sessionEvent(SessionEvent event) {
        String ssoId;
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, SESSION_DESTROYED, session);
        }
        if ((ssoId = session.getSsoId()) == null) {
            return;
        }
        if (session.hasExpired()) {
            this.removeSession(ssoId, session);
        } else {
            this.deregister(ssoId);
        }
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        Cookie[] cookies;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        request.removeNote("org.apache.catalina.request.SSOVersion");
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, PRINCIPAL_ALREADY_AUTHENTICATED, hreq.getRequestURI());
        }
        if (hreq.getUserPrincipal() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, REQUEST_PROCESSED, hreq.getUserPrincipal().getName());
            }
            return 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, CHECKING_SSO_COOKIE);
        }
        if ((cookies = hreq.getCookies()) == null) {
            return 1;
        }
        Cookie cookie = null;
        Cookie versionCookie = null;
        for (Cookie c : cookies) {
            if ("JSESSIONIDSSO".equals(c.getName())) {
                cookie = c;
            } else if ("JSESSIONIDSSOVERSION".equals(c.getName())) {
                versionCookie = c;
            }
            if (cookie != null && versionCookie != null) break;
        }
        if (cookie == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, SSO_COOKIE_NOT_PRESENT);
            }
            return 1;
        }
        Realm realm = request.getContext().getRealm();
        if (realm == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, NO_REALM_CONFIGURED);
            }
            return 1;
        }
        String realmName = realm.getRealmName();
        if (realmName == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, NO_REALM_CONFIGURED);
            }
            return 1;
        }
        if (this.debug >= 1 && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, APP_REALM);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, CHECKING_CACHED_PRINCIPAL);
        }
        long version = 0L;
        if (this.isVersioningSupported() && versionCookie != null) {
            version = Long.parseLong(versionCookie.getValue());
        }
        if ((entry = this.lookup(cookie.getValue(), version)) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, FOUND_CACHED_PRINCIPAL, new Object[]{entry.getPrincipal().getName(), entry.getAuthType(), entry.getRealmName()});
            }
            if (entry.getRealmName().equals(realmName)) {
                request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
                ((HttpRequest)request).setAuthType(entry.getAuthType());
                ((HttpRequest)request).setUserPrincipal(entry.getPrincipal());
                entry.setLastAccessTime(System.currentTimeMillis());
                if (this.isVersioningSupported()) {
                    long ver = entry.incrementAndGetVersion();
                    request.setNote("org.apache.catalina.request.SSOVersion", ver);
                }
                this.hitCount.incrementAndGet();
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, IGNORING_SSO, realmName);
                }
                this.missCount.incrementAndGet();
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, NO_CACHED_PRINCIPAL_FOUND);
            }
            cookie.setMaxAge(0);
            hres.addCookie(cookie);
            this.missCount.incrementAndGet();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, DEREGISTER_SSO);
        }
        SingleSignOnEntry sso = null;
        Map map = this.cache;
        synchronized (map) {
            sso = (SingleSignOnEntry)this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        sso.expireSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        if (this.ssoMaxInactive < 0) {
            return;
        }
        long tooOld = System.currentTimeMillis() - (long)this.ssoMaxInactive * 1000L;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, SSO_EXPIRATION_STARTED, this.cache.size());
        }
        ArrayList<String> removals = new ArrayList<String>(this.cache.size() / 2);
        try {
            Map map = this.cache;
            synchronized (map) {
                for (String key : this.cache.keySet()) {
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (!sso.isEmpty() || sso.getLastAccessTime() >= tooOld) continue;
                    removals.add(key);
                }
            }
            int removalCount = removals.size();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, SSO_CACHE_EXPIRE, removalCount);
            }
            for (int i = 0; i < removalCount; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, SSO_EXPRIRATION_REMOVING_ENTRY, removals.get(i));
                }
                this.deregister((String)removals.get(i));
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, EXCEPTION_DURING_SSO_EXPIRATION, e);
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.ssoReapInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "SingleSignOnExpiration";
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    @Override
    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }

    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, REMOVE_SESSION_FROM_SSO, new Object[]{session.toString(), ssoId});
        }
        if ((entry = this.lookup(ssoId)) == null) {
            return;
        }
        entry.removeSession(session);
        if (entry.isEmpty()) {
            this.deregister(ssoId);
        }
    }

    @Override
    public int getActiveSessionCount() {
        return this.cache.size();
    }

    @Override
    public int getHitCount() {
        return this.hitCount.intValue();
    }

    @Override
    public int getMissCount() {
        return this.missCount.intValue();
    }
}

