/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import sun.net.www.ParseUtil;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;

public class PolicyParser {
    public static final String REPLACE_NAME = "PolicyParser.REPLACE_NAME";
    private static final String EXTDIRS_PROPERTY = "java.ext.dirs";
    private static final String OLD_EXTDIRS_EXPANSION = "${java.ext.dirs}";
    static final String EXTDIRS_EXPANSION = "${{java.ext.dirs}}";
    private Vector grantEntries = new Vector();
    private static final Debug debug = Debug.getInstance("parser", "\t[Policy Parser]");
    private StreamTokenizer st;
    private int lookahead;
    private boolean expandProp = false;
    private String keyStoreUrlString = null;
    private String keyStoreType = null;
    private String keyStoreProvider = null;
    private String storePassURL = null;

    private String expand(String value) throws PropertyExpander.ExpandException {
        return this.expand(value, false);
    }

    private String expand(String value, boolean encodeURL) throws PropertyExpander.ExpandException {
        if (!this.expandProp) {
            return value;
        }
        return PropertyExpander.expand(value, encodeURL);
    }

    public PolicyParser() {
    }

    public PolicyParser(boolean expandProp) {
        this();
        this.expandProp = expandProp;
    }

    public void read(Reader policy) throws ParsingException, IOException {
        if (!(policy instanceof BufferedReader)) {
            policy = new BufferedReader(policy);
        }
        this.st = new StreamTokenizer(policy);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(46, 46);
        this.st.wordChars(48, 57);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(160, 255);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(47);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.ordinaryChar(47);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.lookahead = this.st.nextToken();
        while (this.lookahead != -1) {
            if (this.peek("grant")) {
                GrantEntry ge = this.parseGrantEntry();
                if (ge != null) {
                    this.add(ge);
                }
            } else if (this.peek("keystore") && this.keyStoreUrlString == null) {
                this.parseKeyStoreEntry();
            } else if (this.peek("keystorePasswordURL") && this.storePassURL == null) {
                this.parseStorePassURL();
            }
            this.match(";");
        }
        if (this.keyStoreUrlString == null && this.storePassURL != null) {
            throw new ParsingException(ResourcesMgr.getString("keystorePasswordURL can not be specified without also specifying keystore"));
        }
    }

    public void add(GrantEntry ge) {
        this.grantEntries.addElement(ge);
    }

    public void replace(GrantEntry origGe, GrantEntry newGe) {
        this.grantEntries.setElementAt(newGe, this.grantEntries.indexOf(origGe));
    }

    public boolean remove(GrantEntry ge) {
        return this.grantEntries.removeElement(ge);
    }

    public String getKeyStoreUrl() {
        try {
            if (this.keyStoreUrlString != null && this.keyStoreUrlString.length() != 0) {
                return this.expand(this.keyStoreUrlString, true).replace(File.separatorChar, '/');
            }
        }
        catch (PropertyExpander.ExpandException peee) {
            if (debug != null) {
                debug.println(peee.toString());
            }
            return null;
        }
        return null;
    }

    public void setKeyStoreUrl(String url) {
        this.keyStoreUrlString = url;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type2) {
        this.keyStoreType = type2;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String provider) {
        this.keyStoreProvider = provider;
    }

    public String getStorePassURL() {
        try {
            if (this.storePassURL != null && this.storePassURL.length() != 0) {
                return this.expand(this.storePassURL, true).replace(File.separatorChar, '/');
            }
        }
        catch (PropertyExpander.ExpandException peee) {
            if (debug != null) {
                debug.println(peee.toString());
            }
            return null;
        }
        return null;
    }

    public void setStorePassURL(String storePassURL) {
        this.storePassURL = storePassURL;
    }

    public Enumeration grantElements() {
        return this.grantEntries.elements();
    }

    public void write(Writer policy) {
        PrintWriter out = new PrintWriter(new BufferedWriter(policy));
        Enumeration enum_ = this.grantElements();
        out.println("/* AUTOMATICALLY GENERATED ON " + new Date() + "*/");
        out.println("/* DO NOT EDIT */");
        out.println();
        if (this.keyStoreUrlString != null) {
            this.writeKeyStoreEntry(out);
        }
        if (this.storePassURL != null) {
            this.writeStorePassURL(out);
        }
        while (enum_.hasMoreElements()) {
            GrantEntry ge = (GrantEntry)enum_.nextElement();
            ge.write(out);
            out.println();
        }
        out.flush();
    }

    private void parseKeyStoreEntry() throws ParsingException, IOException {
        this.match("keystore");
        this.keyStoreUrlString = this.match("quoted string");
        if (!this.peek(",")) {
            return;
        }
        this.match(",");
        if (!this.peek("\"")) {
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected keystore type"));
        }
        this.keyStoreType = this.match("quoted string");
        if (!this.peek(",")) {
            return;
        }
        this.match(",");
        if (!this.peek("\"")) {
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected keystore provider"));
        }
        this.keyStoreProvider = this.match("quoted string");
    }

    private void parseStorePassURL() throws ParsingException, IOException {
        this.match("keyStorePasswordURL");
        this.storePassURL = this.match("quoted string");
    }

    private void writeKeyStoreEntry(PrintWriter out) {
        out.print("keystore \"");
        out.print(this.keyStoreUrlString);
        out.print('\"');
        if (this.keyStoreType != null && this.keyStoreType.length() > 0) {
            out.print(", \"" + this.keyStoreType + "\"");
        }
        if (this.keyStoreProvider != null && this.keyStoreProvider.length() > 0) {
            out.print(", \"" + this.keyStoreProvider + "\"");
        }
        out.println(";");
        out.println();
    }

    private void writeStorePassURL(PrintWriter out) {
        out.print("keystorePasswordURL \"");
        out.print(this.storePassURL);
        out.print('\"');
        out.println(";");
        out.println();
    }

    private GrantEntry parseGrantEntry() throws ParsingException, IOException {
        GrantEntry e = new GrantEntry();
        LinkedList<PrincipalEntry> principals = null;
        boolean ignoreEntry = false;
        this.match("grant");
        while (!this.peek("{")) {
            if (this.peekAndMatch("Codebase")) {
                if (e.codeBase != null) {
                    throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("multiple Codebase expressions"));
                }
                e.codeBase = this.match("quoted string");
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("SignedBy")) {
                if (e.signedBy != null) {
                    throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("multiple SignedBy expressions"));
                }
                e.signedBy = this.match("quoted string");
                StringTokenizer aliases = new StringTokenizer(e.signedBy, ",", true);
                int actr = 0;
                int cctr = 0;
                while (aliases.hasMoreTokens()) {
                    String alias = aliases.nextToken().trim();
                    if (alias.equals(",")) {
                        ++cctr;
                        continue;
                    }
                    if (alias.length() <= 0) continue;
                    ++actr;
                }
                if (actr <= cctr) {
                    throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("SignedBy has empty alias"));
                }
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("Principal")) {
                String principalName;
                String principalClass;
                if (principals == null) {
                    principals = new LinkedList<PrincipalEntry>();
                }
                if (this.peek("\"")) {
                    principalClass = REPLACE_NAME;
                    principalName = this.match("principal type");
                } else {
                    if (this.peek("*")) {
                        this.match("*");
                        principalClass = "WILDCARD_PRINCIPAL_CLASS";
                    } else {
                        principalClass = this.match("principal type");
                    }
                    if (this.peek("*")) {
                        this.match("*");
                        principalName = "WILDCARD_PRINCIPAL_NAME";
                    } else {
                        principalName = this.match("quoted string");
                    }
                    if (principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
                        if (debug != null) {
                            debug.println("disallowing principal that has WILDCARD class but no WILDCARD name");
                        }
                        throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("can not specify Principal with a wildcard class without a wildcard name"));
                    }
                }
                try {
                    principalName = this.expand(principalName);
                    if (principalClass.equals("javax.security.auth.x500.X500Principal") && !principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
                        X500Principal p = new X500Principal(new X500Principal(principalName).toString());
                        principalName = p.getName();
                    }
                    principals.add(new PrincipalEntry(principalClass, principalName));
                }
                catch (PropertyExpander.ExpandException peee) {
                    if (debug != null) {
                        debug.println("principal name expansion failed: " + principalName);
                    }
                    ignoreEntry = true;
                }
                this.peekAndMatch(",");
                continue;
            }
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected codeBase or SignedBy or Principal"));
        }
        if (principals != null) {
            e.principals = principals;
        }
        this.match("{");
        while (!this.peek("}")) {
            if (this.peek("Permission")) {
                try {
                    PermissionEntry pe = this.parsePermissionEntry();
                    e.add(pe);
                }
                catch (PropertyExpander.ExpandException peee) {
                    if (debug != null) {
                        debug.println(peee.toString());
                    }
                    this.skipEntry();
                }
                this.match(";");
                continue;
            }
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected permission entry"));
        }
        this.match("}");
        try {
            if (e.signedBy != null) {
                e.signedBy = this.expand(e.signedBy);
            }
            if (e.codeBase != null) {
                int es;
                if (e.codeBase.equals(OLD_EXTDIRS_EXPANSION)) {
                    e.codeBase = EXTDIRS_EXPANSION;
                }
                if ((es = e.codeBase.indexOf(EXTDIRS_EXPANSION)) < 0) {
                    e.codeBase = this.expand(e.codeBase, true).replace(File.separatorChar, '/');
                } else {
                    String[] extDirs = PolicyParser.parseExtDirs(e.codeBase, es);
                    if (extDirs != null && extDirs.length > 0) {
                        for (int i = 0; i < extDirs.length; ++i) {
                            GrantEntry newGe = (GrantEntry)e.clone();
                            newGe.codeBase = extDirs[i];
                            this.add(newGe);
                            if (debug == null) continue;
                            debug.println("creating policy entry for expanded java.ext.dirs path:\n\t\t" + extDirs[i]);
                        }
                    }
                    ignoreEntry = true;
                }
            }
        }
        catch (PropertyExpander.ExpandException peee) {
            if (debug != null) {
                debug.println(peee.toString());
            }
            return null;
        }
        return ignoreEntry ? null : e;
    }

    private PermissionEntry parsePermissionEntry() throws ParsingException, IOException, PropertyExpander.ExpandException {
        PermissionEntry e = new PermissionEntry();
        this.match("Permission");
        e.permission = this.match("permission type");
        if (this.peek("\"")) {
            e.name = this.expand(this.match("quoted string"));
        }
        if (!this.peek(",")) {
            return e;
        }
        this.match(",");
        if (this.peek("\"")) {
            e.action = this.expand(this.match("quoted string"));
            if (!this.peek(",")) {
                return e;
            }
            this.match(",");
        }
        if (this.peekAndMatch("SignedBy")) {
            e.signedBy = this.expand(this.match("quoted string"));
        }
        return e;
    }

    static String[] parseExtDirs(String codebase, int start) {
        String s = System.getProperty(EXTDIRS_PROPERTY);
        String globalPrefix = start > 0 ? codebase.substring(0, start) : "file:";
        int end = start + EXTDIRS_EXPANSION.length();
        String globalSuffix = end < codebase.length() ? codebase.substring(end) : (String)null;
        String[] dirs = null;
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, File.pathSeparator);
            int count = st.countTokens();
            dirs = new String[count];
            for (int i = 0; i < count; ++i) {
                File file = new File(st.nextToken());
                dirs[i] = ParseUtil.encodePath(file.getAbsolutePath());
                if (!dirs[i].startsWith("/")) {
                    dirs[i] = "/" + dirs[i];
                }
                String localSuffix = globalSuffix == null ? (dirs[i].endsWith("/") ? "*" : "/*") : globalSuffix;
                dirs[i] = globalPrefix + dirs[i] + localSuffix;
            }
        }
        return dirs;
    }

    private boolean peekAndMatch(String expect) throws ParsingException, IOException {
        if (this.peek(expect)) {
            this.match(expect);
            return true;
        }
        return false;
    }

    private boolean peek(String expect) {
        boolean found = false;
        switch (this.lookahead) {
            case -3: {
                if (!expect.equalsIgnoreCase(this.st.sval)) break;
                found = true;
                break;
            }
            case 44: {
                if (!expect.equalsIgnoreCase(",")) break;
                found = true;
                break;
            }
            case 123: {
                if (!expect.equalsIgnoreCase("{")) break;
                found = true;
                break;
            }
            case 125: {
                if (!expect.equalsIgnoreCase("}")) break;
                found = true;
                break;
            }
            case 34: {
                if (!expect.equalsIgnoreCase("\"")) break;
                found = true;
                break;
            }
            case 42: {
                if (!expect.equalsIgnoreCase("*")) break;
                found = true;
                break;
            }
        }
        return found;
    }

    private String match(String expect) throws ParsingException, IOException {
        String value = null;
        switch (this.lookahead) {
            case -2: {
                throw new ParsingException(this.st.lineno(), expect, ResourcesMgr.getString("number ") + String.valueOf(this.st.nval));
            }
            case -1: {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("expected [expect], read [end of file]"));
                Object[] source = new Object[]{expect};
                throw new ParsingException(form.format(source));
            }
            case -3: {
                if (expect.equalsIgnoreCase(this.st.sval)) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (expect.equalsIgnoreCase("permission type")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (expect.equalsIgnoreCase("principal type")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, this.st.sval);
            }
            case 34: {
                if (expect.equalsIgnoreCase("quoted string")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (expect.equalsIgnoreCase("permission type")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (expect.equalsIgnoreCase("principal type")) {
                    value = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, this.st.sval);
            }
            case 44: {
                if (expect.equalsIgnoreCase(",")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, ",");
            }
            case 123: {
                if (expect.equalsIgnoreCase("{")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, "{");
            }
            case 125: {
                if (expect.equalsIgnoreCase("}")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, "}");
            }
            case 59: {
                if (expect.equalsIgnoreCase(";")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, ";");
            }
            case 42: {
                if (expect.equalsIgnoreCase("*")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), expect, "*");
            }
            default: {
                throw new ParsingException(this.st.lineno(), expect, new String(new char[]{(char)this.lookahead}));
            }
        }
        return value;
    }

    private void skipEntry() throws ParsingException, IOException {
        while (this.lookahead != 59) {
            switch (this.lookahead) {
                case -2: {
                    throw new ParsingException(this.st.lineno(), ";", ResourcesMgr.getString("number ") + String.valueOf(this.st.nval));
                }
                case -1: {
                    throw new ParsingException(ResourcesMgr.getString("expected [;], read [end of file]"));
                }
            }
            this.lookahead = this.st.nextToken();
        }
    }

    public static void main(String[] arg) throws Exception {
        PolicyParser pp = new PolicyParser(true);
        pp.read(new FileReader(arg[0]));
        FileWriter fr = new FileWriter(arg[1]);
        pp.write(fr);
        fr.close();
    }

    public static class GrantEntry
    implements Cloneable {
        public String signedBy;
        public String codeBase;
        public LinkedList principals;
        public Vector permissionEntries;

        public GrantEntry() {
            this.principals = new LinkedList();
            this.permissionEntries = new Vector();
        }

        public GrantEntry(String signedBy, String codeBase) {
            this.codeBase = codeBase;
            this.signedBy = signedBy;
            this.principals = new LinkedList();
            this.permissionEntries = new Vector();
        }

        public void add(PermissionEntry pe) {
            this.permissionEntries.addElement(pe);
        }

        public boolean remove(PrincipalEntry pe) {
            return this.principals.remove(pe);
        }

        public boolean remove(PermissionEntry pe) {
            return this.permissionEntries.removeElement(pe);
        }

        public boolean contains(PrincipalEntry pe) {
            return this.principals.contains(pe);
        }

        public boolean contains(PermissionEntry pe) {
            return this.permissionEntries.contains(pe);
        }

        public Enumeration permissionElements() {
            return this.permissionEntries.elements();
        }

        public void write(PrintWriter out) {
            Object pe;
            out.print("grant");
            if (this.signedBy != null) {
                out.print(" signedBy \"");
                out.print(this.signedBy);
                out.print('\"');
                if (this.codeBase != null) {
                    out.print(", ");
                }
            }
            if (this.codeBase != null) {
                out.print(" codeBase \"");
                out.print(this.codeBase);
                out.print('\"');
                if (this.principals != null && this.principals.size() > 0) {
                    out.print(",\n");
                }
            }
            if (this.principals != null && this.principals.size() > 0) {
                ListIterator pli = this.principals.listIterator();
                while (pli.hasNext()) {
                    out.print("      ");
                    pe = (PrincipalEntry)pli.next();
                    ((PrincipalEntry)pe).write(out);
                    if (!pli.hasNext()) continue;
                    out.print(",\n");
                }
            }
            out.println(" {");
            Enumeration enum_ = this.permissionEntries.elements();
            while (enum_.hasMoreElements()) {
                pe = (PermissionEntry)enum_.nextElement();
                out.write("  ");
                ((PermissionEntry)pe).write(out);
            }
            out.println("};");
        }

        public Object clone() {
            block2: {
                try {
                    super.clone();
                }
                catch (CloneNotSupportedException e) {
                    if (debug == null) break block2;
                    debug.println(e.getMessage());
                }
            }
            GrantEntry ge = new GrantEntry();
            ge.codeBase = this.codeBase;
            ge.signedBy = this.signedBy;
            ge.principals = new LinkedList(this.principals);
            ge.permissionEntries = new Vector(this.permissionEntries);
            return ge;
        }
    }

    public static class ParsingException
    extends GeneralSecurityException {
        private static final long serialVersionUID = -4330692689482574072L;
        private String i18nMessage;

        public ParsingException(String msg) {
            super(msg);
            this.i18nMessage = msg;
        }

        public ParsingException(int line, String msg) {
            super("line " + line + ": " + msg);
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("line number: msg"));
            Object[] source = new Object[]{line, msg};
            this.i18nMessage = form.format(source);
        }

        public ParsingException(int line, String expect, String actual) {
            super("line " + line + ": expected [" + expect + "], found [" + actual + "]");
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("line number: expected [expect], found [actual]"));
            Object[] source = new Object[]{line, expect, actual};
            this.i18nMessage = form.format(source);
        }

        @Override
        public String getLocalizedMessage() {
            return this.i18nMessage;
        }
    }

    public static class PermissionEntry {
        public String permission;
        public String name;
        public String action;
        public String signedBy;

        public PermissionEntry() {
        }

        public PermissionEntry(String permission, String name, String action) {
            this.permission = permission;
            this.name = name;
            this.action = action;
        }

        public int hashCode() {
            int retval = this.permission.hashCode();
            if (this.name != null) {
                retval ^= this.name.hashCode();
            }
            if (this.action != null) {
                retval ^= this.action.hashCode();
            }
            return retval;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PermissionEntry)) {
                return false;
            }
            PermissionEntry that = (PermissionEntry)obj;
            if (this.permission == null ? that.permission != null : !this.permission.equals(that.permission)) {
                return false;
            }
            if (this.name == null ? that.name != null : !this.name.equals(that.name)) {
                return false;
            }
            if (this.action == null ? that.action != null : !this.action.equals(that.action)) {
                return false;
            }
            return !(this.signedBy == null ? that.signedBy != null : !this.signedBy.equals(that.signedBy));
        }

        public void write(PrintWriter out) {
            out.print("permission ");
            out.print(this.permission);
            if (this.name != null) {
                out.print(" \"");
                out.print(this.name.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\"", "\\\\\\\""));
                out.print('\"');
            }
            if (this.action != null) {
                out.print(", \"");
                out.print(this.action);
                out.print('\"');
            }
            if (this.signedBy != null) {
                out.print(", signedBy \"");
                out.print(this.signedBy);
                out.print('\"');
            }
            out.println(";");
        }
    }

    public static class PrincipalEntry {
        public static final String WILDCARD_CLASS = "WILDCARD_PRINCIPAL_CLASS";
        public static final String WILDCARD_NAME = "WILDCARD_PRINCIPAL_NAME";
        String principalClass;
        String principalName;

        public PrincipalEntry(String principalClass, String principalName) {
            if (principalClass == null || principalName == null) {
                throw new NullPointerException(ResourcesMgr.getString("null principalClass or principalName"));
            }
            this.principalClass = principalClass;
            this.principalName = principalName;
        }

        public String getPrincipalClass() {
            return this.principalClass;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        public String getDisplayClass() {
            if (this.principalClass.equals(WILDCARD_CLASS)) {
                return "*";
            }
            if (this.principalClass.equals(PolicyParser.REPLACE_NAME)) {
                return "";
            }
            return this.principalClass;
        }

        public String getDisplayName() {
            return this.getDisplayName(false);
        }

        public String getDisplayName(boolean addQuote) {
            if (this.principalName.equals(WILDCARD_NAME)) {
                return "*";
            }
            if (addQuote) {
                return "\"" + this.principalName + "\"";
            }
            return this.principalName;
        }

        public String toString() {
            if (!this.principalClass.equals(PolicyParser.REPLACE_NAME)) {
                return this.getDisplayClass() + "/" + this.getDisplayName();
            }
            return this.getDisplayName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PrincipalEntry)) {
                return false;
            }
            PrincipalEntry that = (PrincipalEntry)obj;
            return this.principalClass.equals(that.principalClass) && this.principalName.equals(that.principalName);
        }

        public int hashCode() {
            return this.principalClass.hashCode();
        }

        public void write(PrintWriter out) {
            out.print("principal " + this.getDisplayClass() + " " + this.getDisplayName(true));
        }
    }
}

