/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc.provider;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Set;

public class Role {
    String roleName;
    Permissions permissions;
    Set<Principal> principals;

    public Role(String name) {
        this.roleName = name;
    }

    public boolean equals(Object o) {
        Role other = o == null || !(o instanceof Role) ? null : (Role)o;
        return o == null ? false : this.getName().equals(other.getName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.roleName != null ? this.roleName.hashCode() : 0);
        return hash;
    }

    public String getName() {
        return this.roleName;
    }

    void addPermission(Permission p) {
        if (this.permissions == null) {
            this.permissions = new Permissions();
        }
        this.permissions.add(p);
    }

    void addPermissions(PermissionCollection pc) {
        if (this.permissions == null) {
            this.permissions = new Permissions();
        }
        Enumeration<Permission> e = pc.elements();
        while (e.hasMoreElements()) {
            this.permissions.add(e.nextElement());
        }
    }

    Permissions getPermissions() {
        return this.permissions;
    }

    void setPrincipals(Set<Principal> pSet) {
        if (pSet != null) {
            this.principals = pSet;
        }
    }

    boolean implies(Permission p) {
        boolean rvalue = false;
        if (this.permissions != null) {
            rvalue = this.permissions.implies(p);
        }
        return rvalue;
    }

    boolean isPrincipalInRole(Principal p) {
        boolean rvalue = false;
        if (this.principals != null) {
            rvalue = this.principals.contains(p);
        }
        return rvalue;
    }

    boolean arePrincipalsInRole(Principal[] subject) {
        if (subject == null || subject.length == 0) {
            return false;
        }
        if (this.principals == null || this.principals.isEmpty()) {
            return false;
        }
        boolean rvalue = false;
        for (Principal p : subject) {
            if (!this.principals.contains(p)) continue;
            rvalue = true;
            break;
        }
        return rvalue;
    }
}

