/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.auth.login;

import com.sun.appserv.security.AppservPasswordLoginModule;
import com.sun.enterprise.security.ee.auth.realm.pam.PamRealm;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;

public class PamLoginModule
extends AppservPasswordLoginModule {
    @Override
    protected void authenticateUser() throws LoginException {
        if (this._username == null || this._username.length() == 0) {
            throw new LoginException("Invalid Username");
        }
        UnixUser user = this.authenticate(this._username, this._password);
        if (user == null) {
            throw new LoginException("Failed Pam Login for " + this._username);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "PAM login succeeded for: " + this._username);
        }
        String[] grpList = null;
        Set<String> groupSet = user.getGroups();
        if (groupSet != null) {
            grpList = new String[groupSet.size()];
            user.getGroups().toArray(grpList);
        } else {
            grpList = new String[]{};
        }
        this.commitUserAuthentication(grpList);
    }

    private UnixUser authenticate(String username, String password) throws LoginException {
        UnixUser user = null;
        String pamService = null;
        if (!(this._currentRealm instanceof PamRealm)) {
            throw new LoginException("pamrealm.invalid_realm");
        }
        pamService = ((PamRealm)this._currentRealm).getPamService();
        try {
            user = new PAM(pamService).authenticate(username, password);
        }
        catch (PAMException e) {
            _logger.log(Level.SEVERE, "pam_exception_authenticate", e);
        }
        return user;
    }
}

