/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.auth.login;

import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.ee.auth.realm.jdbc.JDBCRealm;
import java.util.Arrays;
import java.util.logging.Level;

public class JDBCLoginModule
extends PasswordLoginModule {
    @Override
    protected void authenticate() throws LoginException {
        if (!(this._currentRealm instanceof JDBCRealm)) {
            String msg = sm.getString("jdbclm.badrealm");
            throw new LoginException(msg);
        }
        JDBCRealm jdbcRealm = (JDBCRealm)this._currentRealm;
        if (this._username == null || this._username.length() == 0) {
            String msg = sm.getString("jdbclm.nulluser");
            throw new LoginException(msg);
        }
        Object[] grpList = jdbcRealm.authenticate(this._username, this.getPasswordChar());
        if (grpList == null) {
            String msg = sm.getString("jdbclm.loginfail", this._username);
            throw new LoginException(msg);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JDBC login succeeded for: " + this._username + " groups:" + Arrays.toString(grpList));
        }
        this.commitAuthentication(this._username, this.getPasswordChar(), this._currentRealm, (String[])grpList);
    }
}

