/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-supported-cipher-suites")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.supported.cipher.suites")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=SecurityService.class, opType=RestEndpoint.OpType.GET, path="list-supported-cipher-suites", description="List Supported Cipher Suites")})
@AccessRequired(resource={"domain/security-service"}, action={"read"})
public class ListSupportedCipherSuites
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListSupportedCipherSuites.class);
    @Inject
    SSLUtils sslutils;
    @Param(optional=true, primary=true, defaultValue="server")
    private String target;

    @Override
    public void execute(AdminCommandContext context) {
        String[] cipherSuites;
        ActionReport report = context.getActionReport();
        for (String cipherSuite : cipherSuites = this.sslutils.getSupportedCipherSuites()) {
            if (cipherSuite.contains("_KRB5_")) continue;
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(cipherSuite);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

