/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.ldap.LDAPRealm;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.InitialContext;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="configure-ldap-for-admin")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="configure-ldap-for-admin", description="configure-ldap-for-admin")})
public class LDAPAdminAccessConfigurator
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Param(name="basedn", shortName="b", optional=false)
    public volatile String basedn;
    @Param(name="url", optional=true)
    public volatile String url = "ldap://localhost:389";
    @Param(name="ldap-group", shortName="g", optional=true)
    public volatile String ldapGroupName;
    @Inject
    Target targetService;
    @Inject
    private ConfigBeansUtilities configBeansUtilities;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    private static final String ADMIN_SERVER = "server";
    private static final StringManager lsm = StringManager.getManager(LDAPAdminAccessConfigurator.class);
    private static final String DIR_P = "directory";
    private static final String BASEDN_P = "base-dn";
    private static final String JAAS_P = "jaas-context";
    private static final String JAAS_V = "ldapRealm";
    public static final String LDAP_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String DEFAULT_SSL_LDAP_SOCKET_FACTORY = "com.sun.enterprise.security.auth.realm.ldap.CustomSocketFactory";
    public static final String LDAPS_URL = "ldaps://";
    private static final Logger logger = LogDomains.getLogger(LDAPAdminAccessConfigurator.class, "javax.enterprise.system.core.security");
    private Config asc;
    @AccessRequired.To(value={"update"})
    private AuthRealm adminAuthRealm;
    @AccessRequired.To(value={"update"})
    private AdminService adminService;
    public static final String FIXED_ADMIN_REALM_NAME = "admin-realm";
    public static final String ORIG_ADMIN_REALM_NAME = "admin-realm-original";

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.asc = this.chooseConfig();
        SecurityService ss = this.asc.getSecurityService();
        this.adminAuthRealm = this.getAdminRealm(ss);
        this.adminService = this.asc.getAdminService();
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport rep = context.getActionReport();
        StringBuilder sb = new StringBuilder();
        if (this.url != null && !this.url.startsWith("ldap://") && !this.url.startsWith(LDAPS_URL)) {
            this.url = "ldap://" + this.url;
        }
        if (!this.pingLDAP(sb)) {
            rep.setMessage(sb.toString());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this.configure(sb);
            rep.setMessage(sb.toString());
            rep.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tf) {
            rep.setMessage(tf.getMessage());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (PropertyVetoException e) {
            rep.setMessage(e.getMessage());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void configure(StringBuilder sb) throws TransactionFailure, PropertyVetoException {
        this.deleteRealm(this.asc.getSecurityService(), sb);
        this.createRealm(this.asc.getSecurityService(), sb);
        this.configureAdminService(this.asc.getAdminService());
    }

    private AuthRealm getAdminRealm(SecurityService ss) {
        List<AuthRealm> realms = ss.getAuthRealm();
        for (AuthRealm realm : realms) {
            if (!FIXED_ADMIN_REALM_NAME.equals(realm.getName())) continue;
            return realm;
        }
        return null;
    }

    private void configureAdminService(AdminService as) throws PropertyVetoException, TransactionFailure {
        SingleConfigCode<AdminService> scc = new SingleConfigCode<AdminService>(){

            @Override
            public Object run(AdminService as) {
                try {
                    as.setAuthRealmName(LDAPAdminAccessConfigurator.FIXED_ADMIN_REALM_NAME);
                    return as;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        ConfigSupport.apply(scc, as);
    }

    private void createRealm(SecurityService ss, final StringBuilder sb) throws TransactionFailure {
        SingleConfigCode<SecurityService> scc = new SingleConfigCode<SecurityService>(){

            @Override
            public Object run(SecurityService ss) throws PropertyVetoException, TransactionFailure {
                AuthRealm ldapr = LDAPAdminAccessConfigurator.this.createLDAPRealm(ss);
                ss.getAuthRealm().add(ldapr);
                LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.realm.setup", LDAPAdminAccessConfigurator.FIXED_ADMIN_REALM_NAME));
                return true;
            }
        };
        ConfigSupport.apply(scc, ss);
    }

    private void deleteRealm(SecurityService ss, final StringBuilder sb) throws TransactionFailure {
        SingleConfigCode<SecurityService> scc = new SingleConfigCode<SecurityService>(){

            @Override
            public Object run(SecurityService ss) throws PropertyVetoException, TransactionFailure {
                AuthRealm oldAdminRealm = LDAPAdminAccessConfigurator.this.getAdminRealm(ss);
                ss.getAuthRealm().remove(oldAdminRealm);
                LDAPAdminAccessConfigurator.appendNL(sb, "...");
                return true;
            }
        };
        ConfigSupport.apply(scc, ss);
    }

    private AuthRealm createLDAPRealm(SecurityService ss) throws TransactionFailure, PropertyVetoException {
        AuthRealm ar = ss.createChild(AuthRealm.class);
        ar.setClassname(LDAPRealm.class.getName());
        ar.setName(FIXED_ADMIN_REALM_NAME);
        List<Property> props = ar.getProperty();
        Property p = ar.createChild(Property.class);
        p.setName(DIR_P);
        p.setValue(this.url);
        props.add(p);
        p = ar.createChild(Property.class);
        p.setName(BASEDN_P);
        p.setValue(this.basedn);
        props.add(p);
        p = ar.createChild(Property.class);
        p.setName(JAAS_P);
        p.setValue(JAAS_V);
        props.add(p);
        if (this.ldapGroupName != null) {
            p = ar.createChild(Property.class);
            p.setName("group-mapping");
            p.setValue(this.ldapGroupName + "->asadmin");
            props.add(p);
        }
        return ar;
    }

    private boolean pingLDAP(StringBuilder sb) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        if (this.url != null && this.url.startsWith(LDAPS_URL)) {
            env.put(LDAP_SOCKET_FACTORY, DEFAULT_SSL_LDAP_SOCKET_FACTORY);
        }
        try {
            new InitialContext(env);
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.ok", this.url));
            return true;
        }
        catch (AuthenticationNotSupportedException anse) {
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.ok", this.url));
            return true;
        }
        catch (Exception e) {
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.na", this.url, e.getClass().getName(), e.getMessage()));
            logger.info(StringUtils.getStackTrace(e));
            return false;
        }
    }

    private static void appendNL(StringBuilder sb, String s) {
        sb.append(s).append("%%%EOL%%%");
    }

    private Config chooseConfig() {
        Server s = this.configBeansUtilities.getServerNamed(ADMIN_SERVER);
        String ac = s.getConfigRef();
        return this.targetService.getConfig(ac);
    }
}

