/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;

public class CLIUtil {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CLIUtil.class);

    static Config chooseConfig(Domain domain, String target) {
        Cluster cluster;
        Config config = null;
        Config tmp = null;
        try {
            tmp = domain.getConfigs().getConfigByName(target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            return tmp;
        }
        Server targetServer = domain.getServerNamed(target);
        if (targetServer != null) {
            config = domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = domain.getClusterNamed(target)) != null) {
            config = domain.getConfigNamed(cluster.getConfigRef());
        }
        return config;
    }

    static Config chooseConfig(Domain domain, String target, ActionReport report) {
        Config config = CLIUtil.chooseConfig(domain, target);
        if (config == null) {
            report.setMessage(localStrings.getLocalString("util.noconfigfortarget", "Configuration for target {0} not found.", target));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return config;
    }

    static boolean isRealmNew(SecurityService securityService, String authRealmName) {
        List<AuthRealm> authrealms = securityService.getAuthRealm();
        for (AuthRealm authrealm : authrealms) {
            if (!authrealm.getName().equals(authRealmName)) continue;
            return false;
        }
        return true;
    }

    static AuthRealm findRealm(SecurityService securityService, String authRealmName) {
        if (authRealmName == null) {
            authRealmName = securityService.getDefaultRealm();
        }
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            if (!authRealm.getName().equals(authRealmName)) continue;
            return authRealm;
        }
        return null;
    }

    static JaccProvider findJaccProvider(SecurityService securityService, String jaccProviderName) {
        List<JaccProvider> jaccProviders = securityService.getJaccProvider();
        for (JaccProvider jaccProv : jaccProviders) {
            if (!jaccProv.getName().equals(jaccProviderName)) continue;
            return jaccProv;
        }
        return null;
    }

    static MessageSecurityConfig findMessageSecurityConfig(SecurityService securityService, String authLayer) {
        List<MessageSecurityConfig> mscs = securityService.getMessageSecurityConfig();
        for (MessageSecurityConfig msc : mscs) {
            if (!msc.getAuthLayer().equals(authLayer)) continue;
            return msc;
        }
        return null;
    }
}

