/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.ldap;

import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.SharedSecureRandom;

public class CustomSocketFactory
extends SocketFactory
implements Comparator<SocketFactory> {
    private SocketFactory socketFactory;
    public static final String SSL = "SSL";
    protected static final Logger _logger = LogDomains.getLogger(CustomSocketFactory.class, "javax.enterprise.system.core.security");
    protected static final StringManager sm = StringManager.getManager(CustomSocketFactory.class);
    private static final CustomSocketFactory customSocketFactory = new CustomSocketFactory();

    public CustomSocketFactory() {
        SSLUtils sslUtils = Globals.getDefaultHabitat().getService(SSLUtils.class, new Annotation[0]);
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance(SSL);
            sc.init(sslUtils.getKeyManagers(), sslUtils.getTrustManagers(), SharedSecureRandom.get());
            this.socketFactory = sc.getSocketFactory();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "security.exception", ex);
        }
    }

    @Override
    public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return this.socketFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return this.socketFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public int compare(SocketFactory s1, SocketFactory s2) {
        return s1.getClass().toString().compareTo(s2.getClass().toString());
    }

    public static SocketFactory getDefault() {
        return customSocketFactory;
    }
}

