/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.admin.cli;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecureAdminHelper;
import com.sun.enterprise.security.admin.cli.Strings;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class SecureAdminHelperImpl
implements SecureAdminHelper {
    private static final char[] emptyPassword = new char[0];
    private static final String DOMAIN_ADMIN_GROUP_NAME = "asadmin";
    @Inject
    private SSLUtils sslUtils;
    @Inject
    @Named(value="Security SSL Password Provider Service")
    private MasterPassword masterPasswordHelper;
    @Inject
    @Named(value="default-instance-name")
    private volatile AdminService as;

    @Override
    public String getDN(String value, boolean isAlias) throws IOException, KeyStoreException {
        if (isAlias) {
            KeyStore keyStore = this.sslUtils.getKeyStore();
            if (keyStore == null) {
                throw new RuntimeException(Strings.get("noKeyStore"));
            }
            Certificate cert = keyStore.getCertificate(value);
            if (cert == null) {
                throw new IllegalArgumentException(Strings.get("noAlias", value));
            }
            if (!(cert instanceof X509Certificate)) {
                throw new IllegalArgumentException(Strings.get("certNotX509Certificate", value));
            }
            return ((X509Certificate)cert).getSubjectX500Principal().getName();
        }
        return value;
    }

    @Override
    public void validateInternalUsernameAndPasswordAlias(String username, String passwordAlias) {
        try {
            this.validateUser(username);
            this.validatePasswordAlias(passwordAlias);
        }
        catch (Exception ex) {
            throw new RuntimeException(Strings.get("errVal"), ex);
        }
    }

    private void validateUser(String username) throws BadRealmException, NoSuchRealmException {
        FileRealm fr = this.adminRealm();
        try {
            FileRealmUser fru = (FileRealmUser)fr.getUser(username);
            if (this.isInAdminGroup(fru)) {
                return;
            }
            throw new RuntimeException(Strings.get("notAdminUser", username));
        }
        catch (NoSuchUserException ex) {
            throw new RuntimeException(Strings.get("notAdminUser", username));
        }
    }

    private boolean isInAdminGroup(FileRealmUser user) {
        for (String group2 : user.getGroups()) {
            if (!group2.equals(DOMAIN_ADMIN_GROUP_NAME)) continue;
            return true;
        }
        return false;
    }

    private void validatePasswordAlias(String passwordAlias) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, NoSuchAlgorithmException, IOException {
        if (!this.masterPasswordHelper.getMasterPasswordAdapter().aliasExists(passwordAlias)) {
            throw new RuntimeException(Strings.get("noAlias", passwordAlias));
        }
    }

    private FileRealm adminRealm() throws BadRealmException, NoSuchRealmException {
        AuthRealm ar = this.as.getAssociatedAuthRealm();
        if (FileRealm.class.getName().equals(ar.getClassname())) {
            String adminKeyFilePath = ar.getPropertyValue("file");
            FileRealm fr = new FileRealm(adminKeyFilePath);
            return fr;
        }
        return null;
    }

    @Override
    public boolean isAnyAdminUserWithoutPassword() throws Exception {
        FileRealm adminRealm = this.adminRealm();
        if (adminRealm == null) {
            return true;
        }
        Enumeration<String> e = adminRealm.getUserNames();
        while (e.hasMoreElements()) {
            String username = e.nextElement();
            String[] groupNames = adminRealm.authenticate(username, emptyPassword);
            if (groupNames == null) continue;
            for (String groupName : groupNames) {
                if (!DOMAIN_ADMIN_GROUP_NAME.equals(groupName)) continue;
                return true;
            }
        }
        return false;
    }
}

