/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class SecurityUpgradeService
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;
    @Inject
    ServerEnvironment env;
    private static final String DIR_GENERATED_POLICY = "generated" + File.separator + "policy";
    private static final String DIR_CONFIG = "config";
    private static final String JKS = ".jks";
    private static final String NSS = ".db";
    private static final String JDBC_REALM_CLASSNAME = "com.sun.enterprise.security.ee.auth.realm.jdbc.JDBCRealm";
    public static final String PARAM_DIGEST_ALGORITHM = "digest-algorithm";
    private static final Logger _logger = LogDomains.getLogger(SecurityUpgradeService.class, "javax.enterprise.system.core.security");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecurityUpgradeService.class);

    @Override
    public void postConstruct() {
        File[] applicationDirs;
        for (Config config : this.configs.getConfig()) {
            SecurityService service = config.getSecurityService();
            if (service == null) continue;
            this.upgradeJACCProvider(service);
        }
        String instanceRoot = this.env.getInstanceRoot().getAbsolutePath();
        File genPolicyDir = new File(instanceRoot, DIR_GENERATED_POLICY);
        if (genPolicyDir != null && (applicationDirs = genPolicyDir.listFiles()) != null) {
            for (File policyDir : applicationDirs) {
                this.deleteFile(policyDir);
            }
        }
        for (Config config : this.configs.getConfig()) {
            SecurityService service = config.getSecurityService();
            List<AuthRealm> authRealms = service.getAuthRealm();
            try {
                for (AuthRealm authRealm : authRealms) {
                    if (!JDBC_REALM_CLASSNAME.equals(authRealm.getClassname())) continue;
                    Property digestAlgoProp = authRealm.getProperty(PARAM_DIGEST_ALGORITHM);
                    if (digestAlgoProp != null) {
                        String digestAlgo = digestAlgoProp.getValue();
                        if (digestAlgo != null && !digestAlgo.isEmpty()) continue;
                        digestAlgoProp.setValue("MD5");
                        continue;
                    }
                    ConfigSupport.apply(new SingleConfigCode<AuthRealm>(){

                        @Override
                        public Object run(AuthRealm updatedAuthRealm) throws PropertyVetoException, TransactionFailure {
                            Property prop1 = updatedAuthRealm.createChild(Property.class);
                            prop1.setName(SecurityUpgradeService.PARAM_DIGEST_ALGORITHM);
                            prop1.setValue("MD5");
                            updatedAuthRealm.getProperty().add(prop1);
                            return null;
                        }
                    }, authRealm);
                }
            }
            catch (PropertyVetoException pve) {
                _logger.log(Level.SEVERE, "security_upgrade_service_exception", pve);
                throw new RuntimeException(pve);
            }
            catch (TransactionFailure tf) {
                _logger.log(Level.SEVERE, "security_upgrade_service_exception", tf);
                throw new RuntimeException(tf);
            }
        }
        if (this.requiresSecureAdmin()) {
            _logger.log(Level.WARNING, localStrings.getLocalString("enterprise.security.upgrade.warning", "Upgrade from v2 EE  to v3.1 requires manual steps.Please refer to the v3.1 Upgrade Guide for details."));
        }
    }

    public boolean requiresSecureAdmin() {
        String instanceRoot = this.env.getInstanceRoot().getAbsolutePath();
        File configDir = new File(instanceRoot, DIR_CONFIG);
        if (configDir.isDirectory()) {
            for (File configFile : configDir.listFiles()) {
                if (!configFile.getName().endsWith(NSS)) continue;
                return true;
            }
        }
        return false;
    }

    private void upgradeJACCProvider(SecurityService securityService) {
        try {
            List<JaccProvider> jaccProviders = securityService.getJaccProvider();
            for (JaccProvider jacc : jaccProviders) {
                if (!"com.sun.enterprise.security.jacc.provider.SimplePolicyConfigurationFactory".equals(jacc.getPolicyConfigurationFactoryProvider())) continue;
                return;
            }
            ConfigSupport.apply(new SingleConfigCode<SecurityService>(){

                @Override
                public Object run(SecurityService secServ) throws PropertyVetoException, TransactionFailure {
                    JaccProvider jacc = secServ.createChild(JaccProvider.class);
                    jacc.setName("simple");
                    jacc.setPolicyConfigurationFactoryProvider("com.sun.enterprise.security.jacc.provider.SimplePolicyConfigurationFactory");
                    jacc.setPolicyProvider("com.sun.enterprise.security.jacc.provider.SimplePolicyProvider");
                    secServ.getJaccProvider().add(jacc);
                    return secServ;
                }
            }, securityService);
        }
        catch (TransactionFailure ex) {
            Logger.getAnonymousLogger().log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private boolean deleteFile(File path) {
        if (path != null && path.exists()) {
            if (path.isDirectory()) {
                File[] files;
                for (File file : files = path.listFiles()) {
                    if (file.isDirectory()) {
                        this.deleteFile(file);
                        if (!file.delete()) continue;
                        continue;
                    }
                    if (!file.delete()) continue;
                }
            }
            if (!path.delete()) {
                return false;
            }
        }
        return true;
    }
}

