/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecurityServicesUtil {
    private static ServiceLocator habitat = Globals.getDefaultHabitat();
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(SecurityServicesUtil.class);
    private static final Logger _logger = LogDomains.getLogger(SecurityServicesUtil.class, "javax.enterprise.system.core.security");
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private ServerEnvironment env;
    @Inject
    private AuditManager auditManager;
    private CallbackHandler callbackHandler;

    public ServiceLocator getHabitat() {
        return habitat;
    }

    public AuditManager getAuditManager() {
        return this.auditManager;
    }

    public static SecurityServicesUtil getInstance() {
        if (habitat == null) {
            return null;
        }
        return habitat.getService(SecurityServicesUtil.class, new Annotation[0]);
    }

    public ProcessEnvironment getProcessEnv() {
        return this.processEnv;
    }

    public boolean isACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isServer() {
        return this.processEnv.getProcessType().isServer();
    }

    public boolean isNotServerOrACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }
}

