/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.ContainerSecurityLifecycle;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityConfigListener;
import com.sun.enterprise.security.SecurityLifecycleException;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecurityLifecycle
implements PostConstruct,
PreDestroy {
    @Inject
    private ServerContext sc;
    @Inject
    private PolicyLoader policyLoader;
    @Inject
    private SecurityServicesUtil secServUtil;
    @Inject
    private Util util;
    @Inject
    private SSLUtils sslUtils;
    @Inject
    private SecurityConfigListener configListener;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private RealmsManager realmsManager;
    @Inject
    @Optional
    private ContainerSecurityLifecycle eeSecLifecycle;
    private EventListener listener = null;
    private static final String SYS_PROP_LOGIN_CONF = "java.security.auth.login.config";
    private static final String SYS_PROP_JAVA_SEC_POLICY = "java.security.policy";
    private static final Logger _logger = LogDomains.getLogger(SecurityLifecycle.class, "javax.enterprise.system.core.security");

    public SecurityLifecycle() {
        try {
            if (Util.isEmbeddedServer()) {
                if (System.getProperty(SYS_PROP_LOGIN_CONF) == null) {
                    System.setProperty(SYS_PROP_LOGIN_CONF, Util.writeConfigFileToTempDir("login.conf").getAbsolutePath());
                }
                if (System.getProperty(SYS_PROP_JAVA_SEC_POLICY) == null) {
                    System.setProperty(SYS_PROP_JAVA_SEC_POLICY, Util.writeConfigFileToTempDir("server.policy").getAbsolutePath());
                }
            }
            SecurityManager secMgr = System.getSecurityManager();
            if (_logger.isLoggable(Level.INFO)) {
                if (secMgr != null) {
                    _logger.info("security.secmgron");
                } else {
                    _logger.info("security.secmgroff");
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "java_security.init_securitylifecycle_fail", ex);
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public void onInitialization() {
        try {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "sec.service.startup.enter");
            }
            this.policyLoader.loadPolicy();
            this.realmsManager.createRealms();
            AuditManager auditManager = this.secServUtil.getAuditManager();
            auditManager.loadAuditModules();
            auditManager.serverStarted();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "sec.service.startup.exit");
            }
        }
        catch (Exception ex) {
            throw new SecurityLifecycleException(ex);
        }
    }

    @Override
    public void postConstruct() {
        this.onInitialization();
        this.listener = new AuditServerShutdownListener();
        Events events = this.habitat.getService(Events.class, new Annotation[0]);
        events.register(this.listener);
    }

    @Override
    public void preDestroy() {
    }

    public class AuditServerShutdownListener
    implements EventListener {
        @Override
        public void event(EventListener.Event event) {
            if (EventTypes.SERVER_SHUTDOWN.equals(event.type())) {
                SecurityLifecycle.this.secServUtil.getAuditManager().serverShutdown();
            }
        }
    }
}

