/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.naming.NamingException;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.javaee.services.CommonResourceProxy;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.glassfish.resources.javamail.config.MailResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=MailSessionDescriptor.class)
public class MailSessionDeployer
implements ResourceDeployer {
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    @Inject
    private Provider<CommonResourceProxy> mailSessionProxyProvider;
    @Inject
    private Provider<ResourceNamingService> resourceNamingServiceProvider;
    @Inject
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(MailSessionDeployer.class, "javax.enterprise.resource.resourceadapter");

    @Override
    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void deployResource(Object resource) throws Exception {
        MailSessionDescriptor desc = (MailSessionDescriptor)resource;
        String resourceName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), desc.getResourceType());
        MyMailResource mailResource = new MyMailResource(desc, resourceName);
        this.getDeployer(mailResource).deployResource(mailResource);
        _logger.log(Level.FINE, "Mail-Session resource is deployed having resource-name [" + desc.getName() + "]");
    }

    @Override
    public void undeployResource(Object resource) throws Exception {
        MailSessionDescriptor desc = (MailSessionDescriptor)resource;
        String resourceName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), desc.getResourceType());
        MyMailResource mailResource = new MyMailResource(desc, resourceName);
        this.getDeployer(mailResource).undeployResource(mailResource);
        _logger.log(Level.FINE, "Mail-Session resource is undeployed having resource-name [" + desc.getName() + "]");
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for mail-session type");
    }

    @Override
    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for mail-session type");
    }

    @Override
    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for mail-session type");
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof MailSessionDescriptor;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    @Override
    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    @Override
    public void validatePreservedResource(com.sun.enterprise.config.serverbeans.Application oldApp, com.sun.enterprise.config.serverbeans.Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    public void registerMailSessions(Application application) {
        String appName = application.getAppName();
        Set<BundleDescriptor> bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle2 : bundles) {
            this.registerMailSessionDefinitions(appName, bundle2);
            Collection<RootDeploymentDescriptor> dds = bundle2.getExtensionsDescriptors();
            if (dds == null) continue;
            for (RootDeploymentDescriptor dd : dds) {
                this.registerMailSessionDefinitions(appName, dd);
            }
        }
    }

    private void registerMailSessionDefinitions(String appName, Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)((Object)descriptor);
            for (Descriptor descriptor2 : env.getResourceDescriptors(JavaEEResourceType.MSD)) {
                this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)descriptor2);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set<? extends EjbDescriptor> ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (Descriptor descriptor3 : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)descriptor3);
                }
            }
            Set<EjbInterceptor> set = ejbDesc.getInterceptors();
            for (EjbInterceptor ejbInterceptor : set) {
                for (Descriptor descriptor4 : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)descriptor4);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set<ManagedBeanDescriptor> managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor managedBeanDescriptor : managedBeanDescriptors) {
                for (Descriptor descriptor5 : managedBeanDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)descriptor5);
                }
            }
        }
    }

    private void registerMSDReferredByApplication(String appName, MailSessionDescriptor msd) {
        if (!msd.isDeployed()) {
            CommonResourceProxy proxy = this.mailSessionProxyProvider.get();
            ResourceNamingService resourceNamingService = this.resourceNamingServiceProvider.get();
            proxy.setDescriptor(msd);
            if (msd.getName().startsWith("java:app/")) {
                msd.setResourceId(appName);
            }
            if (msd.getName().startsWith("java:global/") || msd.getName().startsWith("java:app/")) {
                ResourceInfo resourceInfo = new ResourceInfo(msd.getName(), appName);
                try {
                    resourceNamingService.publishObject(resourceInfo, proxy, true);
                    msd.setDeployed(true);
                }
                catch (NamingException e) {
                    Object[] params = new Object[]{appName, msd.getName(), e};
                    _logger.log(Level.WARNING, "exception while registering mail-session ", params);
                }
            }
        }
    }

    public void unRegisterMailSessions(Application application) {
        Set<BundleDescriptor> bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle2 : bundles) {
            this.unRegisterMailSessions(bundle2);
            Collection<RootDeploymentDescriptor> dds = bundle2.getExtensionsDescriptors();
            if (dds == null) continue;
            for (RootDeploymentDescriptor dd : dds) {
                this.unRegisterMailSessions(dd);
            }
        }
    }

    private void unRegisterMailSessions(Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)((Object)descriptor);
            for (Descriptor descriptor2 : env.getResourceDescriptors(JavaEEResourceType.MSD)) {
                this.unRegisterMSDReferredByApplication((MailSessionDescriptor)descriptor2);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set<? extends EjbDescriptor> ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (Descriptor descriptor3 : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.unRegisterMSDReferredByApplication((MailSessionDescriptor)descriptor3);
                }
            }
            Set<EjbInterceptor> set = ejbDesc.getInterceptors();
            for (EjbInterceptor ejbInterceptor : set) {
                for (Descriptor descriptor4 : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.unRegisterMSDReferredByApplication((MailSessionDescriptor)descriptor4);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set<ManagedBeanDescriptor> managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor managedBeanDescriptor : managedBeanDescriptors) {
                for (Descriptor descriptor5 : managedBeanDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.unRegisterMSDReferredByApplication((MailSessionDescriptor)descriptor5);
                }
            }
        }
    }

    private void unRegisterMSDReferredByApplication(MailSessionDescriptor msd) {
        try {
            if (msd.isDeployed()) {
                this.undeployResource(msd);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "exception while unregistering mail-session [ " + msd.getName() + " ]", e);
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        @Override
        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBeanProxy getParent() {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }

    class MyMailResource
    extends FakeConfigBean
    implements MailResource {
        private MailSessionDescriptor desc;
        private String name;

        public MyMailResource(MailSessionDescriptor desc, String name) {
            this.desc = desc;
            this.name = name;
        }

        @Override
        public String getStoreProtocol() {
            return this.desc.getStoreProtocol();
        }

        @Override
        public void setStoreProtocol(String value) throws PropertyVetoException {
        }

        @Override
        public String getStoreProtocolClass() {
            return this.desc.getStoreProtocolClass();
        }

        @Override
        public void setStoreProtocolClass(String value) throws PropertyVetoException {
        }

        @Override
        public String getTransportProtocol() {
            return this.desc.getTransportProtocol();
        }

        @Override
        public void setTransportProtocol(String value) throws PropertyVetoException {
        }

        @Override
        public String getTransportProtocolClass() {
            return this.desc.getTransportProtocol();
        }

        @Override
        public void setTransportProtocolClass(String value) throws PropertyVetoException {
        }

        @Override
        public String getHost() {
            return this.desc.getHost();
        }

        @Override
        public void setHost(String value) throws PropertyVetoException {
        }

        @Override
        public String getUser() {
            return this.desc.getUser();
        }

        @Override
        public void setUser(String value) throws PropertyVetoException {
        }

        @Override
        public String getFrom() {
            return this.desc.getFrom();
        }

        @Override
        public void setFrom(String value) throws PropertyVetoException {
        }

        @Override
        public String getDebug() {
            return String.valueOf(true);
        }

        @Override
        public void setDebug(String value) throws PropertyVetoException {
        }

        @Override
        public String getJndiName() {
            return this.name;
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
        }

        @Override
        public String getEnabled() {
            return String.valueOf(true);
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return this.desc.getDescription();
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            return null;
        }

        @Override
        public Property getProperty(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.name;
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }
    }
}

