/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.ConnectorResourceDefinitionDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.SecurityMap;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=ConnectorResourceDefinitionDescriptor.class)
public class ConnectorResourceDefinitionDeployer
implements ResourceDeployer {
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    private static Logger _logger = LogDomains.getLogger(ConnectorResourceDefinitionDeployer.class, "javax.enterprise.resource.resourceadapter");
    static final String PROPERTY_PREFIX = "org.glassfish.connector-connection-pool.";

    @Override
    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void deployResource(Object resource) throws Exception {
        ConnectorResourceDefinitionDescriptor desc = (ConnectorResourceDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), JavaEEResourceType.CRDPOOL);
        String resourceName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectorResourceDefinitionDeployer.deployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyConnectorConnectionPool connectorCp = new MyConnectorConnectionPool(desc, poolName);
        this.getDeployer(connectorCp).deployResource(connectorCp);
        MyConnectorResource connectorResource = new MyConnectorResource(poolName, resourceName);
        this.getDeployer(connectorResource).deployResource(connectorResource);
    }

    @Override
    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    private ConnectorResourceProperty convertProperty(String name, String value) {
        return new ConnectorResourceProperty(name, value);
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void undeployResource(Object resource) throws Exception {
        ConnectorResourceDefinitionDescriptor desc = (ConnectorResourceDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), JavaEEResourceType.CRDPOOL);
        String resourceName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectorResourceDefinitionDeployer.undeployResource() : pool-name [" + poolName + "], " + " resource-name [" + resourceName + "]");
        }
        MyConnectorResource connectorResource = new MyConnectorResource(poolName, resourceName);
        this.getDeployer(connectorResource).undeployResource(connectorResource);
        MyConnectorConnectionPool connectorCp = new MyConnectorConnectionPool(desc, poolName);
        this.getDeployer(connectorCp).undeployResource(connectorCp);
    }

    @Override
    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for connector-resource-definition type");
    }

    @Override
    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for connector-resource-definition type");
    }

    @Override
    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for connector-resource-definition type");
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof ConnectorResourceDefinitionDescriptor;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    class ConnectorResourceProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        ConnectorResourceProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        @Override
        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBeanProxy getParent() {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }

    class MyConnectorConnectionPool
    extends FakeConfigBean
    implements ConnectorConnectionPool {
        private ConnectorResourceDefinitionDescriptor desc;
        private String name;

        public MyConnectorConnectionPool(ConnectorResourceDefinitionDescriptor desc, String name) {
            this.desc = desc;
            this.name = name;
        }

        @Override
        public String getObjectType() {
            return "user";
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.name;
        }

        @Override
        public String getSteadyPoolSize() {
            String minPoolSize = this.desc.getProperty("org.glassfish.connector-connection-pool.steady-pool-size");
            if (minPoolSize != null && !minPoolSize.equals("")) {
                return minPoolSize;
            }
            return "8";
        }

        @Override
        public void setSteadyPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxPoolSize() {
            String maxPoolSize = this.desc.getProperty("org.glassfish.connector-connection-pool.max-pool-size");
            if (maxPoolSize != null && !maxPoolSize.equals("")) {
                return maxPoolSize;
            }
            return "32";
        }

        @Override
        public void setMaxPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxWaitTimeInMillis() {
            String maxWaitTimeInMillis = this.desc.getProperty("org.glassfish.connector-connection-pool.max-wait-time-in-millis");
            if (maxWaitTimeInMillis != null && !maxWaitTimeInMillis.equals("")) {
                return maxWaitTimeInMillis;
            }
            return "60000";
        }

        @Override
        public void setMaxWaitTimeInMillis(String value) throws PropertyVetoException {
        }

        @Override
        public String getPoolResizeQuantity() {
            String poolResizeQuantity = this.desc.getProperty("org.glassfish.connector-connection-pool.pool-resize-quantity");
            if (poolResizeQuantity != null && !poolResizeQuantity.equals("")) {
                return poolResizeQuantity;
            }
            return "2";
        }

        @Override
        public void setPoolResizeQuantity(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdleTimeoutInSeconds() {
            String idleTimeoutInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.idle-timeout-in-seconds");
            if (idleTimeoutInSeconds != null && !idleTimeoutInSeconds.equals("")) {
                return idleTimeoutInSeconds;
            }
            return "300";
        }

        @Override
        public void setIdleTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getIsConnectionValidationRequired() {
            String isConnectionValidationRequired = this.desc.getProperty("org.glassfish.connector-connection-pool.is-connection-validation-required");
            if (isConnectionValidationRequired != null && !isConnectionValidationRequired.equals("")) {
                return isConnectionValidationRequired;
            }
            return "false";
        }

        @Override
        public void setIsConnectionValidationRequired(String value) throws PropertyVetoException {
        }

        @Override
        public String getResourceAdapterName() {
            String resourceAdapterName = this.desc.getProperty("org.glassfish.connector-connection-pool.resource-adapter-name");
            if (resourceAdapterName != null && !resourceAdapterName.equals("")) {
                return resourceAdapterName;
            }
            return null;
        }

        @Override
        public void setResourceAdapterName(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionDefinitionName() {
            return this.desc.getClassName();
        }

        @Override
        public void setConnectionDefinitionName(String value) throws PropertyVetoException {
        }

        @Override
        public String getFailAllConnections() {
            String failAllConnections = this.desc.getProperty("org.glassfish.connector-connection-pool.fail-all-connections");
            if (failAllConnections != null && !failAllConnections.equals("")) {
                return failAllConnections;
            }
            return "false";
        }

        @Override
        public void setFailAllConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getTransactionSupport() {
            String transactionSupport = this.desc.getProperty("org.glassfish.connector-connection-pool.transaction-support");
            if (transactionSupport != null && !transactionSupport.equals("")) {
                return transactionSupport;
            }
            return "NoTransaction";
        }

        @Override
        public void setTransactionSupport(String value) throws PropertyVetoException {
        }

        @Override
        public String getValidateAtmostOncePeriodInSeconds() {
            String validateAtmostOncePeriodInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.validate-at-most-once-period-in-seconds");
            if (validateAtmostOncePeriodInSeconds != null && !validateAtmostOncePeriodInSeconds.equals("")) {
                return validateAtmostOncePeriodInSeconds;
            }
            return "0";
        }

        @Override
        public void setValidateAtmostOncePeriodInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakTimeoutInSeconds() {
            String connectionLeakTimeoutInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-timeout-in-seconds");
            if (connectionLeakTimeoutInSeconds != null && !connectionLeakTimeoutInSeconds.equals("")) {
                return connectionLeakTimeoutInSeconds;
            }
            return "0";
        }

        @Override
        public void setConnectionLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakReclaim() {
            String connectionLeakReclaim = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-reclaim");
            if (connectionLeakReclaim != null && !connectionLeakReclaim.equals("")) {
                return connectionLeakReclaim;
            }
            return "0";
        }

        @Override
        public void setConnectionLeakReclaim(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryAttempts() {
            String connectionCreationRetryAttempts = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-attempts");
            if (connectionCreationRetryAttempts != null && !connectionCreationRetryAttempts.equals("")) {
                return connectionCreationRetryAttempts;
            }
            return "0";
        }

        @Override
        public void setConnectionCreationRetryAttempts(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryIntervalInSeconds() {
            String connectionCreationRetryIntervalInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-interval-in-seconds");
            if (connectionCreationRetryIntervalInSeconds != null && !connectionCreationRetryIntervalInSeconds.equals("")) {
                return connectionCreationRetryIntervalInSeconds;
            }
            return "0";
        }

        @Override
        public void setConnectionCreationRetryIntervalInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionEnlistment() {
            String lazyConnectionEnlistment = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-enlistment");
            if (lazyConnectionEnlistment != null && !lazyConnectionEnlistment.equals("")) {
                return lazyConnectionEnlistment;
            }
            return "false";
        }

        @Override
        public void setLazyConnectionEnlistment(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionAssociation() {
            String lazyConnectionAssociation = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-association");
            if (lazyConnectionAssociation != null && !lazyConnectionAssociation.equals("")) {
                return lazyConnectionAssociation;
            }
            return "false";
        }

        @Override
        public void setLazyConnectionAssociation(String value) throws PropertyVetoException {
        }

        @Override
        public String getAssociateWithThread() {
            String associateWithThread = this.desc.getProperty("org.glassfish.connector-connection-pool.associate-with-thread");
            if (associateWithThread != null && !associateWithThread.equals("")) {
                return associateWithThread;
            }
            return "false";
        }

        @Override
        public void setAssociateWithThread(String value) throws PropertyVetoException {
        }

        @Override
        public String getPooling() {
            String pooling = this.desc.getProperty("org.glassfish.connector-connection-pool.pooling");
            if (pooling != null && !pooling.equals("")) {
                return pooling;
            }
            return "true";
        }

        @Override
        public void setPooling(String value) throws PropertyVetoException {
        }

        @Override
        public String getMatchConnections() {
            String matchConnections = this.desc.getProperty("org.glassfish.connector-connection-pool.match-connections");
            if (matchConnections != null && !matchConnections.equals("")) {
                return matchConnections;
            }
            return "true";
        }

        @Override
        public void setMatchConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxConnectionUsageCount() {
            String maxConnectionUsageCount = this.desc.getProperty("org.glassfish.connector-connection-pool.max-connection-usage-count");
            if (maxConnectionUsageCount != null && !maxConnectionUsageCount.equals("")) {
                return maxConnectionUsageCount;
            }
            return "0";
        }

        @Override
        public void setMaxConnectionUsageCount(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return this.desc.getDescription();
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            Properties p = this.desc.getProperties();
            ArrayList<Property> connectorResourceProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith(ConnectorResourceDefinitionDeployer.PROPERTY_PREFIX)) continue;
                String value = (String)entry.getValue();
                ConnectorResourceProperty dp = ConnectorResourceDefinitionDeployer.this.convertProperty(key, value);
                connectorResourceProperties.add(dp);
            }
            return connectorResourceProperties;
        }

        @Override
        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new ConnectorResourceProperty(name, value);
        }

        @Override
        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            String value = null;
            value = this.desc.getProperty(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
        }

        @Override
        public String getPing() {
            String ping = this.desc.getProperty("org.glassfish.connector-connection-pool.ping");
            if (ping != null && !ping.equals("")) {
                return ping;
            }
            return "false";
        }

        @Override
        public void setPing(String value) throws PropertyVetoException {
        }

        @Override
        public List<SecurityMap> getSecurityMap() {
            return new ArrayList<SecurityMap>(0);
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }
    }

    class MyConnectorResource
    extends FakeConfigBean
    implements ConnectorResource {
        private String poolName;
        private String jndiName;

        MyConnectorResource(String poolName, String jndiName) {
            this.poolName = poolName;
            this.jndiName = jndiName;
        }

        @Override
        public String getPoolName() {
            return this.poolName;
        }

        @Override
        public void setPoolName(String value) throws PropertyVetoException {
            this.poolName = value;
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.jndiName;
        }

        @Override
        public String getEnabled() {
            return String.valueOf(true);
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            return null;
        }

        @Override
        public Property getProperty(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getJndiName() {
            return this.jndiName;
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
            this.jndiName = value;
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }
    }
}

