/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=AdministeredObjectDefinitionDescriptor.class)
public class AdministeredObjectDefinitionDeployer
implements ResourceDeployer {
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    private static Logger _logger = LogDomains.getLogger(AdministeredObjectDefinitionDeployer.class, "javax.enterprise.resource.resourceadapter");
    static final String PROPERTY_PREFIX = "org.glassfish.admin-object.";

    @Override
    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void deployResource(Object resource) throws Exception {
        AdministeredObjectDefinitionDescriptor desc = (AdministeredObjectDefinitionDescriptor)resource;
        String resourceName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "AdministeredObjectDefinitionDeployer.deployResource() : resource-name [" + resourceName + "]");
        }
        MyAdministeredObjectResource adminObjectResource = new MyAdministeredObjectResource(desc, resourceName);
        this.getDeployer(adminObjectResource).deployResource(adminObjectResource);
    }

    @Override
    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    private AdministeredObjectProperty convertProperty(String name, String value) {
        return new AdministeredObjectProperty(name, value);
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void undeployResource(Object resource) throws Exception {
        AdministeredObjectDefinitionDescriptor desc = (AdministeredObjectDefinitionDescriptor)resource;
        String resourceName = ConnectorsUtil.deriveResourceName(desc.getResourceId(), desc.getName(), desc.getResourceType());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "AdministeredObjectDefinitionDeployer.undeployResource() : resource-name [" + resourceName + "]");
        }
        MyAdministeredObjectResource adminObjectResource = new MyAdministeredObjectResource(desc, resourceName);
        this.getDeployer(adminObjectResource).undeployResource(adminObjectResource);
    }

    @Override
    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for administered-object-definition type");
    }

    @Override
    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for administered-object-definition type");
    }

    @Override
    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for administered-object-definition type");
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof AdministeredObjectDefinitionDescriptor;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    class AdministeredObjectProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        AdministeredObjectProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        @Override
        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBeanProxy getParent() {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }

    class MyAdministeredObjectResource
    extends FakeConfigBean
    implements AdminObjectResource {
        private AdministeredObjectDefinitionDescriptor desc;
        private String name;

        public MyAdministeredObjectResource(AdministeredObjectDefinitionDescriptor desc, String name) {
            this.desc = desc;
            this.name = name;
        }

        @Override
        public String getObjectType() {
            return "user";
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.name;
        }

        @Override
        public String getResAdapter() {
            return this.desc.getResourceAdapterName();
        }

        @Override
        public void setResAdapter(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return this.desc.getDescription();
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public String getJndiName() {
            return this.name;
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
        }

        @Override
        public String getResType() {
            return this.desc.getInterfaceName();
        }

        @Override
        public void setResType(String value) throws PropertyVetoException {
        }

        @Override
        public String getClassName() {
            return this.desc.getClassName();
        }

        @Override
        public void setClassName(String value) throws PropertyVetoException {
        }

        @Override
        public String getEnabled() {
            return "true";
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            Properties p = this.desc.getProperties();
            ArrayList<Property> administeredObjectProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith(AdministeredObjectDefinitionDeployer.PROPERTY_PREFIX)) continue;
                String value = (String)entry.getValue();
                AdministeredObjectProperty dp = AdministeredObjectDefinitionDeployer.this.convertProperty(key, value);
                administeredObjectProperties.add(dp);
            }
            return administeredObjectProperties;
        }

        @Override
        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new AdministeredObjectProperty(name, value);
        }

        @Override
        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            String value = null;
            value = this.desc.getProperty(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }
    }
}

