/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.util;

import com.sun.enterprise.naming.util.LogFacade;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactory;
import com.sun.enterprise.naming.util.ObjectInputStreamWithLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class OSGiObjectInputOutputStreamFactoryImpl
implements ObjectInputOutputStreamFactory {
    public static final String NULL_BUNDLE = "AS-NAMING-00007";
    private static final Logger logger = LogFacade.getLogger();
    private BundleContext ctx;
    PackageAdmin pkgAdm;
    private ConcurrentHashMap<String, Long> name2Id = new ConcurrentHashMap();
    private static final String NOT_A_BUNDLE_KEY = ":";

    public OSGiObjectInputOutputStreamFactoryImpl(BundleContext ctx) {
        this.ctx = ctx;
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        this.pkgAdm = (PackageAdmin)PackageAdmin.class.cast(ctx.getService(ref));
        BundleTracker bt = new BundleTracker(ctx, 46, new BundleTrackerCustomizer(){

            public void modifiedBundle(Bundle bundle2, BundleEvent bundleEvent, Object o) {
            }

            public Object addingBundle(Bundle bundle2, BundleEvent bundleEvent) {
                String key = OSGiObjectInputOutputStreamFactoryImpl.this.makeKey(bundle2);
                OSGiObjectInputOutputStreamFactoryImpl.this.name2Id.put(key, bundle2.getBundleId());
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "BundleTracker.addingBundle BUNDLE " + key + " ==> " + bundle2.getBundleId() + "  for " + bundle2.getSymbolicName());
                }
                return null;
            }

            public void removedBundle(Bundle bundle2, BundleEvent bundleEvent, Object o) {
                String key = OSGiObjectInputOutputStreamFactoryImpl.this.makeKey(bundle2);
                Long bundleID = (Long)OSGiObjectInputOutputStreamFactoryImpl.this.name2Id.remove(key);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "BundleTracker.removedBundle BUNDLE " + key + "  ==> " + bundle2.getSymbolicName());
                }
                if (bundleID == null) {
                    logger.log(Level.WARNING, OSGiObjectInputOutputStreamFactoryImpl.NULL_BUNDLE, key);
                }
            }
        });
        bt.open();
    }

    private String makeKey(Bundle bundle2) {
        return bundle2.getSymbolicName() + NOT_A_BUNDLE_KEY + bundle2.getVersion();
    }

    @Override
    public ObjectInputStream createObjectInputStream(InputStream in) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return new OSGiObjectInputStream(in, loader);
    }

    @Override
    public ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return new OSGiObjectOutputStream(out);
    }

    @Override
    public Class<?> resolveClass(ObjectInputStream in, final ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Long bundleId;
        String key = in.readUTF();
        if (!NOT_A_BUNDLE_KEY.equals(key) && (bundleId = this.name2Id.get(key)) != null) {
            final Bundle b = this.ctx.getBundle(bundleId.longValue());
            if (System.getSecurityManager() == null) {
                return b.loadClass(desc.getName());
            }
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return b.loadClass(desc.getName());
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (ClassNotFoundException)pae.getException();
            }
        }
        return null;
    }

    @Override
    public void annotateClass(ObjectOutputStream out, Class<?> cl) throws IOException {
        String key = NOT_A_BUNDLE_KEY;
        Bundle b = this.pkgAdm.getBundle(cl);
        if (b != null) {
            key = this.makeKey(b);
        }
        out.writeUTF(key);
    }

    private class OSGiObjectInputStream
    extends ObjectInputStreamWithLoader {
        public OSGiObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
            super(in, loader);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class clazz = OSGiObjectInputOutputStreamFactoryImpl.this.resolveClass(this, desc);
            if (clazz == null) {
                clazz = super.resolveClass(desc);
            }
            return clazz;
        }
    }

    private class OSGiObjectOutputStream
    extends ObjectOutputStream {
        private OSGiObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> cl) throws IOException {
            OSGiObjectInputOutputStreamFactoryImpl.this.annotateClass(this, cl);
        }
    }
}

