/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.ContextDuplicatePostProcessor;
import com.sun.enterprise.module.bootstrap.DefaultErrorService;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.AdapterIterator;
import com.sun.enterprise.module.common_impl.FlattenIterator;
import com.sun.enterprise.module.common_impl.ModuleId;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.api.ServiceLocatorState;
import org.glassfish.hk2.bootstrap.HK2Populator;
import org.glassfish.hk2.bootstrap.PopulatorPostProcessor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public abstract class AbstractModulesRegistryImpl
implements ModulesRegistry {
    protected final ModulesRegistry parent;
    protected final ConcurrentMap<ModuleId, Module> modules = new ConcurrentHashMap<ModuleId, Module>();
    protected final Map<Integer, Repository> repositories = new TreeMap<Integer, Repository>();
    private final ConcurrentMap<Class<?>, CopyOnWriteArrayList<?>> runningServices = new ConcurrentHashMap();
    protected final Map<String, Module> providers = new HashMap<String, Module>();
    private Map<ServiceLocator, String> habitats = new Hashtable<ServiceLocator, String>();
    Map<Module, Map<ServiceLocator, List<ActiveDescriptor>>> moduleDescriptors = new ConcurrentHashMap<Module, Map<ServiceLocator, List<ActiveDescriptor>>>();

    protected AbstractModulesRegistryImpl(ModulesRegistry parent) {
        this.parent = parent;
    }

    @Override
    public ServiceLocator newServiceLocator() throws MultiException {
        return this.newServiceLocator(null);
    }

    @Override
    public ServiceLocator newServiceLocator(ServiceLocator parent) throws MultiException {
        ServiceLocator serviceLocator = ServiceLocatorFactory.getInstance().create(null, parent);
        this.initializeServiceLocator(serviceLocator);
        return serviceLocator;
    }

    protected void initializeServiceLocator(ServiceLocator serviceLocator) throws MultiException {
        DynamicConfigurationService dcs = serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.bind(BuilderHelper.createConstantDescriptor(Logger.getAnonymousLogger()));
        config.bind(BuilderHelper.createConstantDescriptor(this));
        config.addActiveDescriptor(DefaultErrorService.class);
        ContextDuplicatePostProcessor processor = serviceLocator.getService(ContextDuplicatePostProcessor.class, new Annotation[0]);
        if (processor == null) {
            config.addActiveDescriptor(ContextDuplicatePostProcessor.class);
        }
        config.commit();
    }

    @Override
    public void populateServiceLocator(String name, ServiceLocator serviceLocator, List<PopulatorPostProcessor> postProcessors) throws MultiException {
        try {
            for (Module module : this.getModules()) {
                List<ActiveDescriptor> foundDs;
                List<ActiveDescriptor> allDescriptors = this.parseInhabitants(module, name, serviceLocator, postProcessors);
                if (allDescriptors == null || allDescriptors.isEmpty()) continue;
                Map<ServiceLocator, List<ActiveDescriptor>> descriptorByServiceLocator = this.moduleDescriptors.get(module);
                if (descriptorByServiceLocator == null) {
                    descriptorByServiceLocator = new HashMap<ServiceLocator, List<ActiveDescriptor>>();
                    this.moduleDescriptors.put(module, descriptorByServiceLocator);
                }
                if ((foundDs = descriptorByServiceLocator.get(serviceLocator)) == null) {
                    foundDs = new LinkedList<ActiveDescriptor>();
                    descriptorByServiceLocator.put(serviceLocator, foundDs);
                }
                foundDs.addAll(allDescriptors);
            }
        }
        catch (Exception e) {
            throw new MultiException(e);
        }
        this.habitats.put(serviceLocator, name);
    }

    @Override
    public void populateConfig(ServiceLocator serviceLocator) {
        try {
            HK2Populator.populateConfig(serviceLocator);
        }
        catch (BootException be) {
            throw new MultiException(be);
        }
    }

    @Override
    public ServiceLocator createServiceLocator(ServiceLocator parent, String name, List<PopulatorPostProcessor> postProcessors) throws MultiException {
        ServiceLocator serviceLocator = this.newServiceLocator(parent);
        this.populateServiceLocator(name, serviceLocator, postProcessors);
        return serviceLocator;
    }

    @Override
    public ServiceLocator createServiceLocator(String name) throws MultiException {
        return this.createServiceLocator(null, name, null);
    }

    @Override
    public ServiceLocator createServiceLocator() throws MultiException {
        return this.createServiceLocator("default");
    }

    protected abstract List<ActiveDescriptor> parseInhabitants(Module var1, String var2, ServiceLocator var3, List<PopulatorPostProcessor> var4) throws IOException, BootException;

    @Override
    public synchronized void addRepository(Repository repository, int weight) {
        for (Repository repo : this.repositories.values()) {
            if (!repo.getLocation().equals(repository.getLocation())) continue;
            throw new RuntimeException("repository at " + repository.getLocation() + " already registered");
        }
        while (this.repositories.containsKey(weight)) {
            ++weight;
        }
        this.repositories.put(weight, repository);
    }

    @Override
    public synchronized void addRepository(Repository repository) {
        this.repositories.put(100 + this.repositories.size(), repository);
    }

    @Override
    public synchronized void removeRepository(String name) {
        for (Integer weight : this.repositories.keySet()) {
            Repository repo = this.repositories.get(weight);
            if (!repo.getName().equals(name)) continue;
            this.repositories.remove(weight);
            return;
        }
    }

    @Override
    public synchronized Repository getRepository(String name) {
        for (Integer weight : this.repositories.keySet()) {
            Repository repo = this.repositories.get(weight);
            if (!repo.getName().equals(name)) continue;
            return repo;
        }
        return null;
    }

    @Override
    public Module makeModuleFor(String name, String version) throws ResolveError {
        return this.makeModuleFor(name, version, true);
    }

    @Override
    public Module makeModuleFor(String name, String version, boolean resolve) throws ResolveError {
        Collection<Module> matchingModules;
        Module module;
        Logger.getAnonymousLogger().fine("this.makeModuleFor(" + name + ", " + version + ", " + resolve + ") called.");
        if (this.parent != null && (module = this.parent.makeModuleFor(name, version, resolve)) != null) {
            return module;
        }
        module = (Module)this.modules.get(AbstractFactory.getInstance().createModuleId(name, version));
        if (module == null && version == null && !(matchingModules = this.getModules(name)).isEmpty()) {
            module = matchingModules.iterator().next();
        }
        if (module == null && (module = this.loadFromRepository(name, version)) != null) {
            this.add(module);
        }
        if (module != null && resolve) {
            try {
                module.resolve();
            }
            catch (Throwable e) {
                module.uninstall();
                throw new ResolveError(e);
            }
        }
        Logger.getAnonymousLogger().info("this.makeModuleFor(" + name + ", " + version + ") returned " + module);
        return module;
    }

    @Override
    public Module makeModuleFor(String packageName) throws ResolveError {
        Module m;
        if (this.parent != null && (m = this.parent.makeModuleFor(packageName)) != null) {
            return m;
        }
        for (Module module : this.modules.values()) {
            String[] exportedPkgs;
            for (String exportedPkg : exportedPkgs = module.getModuleDefinition().getPublicInterfaces()) {
                if (!exportedPkg.equals(packageName)) continue;
                module.resolve();
                return module;
            }
        }
        return null;
    }

    protected Module loadFromRepository(String name, String version) {
        Set<Integer> keys = this.repositories.keySet();
        TreeSet<Integer> sortedKeys = new TreeSet<Integer>();
        sortedKeys.addAll(keys);
        for (Integer key : sortedKeys) {
            Repository repo = this.repositories.get(key);
            ModuleDefinition moduleDef = repo.find(name, version);
            if (moduleDef == null) continue;
            return this.newModule(moduleDef);
        }
        return null;
    }

    protected abstract Module newModule(ModuleDefinition var1);

    protected void add(Module newModule) {
        assert (newModule.getRegistry() == this);
        ModuleId id = AbstractFactory.getInstance().createModuleId(newModule.getModuleDefinition());
        if (this.modules.get(id) != null) {
            return;
        }
        this.modules.put(id, newModule);
        for (ModuleMetadata.Entry entry : newModule.getMetadata().getEntries()) {
            for (String name : entry.providerNames) {
                this.providers.put(name, newModule);
            }
        }
        for (Map.Entry entry : this.habitats.entrySet()) {
            String name = (String)entry.getValue();
            ServiceLocator serviceLocator = (ServiceLocator)entry.getKey();
            try {
                this.parseInhabitants(newModule, name, serviceLocator, new ArrayList<PopulatorPostProcessor>());
            }
            catch (Exception e) {
                throw new RuntimeException("Not able to parse inhabitants information");
            }
        }
    }

    private void removeShutdownLocators() {
        for (Map<ServiceLocator, List<ActiveDescriptor>> descriptorsByServiceLocator : this.moduleDescriptors.values()) {
            HashSet<ServiceLocator> keys = new HashSet<ServiceLocator>(descriptorsByServiceLocator.keySet());
            for (ServiceLocator key : keys) {
                if (!ServiceLocatorState.SHUTDOWN.equals((Object)key.getState())) continue;
                descriptorsByServiceLocator.remove(key);
                this.habitats.remove(key);
            }
        }
    }

    public void remove(Module module) {
        assert (module.getRegistry() == this);
        this.modules.remove(AbstractFactory.getInstance().createModuleId(module.getModuleDefinition()));
        this.removeShutdownLocators();
        Map<ServiceLocator, List<ActiveDescriptor>> descriptorsByServiceLocator = this.moduleDescriptors.get(module);
        if (descriptorsByServiceLocator != null) {
            for (Map.Entry<ServiceLocator, List<ActiveDescriptor>> e : descriptorsByServiceLocator.entrySet()) {
                ServiceLocator sl = e.getKey();
                if (!sl.getState().equals((Object)ServiceLocatorState.RUNNING)) continue;
                List<ActiveDescriptor> descriptors = e.getValue();
                for (ActiveDescriptor descriptor : descriptors) {
                    ServiceLocatorUtilities.removeOneDescriptor(sl, descriptor);
                }
            }
            this.moduleDescriptors.remove(module);
        }
    }

    protected Set<ServiceLocator> getAllServiceLocators() {
        this.removeShutdownLocators();
        return Collections.unmodifiableSet(this.habitats.keySet());
    }

    @Override
    public Collection<Module> getModules() {
        TreeMap<Integer, Repository> repos = new TreeMap<Integer, Repository>();
        repos.putAll(this.repositories);
        Set keys = repos.keySet();
        TreeSet sortedKeys = new TreeSet();
        sortedKeys.addAll(keys);
        for (Integer key : sortedKeys) {
            Repository repo = (Repository)repos.get(key);
            for (ModuleDefinition moduleDef : repo.findAll()) {
                Module newModule;
                if (this.modules.get(AbstractFactory.getInstance().createModuleId(moduleDef)) != null || (newModule = this.newModule(moduleDef)) == null) continue;
                this.add(newModule);
            }
        }
        return this.modules.values();
    }

    @Override
    public Collection<Module> getModules(String moduleName) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module m : this.getModules()) {
            if (!m.getName().equals(moduleName)) continue;
            result.add(m);
        }
        return result;
    }

    @Override
    public void changed(Module service) {
        this.remove(service);
        ModuleDefinition info = service.getModuleDefinition();
        Module newService = this.newModule(info);
        this.add(newService);
    }

    @Override
    public synchronized Module add(ModuleDefinition info) throws ResolveError {
        return this.add(info, true);
    }

    @Override
    public Module add(ModuleDefinition info, boolean resolve) throws ResolveError {
        Module service = this.makeModuleFor(info.getName(), info.getVersion(), resolve);
        if (service == null && (service = this.newModule(info)) != null) {
            this.add(service);
        }
        return service;
    }

    @Override
    public void print(Logger logger2) {
        logger2.info("Modules Registry information : " + this.modules.size() + " modules");
        for (Module module : this.modules.values()) {
            logger2.info(module.getModuleDefinition().getName());
        }
    }

    @Override
    public <T> Iterable<Class<? extends T>> getProvidersClass(final Class<T> serviceClass) {
        return new Iterable<Class<? extends T>>(){

            @Override
            public Iterator<Class<? extends T>> iterator() {
                return new FlattenIterator(new AdapterIterator<Iterator<Class<? extends T>>, Module>(AbstractModulesRegistryImpl.this.getModules().iterator()){

                    @Override
                    protected Iterator<Class<? extends T>> adapt(Module module) {
                        return module.getProvidersClass(serviceClass).iterator();
                    }
                });
            }
        };
    }

    @Override
    public Iterable<Module> getModulesProvider(final Class serviceClass) {
        return new Iterable<Module>(){

            @Override
            public Iterator<Module> iterator() {
                return new AdapterIterator<Module, Module>(AbstractModulesRegistryImpl.this.getModules().iterator()){

                    @Override
                    protected Module adapt(Module m) {
                        if (m.hasProvider(serviceClass)) {
                            return m;
                        }
                        return null;
                    }
                };
            }
        };
    }

    @Override
    public <T> void registerRunningService(Class<T> serviceClass, T provider) {
        CopyOnWriteArrayList existing;
        CopyOnWriteArrayList<T> rs = (CopyOnWriteArrayList<T>)this.runningServices.get(serviceClass);
        if (rs == null && (existing = this.runningServices.putIfAbsent(serviceClass, rs = new CopyOnWriteArrayList<T>())) != null) {
            rs = existing;
        }
        rs.add(provider);
    }

    @Override
    public <T> boolean unregisterRunningService(Class<T> serviceClass, T provider) {
        CopyOnWriteArrayList rs = (CopyOnWriteArrayList)this.runningServices.get(serviceClass);
        if (rs == null) {
            return false;
        }
        return rs.remove(provider);
    }

    @Override
    public <T> List<T> getRunningServices(Class<T> serviceClass) {
        List r = (List)this.runningServices.get(serviceClass);
        if (r != null) {
            return r;
        }
        return Collections.emptyList();
    }

    @Override
    public Module getProvidingModule(String providerClassName) {
        return this.providers.get(providerClassName);
    }

    @Override
    public void dumpState(PrintStream writer) {
        StringBuilder sb = new StringBuilder("Registry Info:: Total repositories: " + this.repositories.size() + ", Total modules = " + this.modules.size() + "\n");
        for (Repository repo : this.repositories.values()) {
            sb.append("Attached repository: [" + repo + "]\n");
        }
        for (Module module : this.getModules()) {
            sb.append("Registered Module: [" + module + "]\n");
        }
        writer.println(sb);
    }
}

