/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.osgi.EmbeddedOSGiGlassFishRuntime;
import com.sun.enterprise.glassfish.bootstrap.osgi.EmbeddedOSGiGlassFishRuntimeBuilder;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class GlassFishMainActivator
implements BundleActivator {
    private BundleContext context;
    private String installRoot;
    private GlassFishRuntime gfr;
    private GlassFish gf;
    private static final String[] DEFAULT_INSTALLATION_LOCATIONS_RELATIVE = new String[]{"modules/endorsed/", "modules/", "modules/autostart/"};
    private static final String[] DEFAULT_START_LOCATIONS_RELATIVE = new String[]{"modules/endorsed/", "modules/osgi-resource-locator.jar", "modules/osgi-adapter.jar", "modules/autostart/"};
    private boolean nonEmbedded;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.nonEmbedded = this.isNonEmbedded();
        if (this.nonEmbedded) {
            EmbeddedOSGiGlassFishRuntime embeddedGfr = new EmbeddedOSGiGlassFishRuntime(context);
            context.registerService(GlassFishRuntime.class.getName(), (Object)embeddedGfr, null);
            System.out.println("Registered " + embeddedGfr + " in service registry.");
        } else {
            Properties properties = this.prepareStartupContext(context);
            BootstrapProperties bsProperties = new BootstrapProperties(properties);
            System.out.println(GlassFishRuntime.class + " is loaded by [" + GlassFishRuntime.class.getClassLoader() + "]");
            GlassFishRuntime existingGfr = this.lookupGfr();
            if (existingGfr == null) {
                System.out.println("Bootstrapping a new GlassFishRuntime");
                existingGfr = this.gfr = GlassFishRuntime.bootstrap(bsProperties, this.getClass().getClassLoader());
            } else {
                System.out.println("Using existing GlassFishRuntime: [" + existingGfr + "]");
            }
            this.gf = existingGfr.newGlassFish(new GlassFishProperties(properties));
            this.gf.start();
        }
    }

    private GlassFishRuntime lookupGfr() {
        ServiceReference serviceReference = this.context.getServiceReference(GlassFishRuntime.class.getName());
        return serviceReference != null ? (GlassFishRuntime)this.context.getService(serviceReference) : null;
    }

    private boolean isNonEmbedded() {
        return this.context.getProperty("GlassFish.BUILDER_NAME") != null;
    }

    private Properties prepareStartupContext(BundleContext context) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        for (String key : properties.stringPropertyNames()) {
            String value = context.getProperty(key);
            if (value == System.getProperty(key)) continue;
            properties.setProperty(key, value);
        }
        this.installRoot = context.getProperty("com.sun.aas.installRoot");
        if (this.installRoot == null) {
            this.installRoot = this.guessInstallRoot(context);
            if (this.installRoot == null) {
                throw new RuntimeException("Property named com.sun.aas.installRoot is not set.");
            }
            System.out.println("Deduced install root as : " + this.installRoot + " from location of bundle. " + "If this is not correct, set correct value in a property called " + "com.sun.aas.installRoot");
        }
        if (!new File(this.installRoot).exists()) {
            throw new RuntimeException("No such directory: [" + this.installRoot + "]");
        }
        properties.setProperty("com.sun.aas.installRoot", this.installRoot);
        String instanceRoot = context.getProperty("com.sun.aas.instanceRoot");
        if (instanceRoot == null) {
            instanceRoot = new File(this.installRoot, "domains/domain1/").getAbsolutePath();
        }
        properties.setProperty("com.sun.aas.instanceRoot", instanceRoot);
        properties.putAll((Map<?, ?>)this.makeProvisioningOptions());
        properties.setProperty("GlassFish.BUILDER_NAME", EmbeddedOSGiGlassFishRuntimeBuilder.class.getName());
        return properties;
    }

    private String guessInstallRoot(BundleContext context) {
        String location = context.getBundle().getLocation();
        try {
            URI uri = URI.create(location);
            File f = new File(uri);
            if (f.exists() && f.isFile() && f.getParentFile().getCanonicalPath().endsWith("modules")) {
                return f.getParentFile().getParentFile().getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Properties makeProvisioningOptions() {
        Properties provisioningOptions = new Properties();
        URI installURI = new File(this.installRoot).toURI();
        String installLocations = this.getBundleContext().getProperty("glassfish.osgi.auto.install");
        if (installLocations == null) {
            StringBuilder defaultInstallLocations = new StringBuilder();
            for (String entry : DEFAULT_INSTALLATION_LOCATIONS_RELATIVE) {
                defaultInstallLocations.append(installURI.resolve(entry).toString()).append(" ");
            }
            installLocations = defaultInstallLocations.toString();
        }
        provisioningOptions.setProperty("glassfish.osgi.auto.install", installLocations);
        String startLocations = this.getBundleContext().getProperty("glassfish.osgi.auto.start");
        if (startLocations == null) {
            StringBuilder deafultStartLocations = new StringBuilder();
            for (String entry : DEFAULT_START_LOCATIONS_RELATIVE) {
                deafultStartLocations.append(installURI.resolve(entry).toString()).append(" ");
            }
            startLocations = deafultStartLocations.toString();
        }
        provisioningOptions.setProperty("glassfish.osgi.auto.start", startLocations);
        System.out.println("Provisioning options are " + provisioningOptions);
        return provisioningOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        if (this.nonEmbedded) {
            System.out.println("We are in non-embedded mode, so " + context.getBundle() + " has nothing to do.");
            return;
        }
        try {
            if (this.gf != null && this.gf.getStatus() != GlassFish.Status.DISPOSED) {
                this.gf.dispose();
            }
        }
        finally {
            this.gf = null;
        }
        if (this.gfr != null) {
            this.gfr.shutdown();
            this.gfr = null;
        }
    }

    private BundleContext getBundleContext() {
        return this.context;
    }
}

