/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.DefaultAnnotationScanner;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.inject.Inject;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.JavaEEScanner;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

public abstract class ModuleScanner<T>
extends JavaEEScanner
implements Scanner<T> {
    private static final int DEFAULT_ENTRY_BUFFER_SIZE = 8192;
    @Inject
    DefaultAnnotationScanner defaultScanner;
    protected File archiveFile = null;
    protected ClassLoader classLoader = null;
    protected Parser classParser = null;
    private Set<URI> scannedURI = new HashSet<URI>();
    private boolean needScanAnnotation = false;
    private static ExecutorService executorService = null;
    private Set<String> entries = new HashSet<String>();
    public static final Logger deplLogger = DOLUtils.deplLogger;
    private static final String ANNOTATION_SCANNING_EXCEPTION = "AS-DEPLOYMENT-00005";
    private static final String ANNOTATION_ADDED = "AS-DEPLOYMENT-00006";
    private static final String INTERFACE_ADDED = "AS-DEPLOYMENT-00007";
    private static final String INCORRECT_ANNOTATION = "AS-DEPLOYMENT-00008";
    private static final String JAR_EXCEPTION = "AS-DEPLOYMENT-00009";
    private static final String NO_CLASSLOADER = "AS-DEPLOYMENT-00010";
    private static final String ANNOTATION_ERROR = "AS-DEPLOYMENT-00011";
    private static final String CLASSLOADING_ERROR = "AS-DEPLOYMENT-00012";
    private static final String LIBRARY_JAR_ERROR = "AS-DEPLOYMENT-00013";

    public void process(ReadableArchive archiveFile, T bundleDesc, ClassLoader classLoader, Parser parser) throws IOException {
        File file = new File(archiveFile.getURI());
        this.setParser(parser);
        this.process(file, bundleDesc, classLoader);
        this.completeProcess(bundleDesc, archiveFile);
        this.calculateResults();
    }

    protected void completeProcess(T bundleDescr, ReadableArchive archive) throws IOException {
        this.addLibraryJars(bundleDescr, archive);
    }

    protected void calculateResults() {
        try {
            this.classParser.awaitTermination();
        }
        catch (InterruptedException e) {
            deplLogger.log(Level.SEVERE, ANNOTATION_SCANNING_EXCEPTION, e);
            return;
        }
        Level logLevel = System.getProperty("glassfish.deployment.dump.scanning") != null ? Level.INFO : Level.FINE;
        boolean shouldLog = deplLogger.isLoggable(logLevel);
        ParsingContext context = this.classParser.getContext();
        for (String annotation : this.defaultScanner.getAnnotations()) {
            Type type2 = context.getTypes().getBy(annotation);
            if (type2 == null) continue;
            if (type2 instanceof AnnotationType) {
                AnnotationType at = (AnnotationType)type2;
                for (AnnotatedElement ae : at.allAnnotatedTypes()) {
                    ExtensibleType<?> t = ae instanceof Member ? ((Member)((Object)ae)).getDeclaringType() : (ExtensibleType<?>)ae;
                    if (!t.wasDefinedIn(this.scannedURI)) continue;
                    if (shouldLog) {
                        if (Level.INFO.equals(logLevel)) {
                            deplLogger.log(Level.INFO, ANNOTATION_ADDED, new Object[]{t.getName(), ae.getName(), at.getName()});
                        } else {
                            deplLogger.log(Level.FINE, "Adding " + t.getName() + " since " + ae.getName() + " is annotated with " + at.getName());
                        }
                    }
                    this.entries.add(t.getName());
                }
                continue;
            }
            if (type2 instanceof InterfaceModel) {
                InterfaceModel im = (InterfaceModel)type2;
                for (ClassModel cm : im.allImplementations()) {
                    if (shouldLog) {
                        if (Level.INFO.equals(logLevel)) {
                            deplLogger.log(Level.INFO, INTERFACE_ADDED, new Object[]{cm.getName(), im.getName()});
                        } else {
                            deplLogger.log(Level.FINE, "Adding " + cm.getName() + " since it is implementing " + im.getName());
                        }
                    }
                    this.entries.add(cm.getName());
                }
                continue;
            }
            deplLogger.log(Level.SEVERE, INCORRECT_ANNOTATION, annotation);
        }
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.log(Level.FINE, "Done with results");
        }
    }

    protected void addScanClassName(String className) {
        if (className != null && className.length() != 0) {
            this.entries.add(className);
        }
    }

    protected void addScanJar(File jarFile) throws IOException {
        try {
            if (!jarFile.exists()) {
                return;
            }
            this.scannedURI.add(jarFile.toURI());
            if (this.needScanAnnotation) {
                this.classParser.parse(jarFile, null);
            }
        }
        catch (ZipException ze) {
            deplLogger.log(Level.WARNING, JAR_EXCEPTION, new Object[]{ze.getMessage(), jarFile.getPath()});
        }
    }

    protected void addScanURI(URI jarURI) throws IOException {
        this.addScanJar(new File(jarURI));
    }

    protected void addScanDirectory(File directory) throws IOException {
        this.scannedURI.add(directory.toURI());
        if (this.needScanAnnotation) {
            this.classParser.parse(directory, null);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Set<Class> getElements() {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            deplLogger.log(Level.SEVERE, NO_CLASSLOADER);
            return elements;
        }
        for (String className : this.entries) {
            if (deplLogger.isLoggable(Level.FINE)) {
                deplLogger.fine("Getting " + className);
            }
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (NoClassDefFoundError err) {
                deplLogger.log(Level.WARNING, ANNOTATION_ERROR, err);
            }
            catch (ClassNotFoundException cnfe) {
                LogRecord lr = new LogRecord(Level.WARNING, CLASSLOADING_ERROR);
                Object[] args = new Object[]{className, cnfe.getMessage()};
                lr.setParameters(args);
                lr.setThrown(cnfe);
                deplLogger.log(lr);
            }
        }
        return elements;
    }

    protected void addLibraryJars(T bundleDesc, ReadableArchive moduleArchive) {
        List<Object> libraryURIs = new ArrayList();
        try {
            if (bundleDesc instanceof BundleDescriptor) {
                libraryURIs = DOLUtils.getLibraryJarURIs((BundleDescriptor)bundleDesc, moduleArchive);
            }
            for (URI uri : libraryURIs) {
                File libFile = new File(uri);
                if (libFile.isFile()) {
                    this.addScanJar(libFile);
                    continue;
                }
                if (!libFile.isDirectory()) continue;
                this.addScanDirectory(libFile);
            }
        }
        catch (Exception ex) {
            deplLogger.log(Level.WARNING, LIBRARY_JAR_ERROR, ex.getMessage());
        }
    }

    @Override
    public Types getTypes() {
        return this.classParser.getContext().getTypes();
    }

    protected synchronized ExecutorService getExecutorService() {
        if (executorService != null) {
            return executorService;
        }
        Runtime runtime = Runtime.getRuntime();
        int nrOfProcessors = runtime.availableProcessors();
        executorService = Executors.newFixedThreadPool(nrOfProcessors, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("dol-jar-scanner");
                t.setDaemon(true);
                t.setContextClassLoader(this.getClass().getClassLoader());
                return t;
            }
        });
        return executorService;
    }

    protected void setParser(Parser parser) {
        if (parser == null) {
            ParsingContext pc = new ParsingContext.Builder().logger(deplLogger).executorService(this.getExecutorService()).build();
            parser = new Parser(pc);
            this.needScanAnnotation = true;
        }
        this.classParser = parser;
    }
}

