/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.connectors.deployment.annotation.handlers.ConnectorResourceDefinitionHandler;
import com.sun.enterprise.deployment.ConnectorResourceDefinitionDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.resource.ConnectorResourceDefinition;
import javax.resource.ConnectorResourceDefinitions;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ConnectorResourceDefinitions.class)
public class ConnectorResourceDefinitionsHandler
extends AbstractResourceHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorResourceDefinitionsHandler.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        ConnectorResourceDefinitions defns = (ConnectorResourceDefinitions)ainfo.getAnnotation();
        ConnectorResourceDefinition[] values = defns.value();
        HashSet<String> duplicates = new HashSet<String>();
        if (values != null && values.length > 0) {
            for (ConnectorResourceDefinition defn : values) {
                String defnName = ConnectorResourceDefinitionDescriptor.getJavaName(defn.name());
                if (duplicates.contains(defnName)) {
                    String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.connectorresourcedefinitionsduplicates", "@ConnectorResourceDefinitions cannot have multiple definitions with same name : '{0}'", defnName);
                    throw new IllegalStateException(localString);
                }
                duplicates.add(defnName);
                ConnectorResourceDefinitionHandler handler = new ConnectorResourceDefinitionHandler();
                handler.processAnnotation(defn, ainfo, rcContexts);
            }
            duplicates.clear();
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }
}

