/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.api.monitoring.MonitoringItem;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface MonitoringService
extends ConfigExtension,
PropertyBag {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MonitoringService.class);

    @Element
    @NotNull
    public ModuleMonitoringLevels getModuleMonitoringLevels();

    public void setModuleMonitoringLevels(ModuleMonitoringLevels var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getMbeanEnabled();

    public void setMbeanEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getMonitoringEnabled();

    public void setMonitoringEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getDtraceEnabled();

    public void setDtraceEnabled(String var1) throws PropertyVetoException;

    @Element
    public List<ContainerMonitoring> getContainerMonitoring();

    @Element(value="*")
    public List<MonitoringItem> getMonitoringItems();

    @DuckTyped
    public ContainerMonitoring getContainerMonitoring(String var1);

    @DuckTyped
    public String getMonitoringLevel(String var1);

    @DuckTyped
    public void setMonitoringLevel(String var1, String var2);

    public static class Duck {
        private static final List<String> getMethods = new ArrayList<String>();
        private static final List<String> setMethods = new ArrayList<String>();

        public static ContainerMonitoring getContainerMonitoring(MonitoringService ms, String name) {
            for (ContainerMonitoring cm : ms.getContainerMonitoring()) {
                if (!cm.getName().equals(name)) continue;
                return cm;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getMonitoringLevel(MonitoringService ms, String name) {
            String level = null;
            List<String> list = getMethods;
            synchronized (list) {
                if (getMethods.isEmpty()) {
                    for (Method method : ModuleMonitoringLevels.class.getDeclaredMethods()) {
                        String str = method.getName();
                        if (!str.startsWith("get")) continue;
                        getMethods.add(str);
                    }
                }
            }
            String rName = name.replaceAll("-", "");
            for (String methodName : getMethods) {
                if (!rName.equalsIgnoreCase(methodName.substring(3))) continue;
                try {
                    Method mthd = ModuleMonitoringLevels.class.getMethod(methodName, null);
                    level = (String)mthd.invoke((Object)ms.getModuleMonitoringLevels(), (Object[])null);
                }
                catch (NoSuchMethodException nsme) {
                    Logger.getAnonymousLogger().log(Level.WARNING, nsme.getMessage(), nsme);
                }
                catch (IllegalAccessException ile) {
                    Logger.getAnonymousLogger().log(Level.WARNING, ile.getMessage(), ile);
                }
                catch (InvocationTargetException ite) {
                    Logger.getAnonymousLogger().log(Level.WARNING, ite.getMessage(), ite);
                }
                break;
            }
            if (level != null) {
                return level;
            }
            for (ContainerMonitoring cm : ms.getContainerMonitoring()) {
                if (!cm.getName().equals(name)) continue;
                return cm.getLevel();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean setMonitoringLevel(MonitoringService ms, String name, String level) throws PropertyVetoException, TransactionFailure {
            boolean isLevelUpdated = false;
            List<String> list = setMethods;
            synchronized (list) {
                if (setMethods.isEmpty()) {
                    for (Method method : ModuleMonitoringLevels.class.getDeclaredMethods()) {
                        String str = method.getName();
                        if (!str.startsWith("set")) continue;
                        setMethods.add(str);
                    }
                }
            }
            String rName = name.replaceAll("-", "");
            for (String methodName : setMethods) {
                if (!rName.equalsIgnoreCase(methodName.substring(3))) continue;
                try {
                    Method mthd = ModuleMonitoringLevels.class.getMethod(methodName, String.class);
                    Transaction tx = Transaction.getTransaction(ms);
                    if (tx == null) {
                        throw new TransactionFailure(localStrings.getLocalString("noTransaction", "Internal Error - Cannot obtain transaction object"));
                    }
                    ModuleMonitoringLevels mml = tx.enroll(ms.getModuleMonitoringLevels());
                    mthd.invoke((Object)mml, level);
                    isLevelUpdated = true;
                }
                catch (NoSuchMethodException nsme) {
                    Logger.getAnonymousLogger().log(Level.WARNING, nsme.getMessage(), nsme);
                }
                catch (IllegalAccessException ile) {
                    Logger.getAnonymousLogger().log(Level.WARNING, ile.getMessage(), ile);
                }
                catch (InvocationTargetException ite) {
                    Logger.getAnonymousLogger().log(Level.WARNING, ite.getMessage(), ite);
                }
                break;
            }
            if (!isLevelUpdated) {
                for (ContainerMonitoring cm : ms.getContainerMonitoring()) {
                    if (!cm.getName().equals(name)) continue;
                    cm.setLevel(level);
                    isLevelUpdated = true;
                }
            }
            return isLevelUpdated;
        }
    }
}

