/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.customization;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.annotation.HasCustomizationTokens;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.customization.ConfigCustomizationToken;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceLocator;

public class CustomizationTokensProvider {
    private static final Logger LOG = Logger.getLogger(CustomizationTokensProvider.class.getName());
    private static final LocalStringManager strings = new LocalStringManagerImpl(CustomizationTokensProvider.class);
    private ServiceLocator locator;
    ConfigModularityUtils mu;

    public List<ConfigCustomizationToken> getPresentConfigCustomizationTokens() throws NoSuchFieldException, IllegalAccessException {
        String runtimeType = "admin";
        this.initializeLocator();
        this.mu = this.locator.getService(ConfigModularityUtils.class, new Annotation[0]);
        List<Class> l = this.mu.getAnnotatedConfigBeans(HasCustomizationTokens.class);
        ArrayList<ConfigCustomizationToken> ctk = new ArrayList<ConfigCustomizationToken>();
        HashSet<Class> s = new HashSet<Class>();
        for (Class cls : l) {
            if (s.contains(cls)) continue;
            ctk.addAll(this.getTokens(cls, runtimeType));
            s.add(cls);
        }
        return ctk;
    }

    private List<ConfigCustomizationToken> getTokens(Class configBean, String runtimeType) {
        ArrayList<ConfigCustomizationToken> ctk = new ArrayList<ConfigCustomizationToken>();
        List<ConfigBeanDefaultValue> defaultValues = this.mu.getDefaultConfigurations(configBean, runtimeType);
        for (ConfigBeanDefaultValue def : defaultValues) {
            ctk.addAll(def.getCustomizationTokens());
        }
        return ctk;
    }

    protected void initializeLocator() {
        final ClassLoader ecl = CustomizationTokensProvider.class.getClassLoader();
        File inst = new File(System.getProperty("com.sun.aas.installRoot"));
        final File ext = new File(inst, "modules");
        LOG.log(Level.FINE, "asadmin modules directory: {0}", ext);
        if (ext.isDirectory()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        URLClassLoader pl = new URLClassLoader(CustomizationTokensProvider.getJars(ext));
                        StaticModulesRegistry registry = new StaticModulesRegistry(pl);
                        CustomizationTokensProvider.this.locator = registry.createServiceLocator("default");
                        return pl;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, strings.getLocalString("modules.class.loader.failed", "Failed to create a classloader for modules directory"), ex);
                        return ecl;
                    }
                }
            });
        } else {
            LOG.log(Level.FINER, "Modules directory does not exist");
        }
    }

    private static URL[] getJars(File dir2) throws IOException {
        File[] fjars = dir2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                return name.endsWith(".jar");
            }
        });
        if (fjars == null) {
            throw new IOException("No Jar Files in the Modules Directory!");
        }
        URL[] jars = new URL[fjars.length];
        for (int i = 0; i < fjars.length; ++i) {
            jars[i] = fjars[i].toURI().toURL();
        }
        return jars;
    }
}

