/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.command;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.annotation.CustomConfiguration;
import com.sun.enterprise.config.modularity.command.AbstractConfigModularityCommand;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.customization.ConfigCustomizationToken;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-module-config")
@PerLookup
@I18n(value="create.module.config")
public final class CreateModuleConfigCommand
extends AbstractConfigModularityCommand
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private final Logger LOG = Logger.getLogger(CreateModuleConfigCommand.class.getName());
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateModuleConfigCommand.class);
    @Inject
    private ConfigModularityUtils configModularityUtils;
    @Inject
    private Domain domain;
    @Inject
    ServiceLocator serviceLocator;
    @Param(optional=true, defaultValue="false", name="dryRun")
    private Boolean dryRun;
    @Param(optional=true, defaultValue="false", name="all")
    private Boolean isAll;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServerEnvironmentImpl serverenv;
    @Param(optional=true, name="serviceName", primary=true)
    private String serviceName;

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(AdminCommandContext context) {
        report = context.getActionReport();
        if (this.target != null) {
            newConfig = this.getConfigForName(this.target, this.serviceLocator, this.domain);
            if (newConfig != null) {
                this.config = newConfig;
            }
            if (this.config == null) {
                report.setMessage(CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.target.name.invalid", "The target name you specified is invalid. Please double check the target name and try again"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.isAll.booleanValue() && this.serviceName != null) {
            report.setMessage(CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.service.name.ignored", "You can only use --all or specify a service name. These two options are exclusive."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.isAll.booleanValue() && this.serviceName == null) {
            report.setMessage(CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.no.service.no.all", "As no service name specified and the --all is not used either. Showing all default configurations not merged with domain configuration under target {0}.", new Object[]{this.target}));
            try {
                defaultConfigurationElements = this.getAllDefaultConfigurationElements(this.target);
                if (defaultConfigurationElements == null) ** GOTO lbl79
                report.setMessage(defaultConfigurationElements);
            }
            catch (Exception e) {
                msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.failure", "Failed to execute the command due to {0}. For more details check the log file.", new Object[]{e.getLocalizedMessage()});
                this.LOG.log(Level.INFO, msg, e);
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
                return;
            }
        } else if (this.isAll.booleanValue() && this.dryRun.booleanValue()) {
            report.setMessage(CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.show.all", "Showing all default configurations not merged with domain configuration under target {0}.", new Object[]{this.target}));
            try {
                defaultConfigurationElements = this.getAllDefaultConfigurationElements(this.target);
                if (defaultConfigurationElements == null) ** GOTO lbl79
                report.setMessage(defaultConfigurationElements);
            }
            catch (Exception e) {
                msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.show.all.failed", "Failed to show all default configurations not merged with domain configuration under target {0} due to {1}.", new Object[]{this.target, e.getLocalizedMessage()});
                this.LOG.log(Level.INFO, msg, e);
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
                return;
            }
        } else {
            if (this.isAll.booleanValue() && !this.dryRun.booleanValue()) {
                report.appendMessage(CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.creating.all", "Creating all default configuration elements that are not present in the domain.xml under target {0}.", new Object[]{this.target}));
                report.appendMessage(CreateModuleConfigCommand.LINE_SEPARATOR);
                try {
                    this.createAllMissingElements(report);
                }
                catch (Exception e) {
                    msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.creating.all.failed", "Failed to create all default configuration elements that are not present in the domain.xml under target {0} due to {1}.", new Object[]{this.target, e.getLocalizedMessage()});
                    this.LOG.log(Level.INFO, msg, e);
                    report.setMessage(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setFailureCause(e);
                    return;
                }
            }
            if (this.serviceName != null) {
                className = this.configModularityUtils.convertConfigElementNameToClassName(this.serviceName);
                configBeanType = this.configModularityUtils.getClassFor(this.serviceName);
                if (configBeanType == null) {
                    msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.not.such.a.service.found", "A ConfigBean of type {0} which translates to your service name\\'s configuration elements does not exist.", new Object[]{className, this.serviceName});
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                try {
                    if (this.dryRun.booleanValue()) {
                        serviceDefaultConfig = this.getDefaultConfigFor(configBeanType);
                        if (serviceDefaultConfig != null) {
                            report.setMessage(serviceDefaultConfig);
                        }
                    } else {
                        this.createMissingElementFor(configBeanType, report);
                    }
                }
                catch (Exception e) {
                    msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.creating.for.service.name.failed", "Failed to create module configuration for {0} under the target {1} due to {2}.", new Object[]{this.serviceName, this.target, e.getMessage()});
                    this.LOG.log(Level.INFO, msg, e);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    report.setFailureCause(e);
                    return;
                }
            }
        }
lbl79:
        // 9 sources

        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean createMissingElementFor(Class configBeanType, ActionReport report) throws Exception {
        boolean defaultConfigCreated = false;
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            if (this.config.checkIfExtensionExists(configBeanType)) {
                report.appendMessage(localStrings.getLocalString("create.module.config.already.exists", "Configuration for {0} already exists. The command didn't change the existing configuration.", Dom.convertName(configBeanType.getSimpleName())));
                report.appendMessage(LINE_SEPARATOR);
                return false;
            }
            this.config.getExtensionByType(configBeanType);
            report.appendMessage(localStrings.getLocalString("create.module.config.done", "Configuration for {0} added to domain.xml", Dom.convertName(configBeanType.getSimpleName())));
            report.appendMessage(LINE_SEPARATOR);
            defaultConfigCreated = true;
        } else if (configBeanType.isAssignableFrom(DomainExtension.class)) {
            if (this.domain.checkIfExtensionExists(configBeanType)) {
                report.appendMessage(localStrings.getLocalString("create.module.config.already.exists", "Configuration for {0} already exists. The command didn't change the existing configuration.", Dom.convertName(configBeanType.getSimpleName())));
                report.appendMessage(LINE_SEPARATOR);
                return false;
            }
            this.domain.getExtensionByType(configBeanType);
            report.appendMessage(localStrings.getLocalString("create.module.config.done", "Configuration for {0} added to domain.xml", Dom.convertName(configBeanType.getSimpleName())));
            report.appendMessage(LINE_SEPARATOR);
            defaultConfigCreated = true;
        }
        return defaultConfigCreated;
    }

    private String getDefaultConfigFor(Class configBeanType) throws Exception {
        if (!this.configModularityUtils.hasCustomConfig(configBeanType)) {
            return this.configModularityUtils.serializeConfigBeanByType(configBeanType);
        }
        List<ConfigBeanDefaultValue> defaults = this.configModularityUtils.getDefaultConfigurations(configBeanType, this.configModularityUtils.getRuntimeTypePrefix(this.serverenv.getStartupContext()));
        StringBuilder builder = new StringBuilder();
        for (ConfigBeanDefaultValue value : defaults) {
            builder.append(localStrings.getLocalString("at.location", "At Location: "));
            builder.append(this.replaceExpressionsWithValues(value.getLocation()));
            String substituted = this.replacePropertiesWithDefaultValues(value.getCustomizationTokens(), value.getXmlConfiguration());
            builder.append(substituted);
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private String replacePropertiesWithDefaultValues(List<ConfigCustomizationToken> tokens, String xmlConfig) {
        for (ConfigCustomizationToken token : tokens) {
            String toReplace = "\\$\\{" + token.getKey() + "\\}";
            xmlConfig = xmlConfig.replaceAll(toReplace, token.getDefaultValue());
        }
        return xmlConfig;
    }

    private void createAllMissingElements(ActionReport report) throws Exception {
        List<Class> clzs = this.configModularityUtils.getAnnotatedConfigBeans(CustomConfiguration.class);
        for (Class clz : clzs) {
            this.createMissingElementFor(clz, report);
        }
    }

    private String getAllDefaultConfigurationElements(String target) throws Exception {
        List<Class> clzs = this.configModularityUtils.getAnnotatedConfigBeans(CustomConfiguration.class);
        StringBuilder sb = new StringBuilder();
        for (Class clz : clzs) {
            sb.append(this.getDefaultConfigFor(clz));
        }
        return sb.toString();
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        Class configBeanType = this.configModularityUtils.getClassFor(this.serviceName);
        if (configBeanType == null) {
            return Collections.emptyList();
        }
        if (this.configModularityUtils.hasCustomConfig(configBeanType)) {
            List<ConfigBeanDefaultValue> defaults = this.configModularityUtils.getDefaultConfigurations(configBeanType, this.configModularityUtils.getRuntimeTypePrefix(this.serverenv.getStartupContext()));
            return this.getAccessChecksForDefaultValue(defaults, this.target, Arrays.asList("read", "create", "delete"));
        }
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            return this.getAccessChecksForConfigBean((ConfigBeanProxy)this.config.getExtensionByType(configBeanType), this.target, Arrays.asList("read", "create", "delete"));
        }
        if (configBeanType.isAssignableFrom(DomainExtension.class)) {
            return this.getAccessChecksForConfigBean((ConfigBeanProxy)this.config.getExtensionByType(configBeanType), this.target, Arrays.asList("read", "create", "delete"));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        return true;
    }
}

