/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Singleton
@Service
public class ConfigModularityJustInTimeInjectionResolver
implements JustInTimeInjectionResolver {
    private static final Logger LOG = Logger.getLogger(ConfigModularityJustInTimeInjectionResolver.class.getName());
    @Inject
    private DynamicConfigurationService dcs;
    @Inject
    private ServiceLocator locator;
    @Inject
    private Config config;
    @Inject
    private Domain domain;
    private static final List<String> supportedTypes = new ArrayList<String>();

    public ConfigModularityJustInTimeInjectionResolver() {
        supportedTypes.add("com.sun.enterprise.connectors.jms.config.JmsService");
        supportedTypes.add("org.glassfish.ejb.config.EjbContainer");
        supportedTypes.add("org.glassfish.web.config.serverbeans.WebContainer");
        supportedTypes.add("org.glassfish.orb.admin.config.IiopService");
        supportedTypes.add("com.sun.enterprise.config.serverbeans.ManagedJobConfig");
        supportedTypes.add("org.glassfish.paas.maintenance.configbeans.PatchingServiceConfig");
        supportedTypes.add("org.glassfish.paas.sdp.config.ServiceDefinitionPackages");
    }

    @Override
    public boolean justInTimeResolution(Injectee injectee) {
        Class configBeanType;
        if (injectee == null || injectee.isOptional()) {
            return false;
        }
        try {
            configBeanType = (Class)injectee.getRequiredType();
        }
        catch (Exception ex) {
            return false;
        }
        if (!ConfigExtension.class.isAssignableFrom(configBeanType) && !DomainExtension.class.isAssignableFrom(configBeanType)) {
            return false;
        }
        if (!this.isInjectionSupported(configBeanType)) {
            return false;
        }
        if (this.domain == null) {
            return false;
        }
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            Object pr;
            if (this.config == null) {
                this.config = this.locator.getService(Config.class, "default-instance-name", new Annotation[0]);
            }
            return (pr = this.config.getExtensionByType(configBeanType)) != null;
        }
        if (DomainExtension.class.isAssignableFrom(configBeanType)) {
            Object pr = this.domain.getExtensionByType(configBeanType);
            return pr != null;
        }
        return false;
    }

    private boolean isInjectionSupported(Class c) {
        return supportedTypes.contains(c.getName());
    }
}

