/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;

public class BackupRequest {
    static final String[] excludeDirs = new String[]{"backups/", "osgi-cache/"};
    File domainsDir;
    String domainName;
    String description;
    int recycleLimit = 0;
    File backupDir = null;
    String backupConfig = null;
    boolean configOnly = false;
    File backupFile;
    File domainDir;
    long timestamp;
    boolean terse = false;
    boolean verbose = false;
    boolean force = false;

    public BackupRequest(String domainsDirName, String domain, File backupDir, String backupConfig, boolean configonly) {
        this.setDomainsDir(domainsDirName);
        this.setBackupDir(backupDir);
        this.setBackupConfig(backupConfig);
        this.domainName = domain;
        this.configOnly = configonly;
    }

    public BackupRequest(String domainsDirName, String domain, File backupDir, String backupConfig, String desc, int limit, boolean configonly) {
        this(domainsDirName, domain, backupDir, backupConfig, configonly);
        this.setDescription(desc);
        this.setRecycleLimit(limit);
    }

    public BackupRequest(String domainsDirName, String domain, File backupDir, String backupConfig, String backupFileName, boolean configonly) {
        this(domainsDirName, domain, backupDir, backupConfig, configonly);
        if (backupFileName != null) {
            this.setBackupFile(backupFileName);
        }
    }

    public void setTerse(boolean b) {
        this.terse = b;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }

    public void setForce(boolean f) {
        this.force = f;
    }

    private void setDomainsDir(String name) {
        this.domainsDir = FileUtils.safeGetCanonicalFile(new File(name));
    }

    private void setBackupDir(File dir2) {
        this.backupDir = dir2;
    }

    private void setRecycleLimit(int limit) {
        this.recycleLimit = limit;
    }

    private void setDescription(String desc) {
        this.description = desc;
    }

    private void setBackupFile(String name) {
        this.backupFile = FileUtils.safeGetCanonicalFile(new File(name));
    }

    private void setBackupConfig(String name) {
        this.backupConfig = name;
    }
}

