/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutionException;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.StringsubsDefinition;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StringSubstitutionParser {
    private static final Logger _logger = Logger.getLogger(StringSubstitutionParser.class.getPackage().getName());
    private static final LocalStringsImpl _strings = new LocalStringsImpl(StringSubstitutionParser.class);
    private static final String DEFAULT_SCHEMA = "xsd/schema/stringsubs.xsd";

    public static StringsubsDefinition parse(InputStream configStream) throws StringSubstitutionException {
        if (configStream == null) {
            throw new StringSubstitutionException(_strings.get("invalidStream"));
        }
        try {
            URL schemaUrl = StringSubstitutionParser.class.getClassLoader().getResource(DEFAULT_SCHEMA);
            JAXBContext context = JAXBContext.newInstance(StringsubsDefinition.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaUrl);
            unmarshaller.setSchema(schema);
            InputSource is = new InputSource(configStream);
            SAXSource source = new SAXSource(is);
            Object obj = unmarshaller.unmarshal(source);
            StringsubsDefinition stringsubsDefinition = obj instanceof JAXBElement ? (StringsubsDefinition)((JAXBElement)obj).getValue() : (StringsubsDefinition)obj;
            return stringsubsDefinition;
        }
        catch (SAXException se) {
            throw new StringSubstitutionException(_strings.get("failedToParse", DEFAULT_SCHEMA), se);
        }
        catch (JAXBException jaxbe) {
            throw new StringSubstitutionException(_strings.get("failedToParse", DEFAULT_SCHEMA), jaxbe);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                    configStream = null;
                }
                catch (IOException e) {
                    _logger.log(Level.FINER, _strings.get("errorInClosingStream"));
                }
            }
        }
    }
}

