/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.DomainXmlEventListener;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.RepositoryNameValidator;
import com.sun.enterprise.admin.servermgmt.pe.IndexHtmlTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEAccXmlTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainConfigValidator;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainXmlTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.servermgmt.pe.PEScriptsTokens;
import com.sun.enterprise.admin.servermgmt.util.DomainXmlSAXParser;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Locale;
import java.util.Map;

public class PEDomainsManager
extends RepositoryManager
implements DomainsManager {
    private static final StringManager strMgr = StringManager.getManager(PEDomainsManager.class);
    private static final String NAME_DELIMITER = ",";
    public static final String PROFILEPROPERTY_DOMAINXML_STYLESHEETS = "domain.xml.style-sheets";
    public static final String PROFILEPROPERTY_DOMAINXML_TOKENVALUES = "domain.xml.token-values";

    @Override
    public BitSet getDomainFlags() {
        BitSet bs = new BitSet();
        bs.set(1, false);
        return bs;
    }

    @Override
    public void validateDomain(DomainConfig domainConfig, boolean domainExists) throws DomainException {
        try {
            this.checkRepository(domainConfig, domainExists, domainExists);
        }
        catch (RepositoryException ex) {
            throw new DomainException(ex);
        }
    }

    @Override
    public void validateMasterPassword(DomainConfig domainConfig) throws DomainException {
        try {
            this.validateMasterPassword(domainConfig, PEDomainsManager.getMasterPasswordClear(domainConfig));
        }
        catch (RepositoryException ex) {
            throw new DomainException(ex);
        }
    }

    @Override
    public void createDomain(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        try {
            new RepositoryNameValidator(strMgr.getString("domainsRoot")).checkValidXmlToken(layout.getRepositoryRootDir().getAbsolutePath());
            layout.createRepositoryRoot();
            new PEDomainConfigValidator().validate(domainConfig);
            this.checkRepository(domainConfig, false);
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
        try {
            String masterPassword = PEDomainsManager.getMasterPasswordClear(domainConfig);
            layout.createRepositoryDirectories();
            this.createDomainXml(domainConfig);
            this.createDomainXmlEvents(domainConfig);
            this.createServerPolicyFile(domainConfig);
            this.createAdminKeyFile(domainConfig, PEDomainsManager.getDomainUser(domainConfig), PEDomainsManager.getDomainPasswordClear(domainConfig));
            this.createKeyFile(domainConfig, PEDomainsManager.getDomainUser(domainConfig), PEDomainsManager.getDomainPasswordClear(domainConfig));
            this.createAppClientContainerXml(domainConfig);
            this.createIndexFile(domainConfig);
            this.createDefaultWebXml(domainConfig);
            this.createLoginConf(domainConfig);
            this.createWssServerConfig(domainConfig);
            this.createWssServerConfigOld(domainConfig);
            this.createSSLCertificateDatabase(domainConfig, masterPassword);
            this.changeMasterPasswordInMasterPasswordFile(domainConfig, masterPassword, PEDomainsManager.saveMasterPassword(domainConfig));
            this.createPasswordAliasKeystore(domainConfig, masterPassword);
            this.createLoggingProperties(domainConfig);
            this.setPermissions(domainConfig);
        }
        catch (DomainException de) {
            FileUtils.liquidate(this.getDomainDir(domainConfig));
            throw de;
        }
        catch (Exception ex) {
            FileUtils.liquidate(this.getDomainDir(domainConfig));
            throw new DomainException(ex);
        }
    }

    protected void createJBIInstance(String instanceName, DomainConfig domainConfig) throws DomainException {
        try {
            this.getFileLayout(domainConfig).createJBIDomainDirectories();
            super.createJBIInstance(instanceName, domainConfig);
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    protected void setPermissions(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        try {
            this.chmod("-R u+x ", layout.getBinDir());
            this.chmod("-R g-rwx,o-rwx ", layout.getConfigRoot());
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("setPermissionError"), e);
        }
    }

    @Override
    public void deleteDomain(DomainConfig domainConfig) throws DomainException {
        try {
            this.deleteRepository(domainConfig);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    @Override
    public String[] listDomains(DomainConfig domainConfig) throws DomainException {
        try {
            return this.listRepository(domainConfig);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    protected void createDomainXmlEvents(DomainConfig domainConfig) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File domainXml = layout.getDomainConfigFile();
            DomainXmlSAXParser parser = new DomainXmlSAXParser();
            try {
                parser.parse(domainXml);
            }
            catch (Exception e) {
                throw new DomainException(strMgr.getString("domainXmlNotParsed"), e);
            }
            String className = parser.getDomainXmlEventListenerClass();
            if (className != null) {
                DomainXmlEventListener listener = (DomainXmlEventListener)Class.forName(className).newInstance();
                listener.handleCreateEvent(domainConfig);
            }
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("domainXmlEventsNotCreated"), e);
        }
    }

    protected TokenValueSet getDomainXmlTokens(DomainConfig domainConfig) {
        return PEDomainXmlTokens.getTokenValueSet(domainConfig);
    }

    protected void createDomainXml(DomainConfig domainConfig) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File dx = layout.getDomainConfigFile();
            TokenValueSet tokens = this.getDomainXmlTokens(domainConfig);
            String tn = (String)domainConfig.get("template.name");
            if (tn == null || tn.equals("")) {
                File tr = new File(layout.getTemplatesDir(), "domain.xml");
                this.generateFromTemplate(tokens, tr, dx);
            } else {
                File dxt = layout.getDomainXmlTemplate(tn);
                this.generateFromTemplate(tokens, dxt, dx);
            }
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("domainXmlNotCreated"), e);
        }
    }

    protected void createScripts(DomainConfig domainConfig) throws DomainException {
        TokenValueSet tokens = PEScriptsTokens.getTokenValueSet(domainConfig);
        this.createStartServ(domainConfig, tokens);
        this.createStopServ(domainConfig, tokens);
    }

    void createStartServ(DomainConfig domainConfig, TokenValueSet tokens) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File startServTemplate = layout.getStartServTemplate();
            File startServ = layout.getStartServ();
            this.generateFromTemplate(tokens, startServTemplate, startServ);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("startServNotCreated"), e);
        }
    }

    void createStopServ(DomainConfig domainConfig, TokenValueSet tokens) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File stopServTemplate = layout.getStopServTemplate();
            File stopServ = layout.getStopServ();
            this.generateFromTemplate(tokens, stopServTemplate, stopServ);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("stopServNotCreated"), e);
        }
    }

    protected void createAppClientContainerXml(DomainConfig domainConfig) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            for (Map.Entry<File, File> accXmlTemplateFileEntry : layout.getAppClientContainerTemplateAndXml().entrySet()) {
                File accXmlTemplate = accXmlTemplateFileEntry.getKey();
                File accXml = accXmlTemplateFileEntry.getValue();
                TokenValueSet tokens = PEAccXmlTokens.getTokenValueSet(domainConfig);
                this.generateFromTemplate(tokens, accXmlTemplate, accXml);
            }
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("accXmlNotCreated"), e);
        }
    }

    protected void createIndexFile(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        File src = layout.getIndexFileTemplate();
        File dest = layout.getIndexFile();
        try {
            TokenValueSet tokens = IndexHtmlTokens.getTokenValueSet(domainConfig);
            this.generateFromTemplate(tokens, src, dest);
            this.handleLocalizedIndexHtmls(layout, tokens);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("indexFileNotCreated"), ioe);
        }
    }

    protected void createLoggingProperties(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        File src = layout.getLoggingPropertiesTemplate();
        File dest = layout.getLoggingProperties();
        try {
            this.generateFromTemplate(new TokenValueSet(), src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("loggingPropertiesNotCreated"), ioe);
        }
    }

    private void handleLocalizedIndexHtmls(PEFileLayout layout, TokenValueSet tokens) {
        Locale locale = Locale.getDefault();
        if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
            return;
        }
        File src = layout.getNonEnglishIndexFileTemplate(locale);
        File dest = layout.getIndexFile();
        if (src.exists()) {
            if (!dest.renameTo(layout.getEnglishIndexFile())) {
                String zero = strMgr.getString("problemRenaming", dest.getAbsolutePath(), layout.getEnglishIndexFile().getAbsolutePath());
                System.out.println(zero);
                return;
            }
            dest = layout.getIndexFile();
            try {
                this.generateFromTemplate(tokens, src, dest);
            }
            catch (IOException e) {
                String one = strMgr.getString("problemCopyingIndexHtml", src.getAbsolutePath(), dest.getAbsolutePath());
                System.out.println(one);
            }
        } else {
            String two = strMgr.getString("localeFileNotFound", locale, src.getAbsolutePath());
            System.out.println(two);
        }
    }

    protected void createDefaultWebXml(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        File src = layout.getDefaultWebXmlTemplate();
        File dest = layout.getDefaultWebXml();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("defaultWebXmlNotCreated"), ioe);
        }
    }

    protected void createLoginConf(RepositoryConfig config) throws DomainException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getLoginConfTemplate();
        File dest = layout.getLoginConf();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("loginConfNotCreated"), ioe);
        }
    }

    protected void createWssServerConfigOld(RepositoryConfig config) throws DomainException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getWssServerConfigOldTemplate();
        File dest = layout.getWssServerConfigOld();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("wssserverconfignotcreated"), ioe);
        }
    }

    protected void createWssServerConfig(RepositoryConfig config) throws DomainException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getWssServerConfigTemplate();
        File dest = layout.getWssServerConfig();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("wssserverconfignotcreated"), ioe);
        }
    }

    protected File getDomainDir(DomainConfig domainConfig) {
        return this.getRepositoryDir(domainConfig);
    }

    protected File getDomainRoot(DomainConfig domainConfig) {
        return this.getRepositoryRootDir(domainConfig);
    }

    String getDefaultInstance() {
        return "server";
    }

    protected static String getDomainUser(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.user");
    }

    protected static String getDomainPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.password");
    }

    protected static String getMasterPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.masterPassword");
    }

    protected static String getNewMasterPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.newMasterPassword");
    }

    protected static boolean saveMasterPassword(DomainConfig domainConfig) {
        Boolean b = (Boolean)domainConfig.get("domain.saveMasterPassword");
        return b;
    }

    public void changeMasterPassword(DomainConfig config) throws DomainException {
        try {
            String oldPass = PEDomainsManager.getMasterPasswordClear(config);
            String newPass = PEDomainsManager.getNewMasterPasswordClear(config);
            this.changePasswordAliasKeystorePassword(config, oldPass, newPass);
            this.changeSSLCertificateDatabasePassword(config, oldPass, newPass);
            this.changeMasterPasswordInMasterPasswordFile(config, newPass, PEDomainsManager.saveMasterPassword(config));
        }
        catch (Exception ex) {
            throw new DomainException(strMgr.getString("masterPasswordNotChanged"), ex);
        }
    }

    @Override
    public String[] getExtraPasswordOptions(DomainConfig config) throws DomainException {
        return null;
    }
}

