/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.logging;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ModuleLogLevels;
import com.sun.enterprise.util.io.FileUtils;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class UpgradeLogging
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;
    @Inject
    LoggingConfigImpl logConfig;

    @Override
    public void postConstruct() {
        for (Config config : this.configs.getConfig()) {
            this.doUpgrade(config);
        }
    }

    private void doUpgrade(Config config) {
        LogService logService = config.getLogService();
        if (logService == null) {
            return;
        }
        try {
            RepositoryConfig rc = new RepositoryConfig();
            String configDir = rc.getRepositoryRoot() + File.separator + rc.getRepositoryName() + File.separator + rc.getInstanceName() + File.separator + "config";
            PEFileLayout layout = new PEFileLayout(rc);
            File src = new File(layout.getTemplatesDir(), "logging.properties");
            File dest = new File(configDir, "logging.properties");
            if (!dest.exists()) {
                FileUtils.copy(src, dest);
            }
        }
        catch (IOException ioe) {
            SLogger.getLogger().log(Level.SEVERE, "SERVERMGMT0008", ioe);
        }
        try {
            ModuleLogLevels mll = logService.getModuleLogLevels();
            Map<String, String> logLevels = mll.getAllLogLevels();
            String file = logService.getFile();
            String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
            if (file.contains(instanceRoot)) {
                file = file.replace(instanceRoot, "${com.sun.aas.instanceRoot}");
            }
            logLevels.put("file", file);
            logLevels.put("use-system-logging", logService.getUseSystemLogging());
            logLevels.put("log-handler", logService.getLogHandler());
            logLevels.put("log-filter", logService.getLogFilter());
            logLevels.put("log-to-console", logService.getLogToConsole());
            logLevels.put("log-rotation-limit-in-bytes", logService.getLogRotationLimitInBytes());
            logLevels.put("log-rotation-timelimit-in-minutes", logService.getLogRotationTimelimitInMinutes());
            logLevels.put("alarms", logService.getAlarms());
            logLevels.put("retain-error-statistics-for-hours", logService.getRetainErrorStatisticsForHours());
            final HashMap<String, String> m = new HashMap<String, String>(logLevels);
            ConfigSupport.apply(new SingleConfigCode<Config>(){

                @Override
                public Object run(Config c) throws PropertyVetoException, TransactionFailure {
                    try {
                        UpgradeLogging.this.logConfig.updateLoggingProperties(m);
                        c.setLogService(null);
                    }
                    catch (IOException e) {
                        SLogger.getLogger().log(Level.SEVERE, "SERVERMGMT0009", e);
                    }
                    return null;
                }
            }, config);
        }
        catch (TransactionFailure tf) {
            SLogger.getLogger().log(Level.SEVERE, "SERVERMGMT0010", tf);
            throw new RuntimeException(tf);
        }
    }
}

